/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.db2.plan.Db2PlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2ExplainPlanProvider
extends AbstractExplainPlanProvider {
    private static String ourExplainPlanQuery;

    public Db2ExplainPlanProvider(Dbms dbms) {
        super(dbms);
    }

    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run) {
        if (version == null) {
            Db2ExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return new Db2PlanModelBuilder();
    }

    @Nullable
    public ExplainPlanProvider.RawExplainTask createRawExplainTask(@NotNull LocalDataSource dataSource, boolean analyze) {
        if (dataSource == null) {
            Db2ExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return new ExplainPlanProvider.RawExplainTask(this){

            public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement) throws UnsupportedOperationException, IllegalArgumentException {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                Db2ExplainPlanProvider.ensureScriptLoaded();
                if (ourExplainPlanQuery.isEmpty()) {
                    throw new UnsupportedOperationException("explain_last script not found");
                }
                builder.keywords(new String[]{"explain", "plan"}).space().keyword("for").space().plain(statement).newStatement().plain(ourExplainPlanQuery);
                return builder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statement";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dialects/db2/plan/Db2ExplainPlanProvider$1";
                objectArray[2] = "sqlExplainPlan";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void ensureScriptLoaded() {
        if (ourExplainPlanQuery == null) {
            try (InputStream stream = Db2ExplainPlanProvider.class.getResourceAsStream("db2.explain_last.sql");){
                ourExplainPlanQuery = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)));
                return;
            }
            catch (IOException iOException) {
                ourExplainPlanQuery = "";
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/db2/plan/Db2ExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRawExplainTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

