/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.couchbase;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.couchbase.CouchbaseReservedKeywords;
import com.intellij.sql.dialects.couchbase.CouchbaseTokens;
import com.intellij.sql.dialects.couchbase.CouchbaseTypes;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.symbols.virtual.DasVirtualColumnSymbol;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CouchbaseDialect
extends SqlLanguageDialectBase {
    public static final CouchbaseDialect INSTANCE = new CouchbaseDialect();

    private CouchbaseDialect() {
        super("CouchbaseQuery");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(CouchbaseTokens.class);
        if (tokensHelper == null) {
            CouchbaseDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        Collection res = super.getParentDbTypes(result, type);
        if (type == ObjectKind.COLUMN) {
            res.add(ObjectKind.COLUMN);
        }
        return (T)res;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        IElementType opSign;
        SqlJoinExpression join;
        if (expectedTypes == null) {
            CouchbaseDialect.$$$reportNull$$$0(1);
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN) && symbol != null && (join = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)symbol.getContextElement(), SqlJoinExpression.class)) != null && (opSign = PsiUtilCore.getElementType((PsiElement)join.getOpSignElement())) == CouchbaseTypes.COUCH_UNNEST) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        if (dbms == null) {
            CouchbaseDialect.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"JSON", (String)"json", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"ID", (String)"identifier", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"ATOM", (String)"atomic", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CouchbaseDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean supportsNestedColumns() {
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            CouchbaseDialect.$$$reportNull$$$0(4);
        }
        if (state == null) {
            CouchbaseDialect.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            CouchbaseDialect.$$$reportNull$$$0(6);
        }
        if (qualifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(7);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN}) && PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), SqlSetClause.class) != null) {
            DasVirtualColumnSymbol symbol;
            SqlElement element = (SqlElement)ObjectUtils.tryCast((Object)ref.getElement(), SqlElement.class);
            if (element == null) {
                return super.processQualifiedResolve(processor, state, ref, qualifier);
            }
            SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)element, SqlSetAssignment.class);
            if ((assignment == null || PsiTreeUtil.isAncestor((PsiElement)assignment.getLValue(), (PsiElement)element, (boolean)false)) && !processor.execute((DasSymbol)(symbol = new DasVirtualColumnSymbol(ref.getReferenceName(), ref.isQuoted(), (PsiElement)element)), state)) {
                return false;
            }
        }
        return super.processQualifiedResolve(processor, state, ref, qualifier);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        return PsiUtilCore.getElementType((PsiElement)o.getFirstChild()) == CouchbaseReservedKeywords.COUCH_SYSTEM && SqlImplUtil.isQualifier((PsiElement)o.getParent(), (ObjectKind)ObjectKind.TABLE) ? null : super.checkIdentifierIsKeyword(o, manager, onTheFly, pl);
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false})})});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_IN, SqlCommonTokens.SQL_OP_MODULO);
        static final TokenSet ourClosingTokens = SqlCommonTokens.STATEMENT_SEPARATORS;

        LazyData() {
        }
    }
}

