/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.util.JavaeeJdomUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.EmptyQuery;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import java.io.File;
import java.util.Collections;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;

public final class DeploymentDescriptorUtil {
    @NonNls
    public static final String[] WEB_DTDS = new String[]{"http://java.sun.com/j2ee/dtds/web-app_2_2.dtd", "http://java.sun.com/j2ee/dtds/web-app_2_3.dtd", "http://java.sun.com/dtd/web-app_2_3.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"};
    @NonNls
    public static final String[] JAVAEE_DTDS = new String[]{"http://java.sun.com/j2ee/dtds/application_1_2.dtd", "http://java.sun.com/dtd/application_1_3.dtd", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN"};
    @NonNls
    private static final String[] DTD_VERSIONS = new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd", "2.2", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd", "2.3", "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.0//EN", "http://java.sun.com/j2ee/dtds/ejb-jar_1_0.dtd", EjbDescriptorVersion.EJB_VERSION_1_X.getValue(), "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd", EjbDescriptorVersion.EJB_VERSION_1_X.getValue(), "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd", EjbDescriptorVersion.EJB_VERSION_2_0.getValue(), "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "http://java.sun.com/j2ee/dtds/application_1_2.dtd", "1.2", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd", "1.3"};
    @NonNls
    private static final String[] XSD_VERSIONS = new String[]{"ejb-jar", "http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd", EjbDescriptorVersion.EJB_VERSION_2_1.getValue(), "ejb-jar", "http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd", EjbDescriptorVersion.EJB_VERSION_3_0.getValue(), "web-app", "http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "2.4", "web-app", "http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", "2.5", "application", "http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "1.4", "application", "http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application_5.xsd", "5", "application", "http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application_6.xsd", "6", "application", "http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/application_7.xsd", "7", "application", "http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/application_8.xsd", "8", "persistence", "http://java.sun.com/xml/ns/persistence", "http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd", "1.0", "entity-mappings", "http://java.sun.com/xml/ns/persistence/orm", "http://java.sun.com/xml/ns/persistence/orm_1_0.xsd", "1.0"};

    public static Query<File> findFileRecursively(File parentDirectory, String fileName, int levels, long timeout) {
        if (parentDirectory == null) {
            return new EmptyQuery();
        }
        QueryExecutor executor = (queryParameters, consumer) -> {
            long endTime = timeout < 0L ? -1L : System.currentTimeMillis() + timeout;
            return DeploymentDescriptorUtil.processFileRecursively(parentDirectory.getAbsoluteFile(), 1, levels, (Processor<? super File>)((Processor)file -> {
                if (endTime > 0L && System.currentTimeMillis() > endTime) {
                    return false;
                }
                return !file.getName().equals(fileName) || consumer.process(file);
            }));
        };
        return new ExecutorsQuery((Object)fileName, Collections.singletonList(executor));
    }

    private static boolean processFileRecursively(File parentDirectory, int curLevel, int maxLevel, Processor<? super File> processor) {
        File[] files = parentDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!(file.isDirectory() ? curLevel < maxLevel && !DeploymentDescriptorUtil.processFileRecursively(file, curLevel + 1, maxLevel, processor) : !processor.process((Object)file))) continue;
                return false;
            }
        }
        return true;
    }

    public static String guessVersion(File file) {
        if (FileTypeManager.getInstance().getFileTypeByFileName(file.getName()) != XmlFileType.INSTANCE) {
            return null;
        }
        try {
            Document document = JavaeeJdomUtil.loadDocument(file);
            Element root = document.getRootElement();
            String version = root.getAttributeValue("version");
            if (version != null) {
                return version;
            }
            DocType docType = document.getDocType();
            if (docType != null) {
                for (int i = 0; i < DTD_VERSIONS.length; i += 3) {
                    String publicId = DTD_VERSIONS[i];
                    String systemId = DTD_VERSIONS[i + 1];
                    version = DTD_VERSIONS[i + 2];
                    if (!publicId.equals(docType.getPublicID()) && !systemId.equals(docType.getSystemID())) continue;
                    return version;
                }
            }
            if (document.getRootElement() != null) {
                @NonNls String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
                @NonNls String XSI_SCHEMA_LOCATION_ATTR = "schemaLocation";
                @NonNls String VERSION_ATTR = "version";
                Element element = document.getRootElement();
                String name = element.getName();
                String namespace = element.getNamespaceURI();
                String schemaLocation = element.getAttributeValue("schemaLocation", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
                String versionAttr = element.getAttributeValue("version");
                if (versionAttr != null) {
                    return versionAttr;
                }
                for (int i = 0; i < XSD_VERSIONS.length; i += 4) {
                    String rootTag = XSD_VERSIONS[i];
                    String ns = XSD_VERSIONS[i + 1];
                    String location = XSD_VERSIONS[i + 2];
                    version = XSD_VERSIONS[i + 3];
                    if (!rootTag.equals(name) || !ns.equals(namespace) && (schemaLocation == null || !schemaLocation.endsWith(location))) continue;
                    return version;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

