/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommon;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.module.components.JavaeeFacetEventsPropagator;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileAdapter;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaeeFacetCommonPartImpl
implements Disposable,
JavaeeFacetCommonPart {
    private final ConfigFileContainer myDescriptorsContainer;
    private final JavaeeFacet myFacet;
    private final Project myProject;
    private CachedValue<List<? extends PackagingElement<?>>> myCachedResourcesElements;

    public JavaeeFacetCommonPartImpl(JavaeeFacet facet, ConfigFileMetaDataProvider metaDataProvider, ConfigFileInfoSet configuration) {
        this.myFacet = facet;
        Project project = this.myProject = this.myFacet.getModule().getProject();
        this.myDescriptorsContainer = ConfigFileFactory.getInstance().createConfigFileContainer(project, metaDataProvider, configuration);
        Disposer.register((Disposable)this, (Disposable)this.myDescriptorsContainer);
        this.myDescriptorsContainer.addListener((ConfigFileListener)new ConfigFileAdapter(){

            protected void configChanged(ConfigFile configFile) {
                JavaeeUtil.fireFacetChanged(JavaeeFacetCommonPartImpl.this.myFacet);
                JavaeeFacetCommonPartImpl.this.fireFacetChanged();
            }
        });
        JavaeeFacetEventsPropagator.subscribe(project);
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myDescriptorsContainer;
    }

    public void fireFacetChanged() {
        ((JavaeeFacetCommon)this.myFacet).onFacetChanged();
    }

    public Collection<VirtualFile> getDescriptors() {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (ConfigFile configFile : this.myDescriptorsContainer.getConfigFiles()) {
            ContainerUtil.addIfNotNull(list, (Object)configFile.getVirtualFile());
        }
        return list;
    }

    public void dispose() {
    }

    public ModificationTracker getModificationTracker() {
        return FacetModificationTrackingService.getInstance((Project)this.getDescriptorsContainer().getProject()).getFacetModificationTracker((Facet)this.myFacet);
    }

    public boolean isAllDescriptorsValid() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            for (ConfigFile descriptor : this.getDescriptorsContainer().getConfigFiles()) {
                if (descriptor.isValid()) continue;
                return false;
            }
            return true;
        });
    }

    public List<? extends PackagingElement<?>> getFacetResourcesPackagingElements() {
        if (this.myCachedResourcesElements == null) {
            this.myCachedResourcesElements = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                ArrayList<PackagingElement> elements = new ArrayList<PackagingElement>();
                PackagingElementFactory factory = PackagingElementFactory.getInstance();
                if (this.myFacet instanceof WebFacet) {
                    List webRoots = ((WebFacet)this.myFacet).getWebRoots();
                    for (WebRoot webRoot : webRoots) {
                        elements.add(factory.createDirectoryCopyWithParentDirectories(PathUtil.toPresentableUrl((String)webRoot.getDirectoryUrl()), webRoot.getRelativePath()));
                    }
                }
                for (ConfigFile configFile : this.myDescriptorsContainer.getConfigFiles()) {
                    ConfigFileMetaData metaData = configFile.getMetaData();
                    String outputFileName = metaData.isFileNameFixed() ? metaData.getFileName() : null;
                    elements.add(factory.createFileCopyWithParentDirectories(PathUtil.toPresentableUrl((String)configFile.getUrl()), metaData.getDirectoryPath(), outputFileName));
                }
                return CachedValueProvider.Result.createSingleDependency(elements, (Object)this.getModificationTracker());
            }, false);
        }
        return (List)this.myCachedResourcesElements.getValue();
    }
}

