/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;

@ApiStatus.Internal
public final class JarBasedArtifactRootDescriptor
extends ArtifactRootDescriptor {
    private final String myPathInJar;
    private final Predicate<? super String> myPathInJarFilter;

    public JarBasedArtifactRootDescriptor(@NotNull File jarFile, @NotNull String pathInJar, @NotNull SourceFileFilter filter, int index, @NotNull ArtifactBuildTarget target, @NotNull DestinationInfo destinationInfo, @NotNull Predicate<? super String> pathInJarFilter) {
        if (jarFile == null) {
            JarBasedArtifactRootDescriptor.$$$reportNull$$$0(0);
        }
        if (pathInJar == null) {
            JarBasedArtifactRootDescriptor.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            JarBasedArtifactRootDescriptor.$$$reportNull$$$0(2);
        }
        if (target == null) {
            JarBasedArtifactRootDescriptor.$$$reportNull$$$0(3);
        }
        if (destinationInfo == null) {
            JarBasedArtifactRootDescriptor.$$$reportNull$$$0(4);
        }
        if (pathInJarFilter == null) {
            JarBasedArtifactRootDescriptor.$$$reportNull$$$0(5);
        }
        super(jarFile, filter, index, target, destinationInfo);
        this.myPathInJar = pathInJar;
        this.myPathInJarFilter = pathInJarFilter;
    }

    public void processEntries(EntryProcessor processor) throws IOException {
        if (!this.myRoot.isFile()) {
            return;
        }
        Object prefix = Strings.trimStart((String)this.myPathInJar, (String)"/");
        if (!Strings.endsWithChar((CharSequence)prefix, (char)'/')) {
            prefix = (String)prefix + "/";
        }
        if (((String)prefix).equals("/")) {
            prefix = "";
        }
        try (ZipFile zipFile = new ZipFile(this.myRoot);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith((String)prefix) || !this.myPathInJarFilter.test(relativePath = name.substring(((String)prefix).length()))) continue;
                processor.process(entry.isDirectory() ? null : zipFile.getInputStream(entry), relativePath, entry);
            }
        }
        catch (IOException e) {
            throw new IOException("Error occurred during processing zip file " + String.valueOf(this.myRoot) + ": " + e.getMessage(), e);
        }
    }

    @Override
    protected String getFullPath() {
        return this.myRoot.getPath() + "!/" + this.myPathInJar;
    }

    @Override
    public void copyFromRoot(final String filePath, final int rootIndex, final String outputPath, CompileContext context, final BuildOutputConsumer outputConsumer, final ArtifactOutputToSourceMapping outSrcMapping) throws IOException {
        if (!this.myRoot.isFile()) {
            return;
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        if (logger.isEnabled()) {
            logger.logCompiledPaths(Collections.singletonList(filePath), "artifacts-builder", "Extracting archive:");
        }
        this.processEntries(new EntryProcessor(){

            @Override
            public void process(@Nullable InputStream inputStream, @NotNull String relativePath, ZipEntry entry) throws IOException {
                if (relativePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                String fullOutputPath = JpsArtifactPathUtil.appendToPath(outputPath, relativePath);
                File outputFile = new File(fullOutputPath);
                FileUtilRt.createParentDirs((File)outputFile);
                if (inputStream == null) {
                    outputFile.mkdir();
                } else {
                    if (outSrcMapping.getState(fullOutputPath) == null) {
                        try (BufferedInputStream from = new BufferedInputStream(inputStream);
                             BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(outputFile));){
                            FileUtilRt.copy((InputStream)from, (OutputStream)to);
                        }
                        outputConsumer.registerOutputFile(outputFile, Collections.singletonList(filePath));
                    }
                    outSrcMapping.appendData(fullOutputPath, rootIndex, filePath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/jps/incremental/artifacts/instructions/JarBasedArtifactRootDescriptor$1", "process"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "jarFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pathInJar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "filter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "destinationInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "pathInJarFilter";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/incremental/artifacts/instructions/JarBasedArtifactRootDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface EntryProcessor {
        public void process(@Nullable InputStream var1, @NotNull String var2, ZipEntry var3) throws IOException;
    }
}

