/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.jam.mq;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.microservices.jvm.mq.MQDestinationAnchor;
import com.intellij.microservices.jvm.mq.MQProviderType;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.MQTypes;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.messaging.jam.mq.SpringBooleanStringConverter;
import com.intellij.spring.messaging.jam.mq.SpringKafkaTopicPartition;
import com.intellij.spring.messaging.jam.mq.SpringMQListener;
import com.intellij.spring.messaging.jam.mq.SpringMQReferenceJamConverter;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringKafkaListener
implements SpringMQListener {
    private static final JamStringAttributeMeta.Single<String> AUTO_STARTUP_META = JamAttributeMeta.singleString((String)"autoStartup", (JamConverter)new SpringBooleanStringConverter());
    private static final JamStringAttributeMeta.Collection<String> TOPICS_META = JamAttributeMeta.collectionString((String)"topics", (JamConverter)new SpringMQReferenceJamConverter((MQProviderType)MQTypes.KAFKA_TOPIC_TYPE));
    public static final JamAnnotationAttributeMeta.Collection<SpringKafkaTopicPartition> TOPIC_PARTITIONS_META = JamAttributeMeta.annoCollection((String)"topicPartitions", (JamAnnotationMeta)SpringKafkaTopicPartition.ANNOTATION_META, psiAnnotation -> new SpringKafkaTopicPartition((PsiAnnotation)psiAnnotation));
    private static final JamStringAttributeMeta.Single<SpringBeanPointer<?>> CONTAINER_FACTORY_META = JamAttributeMeta.singleString((String)"containerFactory", (JamConverter)new SpringBeanReferenceJamConverter(new String[]{"org.springframework.kafka.config.KafkaListenerContainerFactory"}));
    private static final JamStringAttributeMeta.Single<SpringBeanPointer<?>> ERROR_HANDLER_META = JamAttributeMeta.singleString((String)"errorHandler", (JamConverter)new SpringBeanReferenceJamConverter(new String[]{"org.springframework.kafka.listener.KafkaListenerErrorHandler"}));
    private static final JamStringAttributeMeta.Single<SpringBeanPointer<?>> GROUP_META = JamAttributeMeta.singleString((String)"containerGroup", (JamConverter)new SpringBeanReferenceJamConverter(new String[]{"java.util.Collection"}));
    public static final SemKey<SpringKafkaListener> REPEATABLE_ANNO_JAM_KEY = SPRING_MQ_LISTENER_KEY.subKey("SpringKafkaListener", new SemKey[0]);
    public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.kafka.annotation.KafkaListener", new JamAnnotationArchetype().addAttribute(AUTO_STARTUP_META).addAttribute(TOPICS_META).addAttribute(TOPIC_PARTITIONS_META).addAttribute(CONTAINER_FACTORY_META).addAttribute(ERROR_HANDLER_META).addAttribute(GROUP_META), SPRING_MQ_LISTENER_META_KEY);
    public static final JamMethodMeta<SpringKafkaListener> META = new JamMethodMeta(null, SpringKafkaListener::new, REPEATABLE_ANNO_JAM_KEY).addAnnotation(ANNOTATION_META);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    @Nullable
    private final PsiAnchor myPsiMemberAnchor;

    public SpringKafkaListener(PsiElementRef<?> psiRef) {
        PsiModifierListOwner psiMember = (PsiModifierListOwner)Objects.requireNonNull(psiRef.getPsiElement());
        this.myPsiAnnotation = ANNOTATION_META.getAnnotationRef(psiMember);
        this.myPsiMemberAnchor = PsiAnchor.create((PsiElement)psiMember);
    }

    public SpringKafkaListener(PsiAnnotation annotation) {
        PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class, (boolean)true);
        this.myPsiMemberAnchor = psiMember != null ? PsiAnchor.create((PsiElement)psiMember) : null;
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)annotation);
    }

    @Nullable
    public PsiMember getPsiElement() {
        if (this.myPsiMemberAnchor == null) {
            return null;
        }
        return (PsiMember)this.myPsiMemberAnchor.retrieveOrThrow();
    }

    public boolean isValid() {
        return this.myPsiMemberAnchor != null && this.myPsiMemberAnchor.retrieve() != null;
    }

    @NotNull
    public List<JamStringAttributeElement<String>> getTopicElements() {
        List list = TOPICS_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            SpringKafkaListener.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<SpringKafkaTopicPartition> getTopicPartitions() {
        List list = TOPIC_PARTITIONS_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            SpringKafkaListener.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MQDestinationAnchor> getMQDestinations() {
        SmartList destinations = new SmartList();
        for (JamStringAttributeElement<String> topic : this.getTopicElements()) {
            SpringMQUtils.collectDestination(topic, (MQType)MQTypes.KAFKA_TOPIC_TYPE, (List<MQDestinationAnchor>)destinations);
        }
        for (SpringKafkaTopicPartition partition : this.getTopicPartitions()) {
            SpringMQUtils.collectDestination(partition.getTopicElement(), (MQType)MQTypes.KAFKA_TOPIC_TYPE, (List<MQDestinationAnchor>)destinations);
        }
        SmartList smartList = destinations;
        if (smartList == null) {
            SpringKafkaListener.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringKafkaListener listener = (SpringKafkaListener)o;
        return Objects.equals(this.myPsiAnnotation, listener.myPsiAnnotation) && Objects.equals(this.myPsiMemberAnchor, listener.myPsiMemberAnchor);
    }

    public int hashCode() {
        return Objects.hash(this.myPsiAnnotation, this.myPsiMemberAnchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/messaging/jam/mq/SpringKafkaListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicPartitions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMQDestinations";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

