/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.backend.split;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.patterns.ElementPattern;
import com.intellij.platform.completion.backend.split.BackendCompletionSessionImpl;
import com.intellij.platform.completion.backend.split.BackendCompletionSessionKt;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionResponseEvent;
import com.intellij.util.ObjectUtils;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170)H\u0016J\u0006\u0010*\u001a\u00020'J\u001a\u0010+\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\u00020'2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0016J\u001a\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002052\b\u00108\u001a\u0004\u0018\u000109H\u0016J\n\u0010:\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\u0015H\u0016J\b\u0010=\u001a\u00020'H\u0016J\b\u0010>\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/platform/completion/backend/split/BackendCompletionProcess;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/codeInsight/completion/CompletionProcessEx;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "myHostOffsets", "Lcom/intellij/codeInsight/completion/OffsetsInFile;", "myOffsetMap", "Lcom/intellij/codeInsight/completion/OffsetMap;", "responseChannel", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionResponseEvent;", "session", "Lcom/intellij/platform/completion/backend/split/BackendCompletionSessionImpl;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/completion/OffsetsInFile;Lcom/intellij/codeInsight/completion/OffsetMap;Lkotlinx/coroutines/channels/SendChannel;Lcom/intellij/platform/completion/backend/split/BackendCompletionSessionImpl;)V", "getMyHostOffsets", "()Lcom/intellij/codeInsight/completion/OffsetsInFile;", "setMyHostOffsets", "(Lcom/intellij/codeInsight/completion/OffsetsInFile;)V", "myParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "disposableLock", "", "isAutopopupCompletion", "", "getProject", "Lcom/intellij/openapi/project/Project;", "getEditor", "getCaret", "Lcom/intellij/openapi/editor/Caret;", "getOffsetMap", "getHostOffsets", "getLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "registerChildDisposable", "", "child", "Ljava/util/function/Supplier;", "dispose", "itemSelected", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionChar", "", "addWatchedPrefix", "startOffset", "", "restartCondition", "Lcom/intellij/patterns/ElementPattern;", "", "addAdvertisement", "message", "icon", "Ljavax/swing/Icon;", "getParameters", "setParameters", "parameters", "scheduleRestart", "prefixUpdated", "intellij.platform.completion.backend.split"})
final class BackendCompletionProcess
extends UserDataHolderBase
implements CompletionProcessEx {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private OffsetsInFile myHostOffsets;
    @NotNull
    private final OffsetMap myOffsetMap;
    @NotNull
    private final SendChannel<RpcCompletionResponseEvent> responseChannel;
    @NotNull
    private final BackendCompletionSessionImpl session;
    @Nullable
    private CompletionParameters myParameters;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final Object disposableLock;

    public BackendCompletionProcess(@NotNull Editor myEditor, @NotNull OffsetsInFile myHostOffsets, @NotNull OffsetMap myOffsetMap, @NotNull SendChannel<? super RpcCompletionResponseEvent> responseChannel, @NotNull BackendCompletionSessionImpl session) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myHostOffsets, (String)"myHostOffsets");
        Intrinsics.checkNotNullParameter((Object)myOffsetMap, (String)"myOffsetMap");
        Intrinsics.checkNotNullParameter(responseChannel, (String)"responseChannel");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.myEditor = myEditor;
        this.myHostOffsets = myHostOffsets;
        this.myOffsetMap = myOffsetMap;
        this.responseChannel = responseChannel;
        this.session = session;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        Object object = ObjectUtils.sentinel((String)"disposableLock");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.disposableLock = object;
    }

    @NotNull
    public final OffsetsInFile getMyHostOffsets() {
        return this.myHostOffsets;
    }

    public final void setMyHostOffsets(@NotNull OffsetsInFile offsetsInFile) {
        Intrinsics.checkNotNullParameter((Object)offsetsInFile, (String)"<set-?>");
        this.myHostOffsets = offsetsInFile;
    }

    public boolean isAutopopupCompletion() {
        return this.session.getRequest().getInvocationCount() == 0;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myEditor.getProject();
        Intrinsics.checkNotNull((Object)project);
        return project;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public Caret getCaret() {
        Caret caret = this.myEditor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        return caret;
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    @NotNull
    public OffsetsInFile getHostOffsets() {
        return this.myHostOffsets;
    }

    @NotNull
    public Lookup getLookup() {
        throw new UnsupportedOperationException("getLookup is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChildDisposable(@NotNull Supplier<? extends Disposable> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Object object = this.disposableLock;
        synchronized (object) {
            boolean bl = false;
            if (!this.session.isActive()) {
                throw new IllegalStateException("Completion session is not active " + this.session.getRequest());
            }
            Disposer.register((Disposable)this.disposable, (Disposable)child.get());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.disposableLock;
        synchronized (object) {
            boolean bl = false;
            Disposer.dispose((Disposable)this.disposable);
            Unit unit = Unit.INSTANCE;
        }
    }

    public void itemSelected(@Nullable LookupElement item, char completionChar) {
        throw new UnsupportedOperationException("itemSelected is not supported in backend completion process");
    }

    public void addWatchedPrefix(int startOffset, @NotNull ElementPattern<String> restartCondition) {
        Intrinsics.checkNotNullParameter(restartCondition, (String)"restartCondition");
        BackendCompletionSessionKt.access$registerWatchedPrefix(this.responseChannel, startOffset, restartCondition);
    }

    public void addAdvertisement(@NotNull String message, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BackendCompletionSessionKt.access$registerAdvertisement(this.responseChannel, message, icon, this.session.getRequest());
    }

    @Nullable
    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    public void setParameters(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.myParameters = parameters;
    }

    public void scheduleRestart() {
        throw new UnsupportedOperationException("scheduleRestart is not supported in backend completion process");
    }

    public void prefixUpdated() {
        throw new UnsupportedOperationException("prefixUpdated is not supported in backend completion process");
    }
}

