/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManagerState;
import com.intellij.docker.registry.node.presentation.DockerRegistryRootInterface;
import com.intellij.docker.splitApi.registry.DockerRegistryDtoConvertersKt;
import com.intellij.docker.splitApi.registry.DockerRegistryEventCollector;
import com.intellij.docker.splitApi.registry.DockerRegistryManagerInterface;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="DockerRegistry", storages={@Storage(value="docker-registry.xml")}, category=SettingsCategory.TOOLS)
public class DockerRegistryManager
implements PersistentStateComponent<DockerRegistryManagerState>,
DockerRegistryManagerInterface {
    private final List<DockerRegistryConfiguration> myConfigurations = new CopyOnWriteArrayList<DockerRegistryConfiguration>();
    private final List<DockerRegistryRoot> myRegistries = new ArrayList<DockerRegistryRoot>();

    public static DockerRegistryManager getInstance() {
        return (DockerRegistryManager)ApplicationManager.getApplication().getService(DockerRegistryManager.class);
    }

    public @Unmodifiable List<DockerRegistryConfiguration> getRegistries() {
        return List.copyOf(this.myConfigurations);
    }

    @ApiStatus.Internal
    public @Unmodifiable List<DockerRegistryRoot> getRegistryRoots() {
        return List.copyOf(this.myRegistries);
    }

    @Nls
    public static String generateUniqueRegistryName() {
        @Nls String defaultName = DockerBundle.message((String)"RegistrySelectionEditor.default.name.docker.registry", (Object[])new Object[0]);
        return UniqueNameGenerator.generateUniqueName((String)defaultName, s -> {
            for (DockerRegistryConfiguration server2 : DockerRegistryManager.getInstance().getRegistries()) {
                if (!server2.getName().equals(s)) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    public DockerRegistryManagerState getState() {
        DockerRegistryManagerState state = new DockerRegistryManagerState();
        state.myRegistries.addAll(this.getRegistries());
        return state;
    }

    public void loadState(@NotNull DockerRegistryManagerState state) {
        if (state == null) {
            DockerRegistryManager.$$$reportNull$$$0(0);
        }
        this.myConfigurations.clear();
        this.myRegistries.clear();
        for (DockerRegistryConfiguration next : state.myRegistries) {
            next.migrateToPasswordSafe();
            this.myConfigurations.add(next);
            DockerRegistryRoot root = DockerRegistryManager.createRegistryRoot(next);
            if (root == null) continue;
            this.myRegistries.add(root);
        }
    }

    public void addRegistry(@NotNull DockerRegistryConfiguration registry) {
        if (registry == null) {
            DockerRegistryManager.$$$reportNull$$$0(1);
        }
        this.myConfigurations.add(registry);
        DockerRegistryRoot root = DockerRegistryManager.createRegistryRoot(registry);
        if (root != null) {
            this.myRegistries.add(root);
            DockerRegistryEventCollector.Companion.getInstance().fireRegistryAdded(DockerRegistryDtoConvertersKt.toRegistryDto(root));
        }
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Listener.TOPIC)).registryAdded(registry);
    }

    public void removeRegistry(@NotNull DockerRegistryConfiguration registry) {
        if (registry == null) {
            DockerRegistryManager.$$$reportNull$$$0(2);
        }
        if (!this.myConfigurations.remove((Object)registry)) {
            return;
        }
        DockerRegistryRoot root = DockerRegistryManager.findRegistryRoot(registry);
        if (root != null) {
            this.myRegistries.remove(root);
            DockerRegistryEventCollector.Companion.getInstance().fireRegistryRemoved(DockerRegistryDtoConvertersKt.toRegistryDto(root));
        }
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Listener.TOPIC)).registryRemoved(registry);
    }

    @ApiStatus.Internal
    public void removeRegistryById(@NotNull String registryId) {
        DockerRegistryRoot root;
        if (registryId == null) {
            DockerRegistryManager.$$$reportNull$$$0(3);
        }
        if ((root = this.findRegistryRootById(registryId)) == null) {
            return;
        }
        this.myRegistries.remove(root);
        this.myConfigurations.remove((Object)root.getConfiguration());
        DockerRegistryEventCollector.Companion.getInstance().fireRegistryRemoved(DockerRegistryDtoConvertersKt.toRegistryDto(root));
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Listener.TOPIC)).registryRemoved(root.getConfiguration());
    }

    @NotNull
    public @NotNull List<@NotNull DockerRegistryRootInterface> getDockerRegistryPresentations() {
        return new ArrayList<DockerRegistryRootInterface>(DockerRegistryManager.getInstance().getRegistryRoots());
    }

    private static DockerRegistryRoot createRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
        if (registry == null) {
            DockerRegistryManager.$$$reportNull$$$0(4);
        }
        return DockerRegistryProvider.Companion.getRegistryRoot(registry);
    }

    private static DockerRegistryRoot findRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
        if (registry == null) {
            DockerRegistryManager.$$$reportNull$$$0(5);
        }
        return (DockerRegistryRoot)ContainerUtil.find(DockerRegistryManager.getInstance().getRegistryRoots(), root -> root.getConfiguration() == registry);
    }

    @ApiStatus.Internal
    @Nullable
    public DockerRegistryRoot findRegistryRootById(@NotNull String registryId) {
        if (registryId == null) {
            DockerRegistryManager.$$$reportNull$$$0(6);
        }
        return (DockerRegistryRoot)ContainerUtil.find(DockerRegistryManager.getInstance().getRegistryRoots(), root -> registryId.equals(root.getDockerRegistryRootContext().getRegistry().getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/registry/DockerRegistryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRegistry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRegistryById";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRegistryRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findRegistryRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findRegistryRootById";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public static final Topic<Listener> TOPIC = Topic.create((String)"DockerRegistryManager.topic", Listener.class);

        public void registryAdded(@NotNull DockerRegistryConfiguration var1);

        public void registryRemoved(@NotNull DockerRegistryConfiguration var1);
    }
}

