/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.image;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.image.DockerSearchImageTextField;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContextKt;
import com.intellij.docker.ui.utils.DockerRedirectToTerminal;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u001a\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f2\u0006\u0010\"\u001a\u00020#J\u001c\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\n\u0010'\u001a\u0004\u0018\u00010#H\u0002J\b\u0010(\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010)\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/intellij/docker/view/details/image/ImagePullPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "runtime", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;)V", "spinningLabel", "Lcom/intellij/ui/components/JBLabel;", "operationLabel", "imageTagField", "Lcom/intellij/docker/image/DockerSearchImageTextField;", "terminalPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "pullQueue", "Ljava/util/Deque;", "", "terminalHandler", "Lcom/intellij/remoteServer/impl/runtime/log/TerminalHandlerBase;", "mainPanel", "Ljavax/swing/JComponent;", "getMainPanel$intellij_clouds_docker", "()Ljavax/swing/JComponent;", "dispose", "", "doPull", "requestPull", "request", "pullNextOne", "pullImage", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "tag", "Lcom/intellij/docker/agent/DockerRepoTag;", "asyncPullImage", "Ljava/util/concurrent/BlockingQueue;", "", "chooseNextValidTagToPull", "refreshQueueLabel", "focusManager", "Lcom/intellij/openapi/wm/IdeFocusManager;", "getFocusManager", "()Lcom/intellij/openapi/wm/IdeFocusManager;", "Companion", "intellij.clouds.docker"})
public final class ImagePullPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DockerGroupRuntime.ImagesGroup runtime;
    @NotNull
    private final JBLabel spinningLabel;
    @NotNull
    private final JBLabel operationLabel;
    @NotNull
    private final DockerSearchImageTextField imageTagField;
    @NotNull
    private final DockerTerminalPipe.WithTty terminalPipe;
    @NotNull
    private final Deque<String> pullQueue;
    @NotNull
    private final TerminalHandlerBase terminalHandler;
    @NotNull
    private final JComponent mainPanel;
    public static final int ICON_GAP = 6;

    public ImagePullPanel(@NotNull Project project, @NotNull DockerGroupRuntime.ImagesGroup runtime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.project = project;
        this.runtime = runtime;
        this.spinningLabel = new JBLabel((Icon)new AnimatedIcon.Default());
        this.operationLabel = new JBLabel("");
        this.terminalPipe = InternalUtilsKt.makeTerminalPipeWithTty();
        this.pullQueue = new ArrayDeque();
        this.terminalPipe.setShowCursor(false);
        this.imageTagField = new DockerSearchImageTextField(this.project);
        this.imageTagField.setPreferredSize(new JTextField(30).getPreferredSize());
        ShortcutSet shortcut = CommonShortcuts.getCtrlEnter();
        DialogPanel imageTagPanel = BuilderKt.panel(arg_0 -> ImagePullPanel._init_$lambda$0(this, shortcut, arg_0));
        this.mainPanel = new JPanel(new BorderLayout(0, 0));
        Object object = new JPanel((LayoutManager)new HorizontalLayout(6, 0, 2, null));
        JPanel it = object;
        boolean bl = false;
        it.setBorder((Border)JBUI.Borders.emptyRight((int)ImagePullPanel.Companion.scale(10)));
        it.add((Component)new JBLabel(), "LEFT");
        it.add((Component)imageTagPanel, "LEFT");
        it.add((Component)this.operationLabel, "RIGHT");
        it.add((Component)this.spinningLabel, "RIGHT");
        JPanel topRow = object;
        this.mainPanel.add((Component)topRow, "North");
        DockerTerminalPipe dockerTerminalPipe = (DockerTerminalPipe)this.terminalPipe;
        String string = DockerBundle.message((String)"ImagePullPanel.terminal.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.terminalHandler = DockerUiUtilsKt.createTerminal(dockerTerminalPipe, string, this.project);
        JComponent jComponent = this.terminalHandler.getComponent();
        JBInsets jBInsets = JBUI.insetsTop((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsTop(...)");
        this.mainPanel.add((Component)DockerUiUtilsKt.withBorder(jComponent, (Insets)jBInsets), "Center");
        object = DockerBundle.message((String)"ImagePullPanel.action.pull", (Object[])new Object[0]);
        new DumbAwareAction((String)object){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.doPull();
            }
        }.registerCustomShortcutSet(shortcut, (JComponent)((Object)this.imageTagField), null);
        this.refreshQueueLabel();
    }

    @NotNull
    public final JComponent getMainPanel$intellij_clouds_docker() {
        return this.mainPanel;
    }

    public void dispose() {
        if (!this.terminalHandler.isClosed()) {
            this.terminalHandler.close();
        }
    }

    private final void doPull() {
        String string = this.imageTagField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String tag = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean bl = false;
        if (((CharSequence)tag).length() > 0) {
            this.imageTagField.setText("");
            this.getFocusManager().requestFocusInProject((Component)this.terminalHandler.getComponent(), this.project);
            DockerRuntimeContextKt.launch$default(this.runtime.getContext(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, tag, null){
                int label;
                final /* synthetic */ ImagePullPanel this$0;
                final /* synthetic */ String $tag;
                {
                    this.this$0 = $receiver;
                    this.$tag = $tag;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ImagePullPanel.access$requestPull(this.this$0, this.$tag);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    private final void requestPull(String request) {
        CharSequence charSequence = request;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List newTags = regex.split(charSequence, n);
        boolean queueWasEmpty = this.pullQueue.isEmpty();
        this.pullQueue.addAll(newTags);
        if (queueWasEmpty) {
            this.pullNextOne();
        }
    }

    private final void pullNextOne() {
        DockerRepoTag tagToPull = this.chooseNextValidTagToPull();
        if (tagToPull == null) {
            ActionsKt.runInEdt$default(null, () -> ImagePullPanel.pullNextOne$lambda$0(this), (int)1, null);
            return;
        }
        ((CompletableFuture)this.pullImage(tagToPull).thenRun(() -> ImagePullPanel.pullNextOne$lambda$1(this))).thenRun(() -> ImagePullPanel.pullNextOne$lambda$2(this));
    }

    @NotNull
    public final CompletableFuture<List<DockerResponseItem.AuxDetail>> pullImage(@NotNull DockerRepoTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new DockerRedirectToTerminal(this.terminalPipe.asTtySink()).redirectToTerminalLater(this.asyncPullImage(tag));
    }

    private final CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerRepoTag tag) {
        DockerAgentRepositoryConfig repoConfig = tag.toAgentRepositoryConfig();
        DockerAgent dockerAgent = this.runtime.getContext().getAgent();
        Intrinsics.checkNotNull((Object)repoConfig);
        return dockerAgent.asyncPullImage(repoConfig);
    }

    private final DockerRepoTag chooseNextValidTagToPull() {
        while (!this.pullQueue.isEmpty()) {
            DockerRepoTag nextTag;
            String nextTagString = this.pullQueue.removeFirst();
            this.refreshQueueLabel();
            this.terminalPipe.printInfo("docker pull " + nextTagString);
            Intrinsics.checkNotNullExpressionValue((Object)DockerRepoTag.fromString((String)nextTagString), (String)"fromString(...)");
            if (!nextTag.hasCustomTag()) {
                Intrinsics.checkNotNull((Object)nextTagString);
                CharSequence charSequence = nextTagString;
                String string = nextTag.getTagNotNull();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagNotNull(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                    String string2 = DockerBundle.message((String)"ImagePullPanel.terminal.info.using.default.tag", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    this.terminalPipe.printInfo(string2);
                }
            }
            if (nextTag.isValidReferenceFormat()) {
                return nextTag;
            }
            Object[] objectArray = new Object[]{nextTagString};
            String string = DockerBundle.message((String)"ImagePullPanel.terminal.error.reference.format", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.terminalPipe.printError(string);
            DockerTerminalPipe.WithTty.println$default((DockerTerminalPipe.WithTty)this.terminalPipe, null, (int)1, null);
        }
        return null;
    }

    private final void refreshQueueLabel() {
        Object[] objectArray = new Object[]{this.pullQueue.size()};
        this.operationLabel.setText(DockerBundle.message((String)"ImagePullPanel.queue.label", (Object[])objectArray));
        this.operationLabel.setVisible(!((Collection)this.pullQueue).isEmpty());
        this.spinningLabel.setVisible(!((Collection)this.pullQueue).isEmpty());
    }

    private final IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"getInstance(...)");
        return ideFocusManager;
    }

    private static final Unit _init_$lambda$0(ImagePullPanel this$0, ShortcutSet $shortcut, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ImagePullPanel.lambda$0$0(this$0, $shortcut, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(ImagePullPanel this$0, ShortcutSet $shortcut, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DockerBundle.message((String)"ImagePullPanel.image.to.pull.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).gap(RightGap.SMALL);
        $this$row.cell((JComponent)((Object)this$0.imageTagField)).gap(RightGap.SMALL);
        String string2 = DockerBundle.message((String)"DockerRegistryServiceViewContributor.dialog.ok", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        AbstractButton abstractButton = (AbstractButton)$this$row.button(string2, arg_0 -> ImagePullPanel.lambda$0$0$0(this$0, arg_0)).gap(RightGap.SMALL).getComponent();
        Icon icon = DockerIcons.PullImage;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PullImage");
        DockerUiUtilsKt.withIcon(abstractButton, icon);
        Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)$shortcut)};
        String string3 = DockerBundle.message((String)"ImagePullPanel.image.to.pull.comment", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string3, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$0(ImagePullPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.doPull();
        return Unit.INSTANCE;
    }

    private static final Unit pullNextOne$lambda$0(ImagePullPanel this$0) {
        this$0.getFocusManager().requestFocusInProject((Component)((Object)this$0.imageTagField), this$0.project);
        return Unit.INSTANCE;
    }

    private static final void pullNextOne$lambda$1(ImagePullPanel this$0) {
        DockerTerminalPipe.WithTty.println$default((DockerTerminalPipe.WithTty)this$0.terminalPipe, null, (int)1, null);
    }

    private static final void pullNextOne$lambda$2(ImagePullPanel this$0) {
        this$0.pullNextOne();
    }

    public static final /* synthetic */ void access$requestPull(ImagePullPanel $this, String request) {
        $this.requestPull(request);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/view/details/image/ImagePullPanel$Companion;", "", "<init>", "()V", "scale", "", "value", "ICON_GAP", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final int scale(int value) {
            return JBUIScale.scale((int)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

