/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.kernel;

import com.intellij.jupyter.core.jupyter.connections.execution.JupyterKernelCommunicationClient;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSessionId;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.execution.kernel.BaseJupyterKernelCommunicationClientKt;
import com.intellij.jupyter.execution.kernel.MessageBridgeKt;
import com.intellij.jupyter.execution.kernel.RawMessageWithSocket;
import com.intellij.jupyter.execution.kernel.TimeoutsKt;
import com.intellij.jupyter.execution.kernel.UtilKt;
import com.intellij.jupyter.execution.logging.NotebookLoggerFactory;
import com.intellij.jupyter.execution.util.TerminationKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.util.ui.EDT;
import java.io.Closeable;
import java.nio.channels.ClosedSelectorException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterCallbackBasedSocket;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.messaging.JupyterClientSockets;
import org.zeromq.ZMQException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001!B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\tH\u0014J\b\u0010 \u001a\u00020\tH\u0016R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/execution/kernel/BaseJupyterKernelCommunicationClient;", "S", "Lorg/jetbrains/kotlinx/jupyter/protocol/messaging/JupyterClientSockets;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterKernelCommunicationClient;", "sessionId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionId;", "onMessageCallback", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "sockets", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlinx/jupyter/protocol/messaging/JupyterClientSockets;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSessionId-PaPw8_s", "()Ljava/lang/String;", "Ljava/lang/String;", "getSockets", "()Lorg/jetbrains/kotlinx/jupyter/protocol/messaging/JupyterClientSockets;", "Lorg/jetbrains/kotlinx/jupyter/protocol/messaging/JupyterClientSockets;", "receiveMessageLock", "Ljava/util/concurrent/locks/ReentrantLock;", "isClosing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "send", "content", "initSockets", "processMessage", "socketType", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "rawMessage", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "closeSockets", "close", "Companion", "intellij.jupyter.execution"})
@SourceDebugExtension(value={"SMAP\nBaseJupyterKernelCommunicationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseJupyterKernelCommunicationClient.kt\ncom/intellij/jupyter/execution/kernel/BaseJupyterKernelCommunicationClient\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n60#2,5:124\n1869#3,2:129\n1#4:131\n*S KotlinDebug\n*F\n+ 1 BaseJupyterKernelCommunicationClient.kt\ncom/intellij/jupyter/execution/kernel/BaseJupyterKernelCommunicationClient\n*L\n39#1:124,5\n47#1:129,2\n*E\n"})
public class BaseJupyterKernelCommunicationClient<S extends JupyterClientSockets>
implements JupyterKernelCommunicationClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final Function1<JupyterMessage, Unit> onMessageCallback;
    @NotNull
    private final S sockets;
    @NotNull
    private final ReentrantLock receiveMessageLock;
    @NotNull
    private final AtomicBoolean isClosing;
    @NotNull
    private static final Logger LOG = NotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.getClass()));

    private BaseJupyterKernelCommunicationClient(String sessionId, Function1<? super JupyterMessage, Unit> onMessageCallback, S sockets) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter(onMessageCallback, (String)"onMessageCallback");
        Intrinsics.checkNotNullParameter(sockets, (String)"sockets");
        this.sessionId = sessionId;
        this.onMessageCallback = onMessageCallback;
        this.sockets = sockets;
        this.receiveMessageLock = new ReentrantLock(true);
        this.isClosing = new AtomicBoolean(false);
        this.initSockets();
    }

    @NotNull
    public final String getSessionId-PaPw8_s() {
        return this.sessionId;
    }

    @NotNull
    protected final S getSockets() {
        return this.sockets;
    }

    public void send(@NotNull JupyterMessage content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        RawMessageWithSocket rawMessageWithSocket = MessageBridgeKt.toRawMessageWithSocket(content);
        if (rawMessageWithSocket == null) {
            return;
        }
        RawMessageWithSocket rawMessageWithSocket2 = rawMessageWithSocket;
        RawMessage rawMessage = rawMessageWithSocket2.component1();
        JupyterSocketType socketType = rawMessageWithSocket2.component2();
        try {
            JupyterCallbackBasedSocket jupyterCallbackBasedSocket = BaseJupyterKernelCommunicationClientKt.access$fromSocketType(this.sockets, socketType);
            if (jupyterCallbackBasedSocket == null) {
                throw new IllegalArgumentException("Interacting with heartbeat socket is not supported");
            }
            JupyterCallbackBasedSocket socket = jupyterCallbackBasedSocket;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Sending message to " + socketType + " in " + JupyterNotebookSessionId.toString-impl((String)this.sessionId) + ":\n" + rawMessage, e$iv);
            }
            socket.sendRawMessage(rawMessage);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private final void initSockets() {
        Iterable $this$forEach$iv = (Iterable)JupyterSocketType.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCallbackBasedSocket socket;
            JupyterSocketType socketType = (JupyterSocketType)((Object)element$iv);
            boolean bl = false;
            JupyterCallbackBasedSocket jupyterCallbackBasedSocket = socket = BaseJupyterKernelCommunicationClientKt.access$fromSocketType(this.sockets, socketType);
            if (jupyterCallbackBasedSocket == null) continue;
            jupyterCallbackBasedSocket.onRawMessage(arg_0 -> BaseJupyterKernelCommunicationClient.initSockets$lambda$0$0(this, socketType, arg_0));
        }
    }

    private final void processMessage(JupyterSocketType socketType, RawMessage rawMessage) {
        JupyterMessage message = MessageBridgeKt.toJupyterMessage(rawMessage, BaseJupyterKernelCommunicationClientKt.getChannel(socketType));
        this.onMessageCallback.invoke((Object)message);
    }

    protected void closeSockets() {
        TerminationKt.closeWithTimeout(Duration.getInWholeMilliseconds-impl((long)TimeoutsKt.getSESSION_KILL_WAIT_TIMEOUT()), (Function0<Unit>)((Function0)() -> BaseJupyterKernelCommunicationClient.closeSockets$lambda$0(this)));
    }

    public void close() {
        if (!this.isClosing.compareAndSet(false, true)) {
            return;
        }
        Job closeDeferred2 = JupyterCoroutineKt.launchIO((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BaseJupyterKernelCommunicationClient<S> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.closeSockets();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (!EDT.isCurrentThreadEdt()) {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(closeDeferred2, null){
                int label;
                final /* synthetic */ Job $closeDeferred;
                {
                    this.$closeDeferred = $closeDeferred;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$closeDeferred.join((Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initSockets$lambda$0$0(BaseJupyterKernelCommunicationClient this$0, JupyterSocketType $socketType, RawMessage rawMessage) {
        Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
        try {
            Lock lock = this$0.receiveMessageLock;
            lock.lock();
            try {
                boolean bl = false;
                this$0.processMessage($socketType, rawMessage);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        catch (ClosedSelectorException e) {
            UtilKt.rethrowAsInterrupted(e);
        }
        catch (ZMQException e) {
            UtilKt.rethrowAsInterrupted(e);
        }
        catch (AssertionError e) {
            UtilKt.rethrowAsInterrupted((Throwable)((Object)e));
        }
    }

    private static final Unit closeSockets$lambda$0(BaseJupyterKernelCommunicationClient this$0) {
        ((Closeable)this$0.sockets).close();
        return Unit.INSTANCE;
    }

    public /* synthetic */ BaseJupyterKernelCommunicationClient(String sessionId, Function1 onMessageCallback, JupyterClientSockets sockets, DefaultConstructorMarker $constructor_marker) {
        this(sessionId, (Function1<? super JupyterMessage, Unit>)onMessageCallback, sockets);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/execution/kernel/BaseJupyterKernelCommunicationClient$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.execution"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

