/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol;

import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageCallback;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/CallbackHandler;", "Ljava/io/Closeable;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lorg/slf4j/Logger;)V", "callbacks", "", "Lorg/jetbrains/kotlinx/jupyter/protocol/RawMessageCallback;", "addCallback", "", "callback", "runCallbacks", "payload", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "close", "protocol"})
@SourceDebugExtension(value={"SMAP\nRawMessageCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawMessageCallback.kt\norg/jetbrains/kotlinx/jupyter/protocol/CallbackHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1869#2,2:40\n*S KotlinDebug\n*F\n+ 1 RawMessageCallback.kt\norg/jetbrains/kotlinx/jupyter/protocol/CallbackHandler\n*L\n23#1:40,2\n*E\n"})
public final class CallbackHandler
implements Closeable {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<RawMessageCallback> callbacks;

    public CallbackHandler(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.callbacks = new LinkedHashSet();
    }

    public final void addCallback(@NotNull RawMessageCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public final void runCallbacks(@NotNull RawMessage payload) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RawMessageCallback callback = (RawMessageCallback)element$iv;
            boolean bl = false;
            try {
                callback.invoke(payload);
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    throw e;
                }
                this.logger.error("Exception thrown while processing a message", e);
            }
        }
    }

    @Override
    public void close() {
        this.callbacks.clear();
    }
}

