/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.exceptions.ExceptionMerger;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketWithCancellation;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0082\b\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001fJ\r\u0010 \u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\rH\u0002J\b\u0010#\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl;", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellation;", "socket", "Lorg/zeromq/ZMQ$Socket;", "<init>", "(Lorg/zeromq/ZMQ$Socket;)V", "cancellationToken", "Lorg/zeromq/ZMQ$CancellationToken;", "recv", "", "recvString", "", "sendMore", "", "data", "send", "flags", "", "cancellableOperation", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "makeRelaxed", "", "subscribe", "topic", "bind", "address", "bind$zmq_protocol", "connect", "connect$zmq_protocol", "assertNotCancelled", "assertNotCancelled$zmq_protocol", "isCancelled", "close", "zmq-protocol"})
@SourceDebugExtension(value={"SMAP\nZmqSocketWithCancellationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZmqSocketWithCancellationImpl.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/UtilKt\n+ 4 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/ExceptionMerger\n*L\n1#1,92:1\n41#1,11:93\n53#1:105\n41#1,11:106\n53#1:118\n1#2:104\n1#2:117\n1#2:119\n1#2:143\n18#3:120\n58#3,2:121\n10#3,4:123\n60#3,2:127\n65#3,3:135\n19#3,2:138\n14#3,3:140\n21#3:144\n69#3:145\n30#4,6:129\n*S KotlinDebug\n*F\n+ 1 ZmqSocketWithCancellationImpl.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl\n*L\n16#1:93,11\n16#1:105\n38#1:106,11\n38#1:118\n16#1:104\n38#1:117\n86#1:143\n86#1:120\n86#1:121,2\n86#1:123,4\n86#1:127,2\n86#1:135,3\n86#1:138,2\n86#1:140,3\n86#1:144\n86#1:145\n86#1:129,6\n*E\n"})
public final class ZmqSocketWithCancellationImpl
implements ZmqSocketWithCancellation {
    @NotNull
    private final ZMQ.Socket socket;
    @NotNull
    private final ZMQ.CancellationToken cancellationToken;

    public ZmqSocketWithCancellationImpl(@NotNull ZMQ.Socket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.socket = socket;
        ZMQ.CancellationToken cancellationToken = this.socket.createCancellationToken();
        Intrinsics.checkNotNullExpressionValue((Object)cancellationToken, (String)"createCancellationToken(...)");
        this.cancellationToken = cancellationToken;
    }

    @Override
    @NotNull
    public byte[] recv() throws InterruptedException {
        byte[] result;
        byte[] byArray;
        ZmqSocketWithCancellationImpl this_$iv = this;
        boolean $i$f$cancellableOperation = false;
        this_$iv.assertNotCancelled$zmq_protocol();
        try {
            boolean bl = false;
            byArray = this.socket.recv(0, this.cancellationToken);
        }
        catch (Throwable e$iv) {
            if (this_$iv.isCancelled() || e$iv instanceof ZMQException && (((ZMQException)e$iv).getErrorCode() == ZMQ.Error.EINTR.getCode() || ((ZMQException)e$iv).getErrorCode() == 125)) {
                InterruptedException interruptedException;
                InterruptedException $this$cancellableOperation_u24lambda_u240$iv = interruptedException = new InterruptedException();
                boolean bl = false;
                $this$cancellableOperation_u24lambda_u240$iv.initCause(e$iv);
                throw (Throwable)interruptedException;
            }
            throw e$iv;
        }
        if (result == null) {
            throw new ZMQException("Unable to receive message", this.socket.errno());
        }
        result = byArray;
        return result;
    }

    @Override
    @NotNull
    public String recvString() throws InterruptedException {
        byte[] byArray = this.recv();
        Charset charset = ZMQ.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    @Override
    public boolean sendMore(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = ZMQ.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.sendMore(byArray);
    }

    @Override
    public boolean sendMore(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.send(data, 2);
    }

    @Override
    public boolean send(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = ZMQ.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.send(byArray);
    }

    @Override
    public boolean send(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.send(data, 0);
    }

    private final boolean send(byte[] data, int flags) {
        boolean bl;
        ZmqSocketWithCancellationImpl this_$iv = this;
        boolean $i$f$cancellableOperation = false;
        this_$iv.assertNotCancelled$zmq_protocol();
        try {
            boolean bl2 = false;
            bl = this.socket.send(data, flags, this.cancellationToken);
        }
        catch (Throwable e$iv) {
            if (this_$iv.isCancelled() || e$iv instanceof ZMQException && (((ZMQException)e$iv).getErrorCode() == ZMQ.Error.EINTR.getCode() || ((ZMQException)e$iv).getErrorCode() == 125)) {
                InterruptedException interruptedException;
                InterruptedException $this$cancellableOperation_u24lambda_u240$iv = interruptedException = new InterruptedException();
                boolean bl3 = false;
                $this$cancellableOperation_u24lambda_u240$iv.initCause(e$iv);
                throw (Throwable)interruptedException;
            }
            throw e$iv;
        }
        return bl;
    }

    private final <R> R cancellableOperation(Function0<? extends R> block) {
        Object object;
        boolean $i$f$cancellableOperation = false;
        this.assertNotCancelled$zmq_protocol();
        try {
            object = block.invoke();
        }
        catch (Throwable e) {
            if (this.isCancelled() || e instanceof ZMQException && (((ZMQException)e).getErrorCode() == ZMQ.Error.EINTR.getCode() || ((ZMQException)e).getErrorCode() == 125)) {
                InterruptedException interruptedException;
                InterruptedException $this$cancellableOperation_u24lambda_u240 = interruptedException = new InterruptedException();
                boolean bl = false;
                $this$cancellableOperation_u24lambda_u240.initCause(e);
                throw (Throwable)interruptedException;
            }
            throw e;
        }
        return (R)object;
    }

    @Override
    public void makeRelaxed() {
        this.socket.base().setSocketOpt(53, true);
    }

    @Override
    public boolean subscribe(@NotNull byte[] topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.socket.subscribe(topic);
    }

    public final boolean bind$zmq_protocol(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        boolean res = this.socket.bind(address);
        if (this.socket.getSocketType() == SocketType.PUB) {
            Thread.sleep(500L);
        }
        return res;
    }

    public final boolean connect$zmq_protocol(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.socket.connect(address);
    }

    public final void assertNotCancelled$zmq_protocol() {
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
    }

    private final boolean isCancelled() {
        return this.cancellationToken.isCancellationRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean $i$f$tryFinally = false;
        Unit result$iv = null;
        boolean $i$f$mergeExceptions = false;
        ExceptionMerger exceptionMerger$iv$iv = new ExceptionMerger();
        Throwable throwable$iv$iv = null;
        try {
            boolean $i$f$catchIndependently;
            ExceptionMerger this_$iv$iv;
            ExceptionMerger $this$tryFinally_u24lambda_u240$iv = exceptionMerger$iv$iv;
            boolean bl = false;
            try {
                this_$iv$iv = $this$tryFinally_u24lambda_u240$iv;
                $i$f$catchIndependently = false;
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!this.isCancelled()) {
                        this.cancellationToken.cancel();
                    }
                    result$iv = Unit.INSTANCE;
                }
                catch (Throwable e$iv$iv) {
                    this_$iv$iv.addError(e$iv$iv);
                }
            }
            finally {
                this_$iv$iv = $this$tryFinally_u24lambda_u240$iv;
                $i$f$catchIndependently = false;
                try {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    this.socket.close();
                }
                catch (Throwable e$iv$iv) {
                    this_$iv$iv.addError(e$iv$iv);
                }
            }
            exceptionMerger$iv$iv.finalize();
        }
        catch (Throwable e$iv$iv) {
            try {
                throwable$iv$iv = e$iv$iv;
                throw e$iv$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable$iv$iv;
                if (throwable2 != null) {
                    Throwable it$iv$iv = throwable2;
                    boolean bl = false;
                    exceptionMerger$iv$iv.addError(it$iv$iv);
                }
                exceptionMerger$iv$iv.finalize();
                throw throwable;
            }
        }
    }
}

