/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.usages.CssSearchHelper;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CssUnusedSymbolUtils {
    public static boolean isUnused(@NotNull CssSelectorSuffix suffix, @NotNull SearchScope scope, boolean checkIds) {
        String text;
        PsiElement grandParent;
        if (suffix == null) {
            CssUnusedSymbolUtils.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            CssUnusedSymbolUtils.$$$reportNull$$$0(1);
        }
        if (suffix.getName() == null) {
            return false;
        }
        CssSelectorSuffixType suffixType = suffix.getType();
        if ((suffixType == CssSelectorSuffixType.CLASS || suffixType == CssSelectorSuffixType.ID && checkIds) && (grandParent = suffix.getParent().getParent()).getParent().getLastChild() == grandParent && !(text = suffix.getText()).isEmpty()) {
            Set mediaTypes = CssPsiUtil.getAllowedMediaTypesInContext((PsiElement)suffix);
            if (!mediaTypes.contains(CssMediaType.SCREEN) && !mediaTypes.contains(CssMediaType.ALL)) {
                return false;
            }
            if (!CssSearchHelper.isClassOrIdUsed((CssSelectorSuffix)suffix, (SearchScope)scope)) {
                return true;
            }
        }
        return false;
    }

    public static List<CssSelectorSuffix> getUnusedStyles(@NotNull PsiFile file) {
        if (file == null) {
            CssUnusedSymbolUtils.$$$reportNull$$$0(2);
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)file);
        return ContainerUtil.filter((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)file, CssSelectorSuffix.class), element -> CssUnusedSymbolUtils.isUnused(element, (SearchScope)scope, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/CssUnusedSymbolUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnused";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnusedStyles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

