/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.syntax.lexer;

import com.intellij.java.syntax.element.JavaDocSyntaxTokenType;
import com.intellij.java.syntax.lexer._JavaDocLexer;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.util.lexer.LexerBase;
import com.intellij.util.text.CharArrayUtilKmp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u0014H\u0002J\u0016\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/java/syntax/lexer/AsteriskStripperLexer;", "Lcom/intellij/platform/syntax/util/lexer/LexerBase;", "myFlex", "Lcom/intellij/java/syntax/lexer/_JavaDocLexer;", "<init>", "(Lcom/intellij/java/syntax/lexer/_JavaDocLexer;)V", "myBuffer", "", "myBufferIndex", "", "myBufferEndOffset", "myTokenEndOffset", "myState", "myTokenType", "Lcom/intellij/platform/syntax/SyntaxElementType;", "myAfterLineBreak", "", "myInLeadingSpace", "myMarkdownMode", "start", "", "buffer", "startOffset", "endOffset", "initialState", "getState", "getBufferSequence", "getBufferEnd", "getTokenType", "getTokenStart", "getTokenEnd", "advance", "locateToken", "selectLexerMode", "doLocateToken", "detectLeadingAsterisks", "detectLeadingSlashes", "flexLocateToken", "intellij.java.syntax"})
@SourceDebugExtension(value={"SMAP\nJavaDocLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDocLexer.kt\ncom/intellij/java/syntax/lexer/AsteriskStripperLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
final class AsteriskStripperLexer
extends LexerBase {
    @NotNull
    private final _JavaDocLexer myFlex;
    private CharSequence myBuffer;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private int myState;
    @Nullable
    private SyntaxElementType myTokenType;
    private boolean myAfterLineBreak;
    private boolean myInLeadingSpace;
    private boolean myMarkdownMode;

    public AsteriskStripperLexer(@NotNull _JavaDocLexer myFlex) {
        this.myFlex = myFlex;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.myAfterLineBreak = false;
        this.myInLeadingSpace = false;
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence = null;
        }
        this.myFlex.reset(charSequence, startOffset, endOffset, initialState);
        this.selectLexerMode(buffer, startOffset);
    }

    public int getState() {
        return this.myState;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence = null;
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    @Nullable
    public SyntaxElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myBufferIndex;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEndOffset;
    }

    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    private final void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.doLocateToken();
        if (this.myTokenType == JavaDocSyntaxTokenType.DOC_SPACE) {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
                charSequence = null;
            }
            this.myAfterLineBreak = CharArrayUtilKmp.containLineBreaks((CharSequence)charSequence, (int)this.getTokenStart(), (int)this.getTokenEnd());
        }
    }

    public final void selectLexerMode(@NotNull CharSequence buffer, int startOffset) {
        this.myMarkdownMode = StringsKt.startsWith$default((CharSequence)buffer, (CharSequence)"///", (int)startOffset, (boolean)false, (int)4, null);
        this.myFlex.setMarkdownMode(this.myMarkdownMode);
    }

    public final void doLocateToken() {
        block17: {
            int state;
            boolean lf;
            block19: {
                block18: {
                    if (this.myTokenEndOffset == this.myBufferEndOffset) {
                        this.myTokenType = null;
                        this.myBufferIndex = this.myBufferEndOffset;
                        return;
                    }
                    this.myBufferIndex = this.myTokenEndOffset;
                    if (this.myAfterLineBreak) {
                        this.myAfterLineBreak = false;
                        if (this.myMarkdownMode) {
                            while (this.detectLeadingSlashes()) {
                                this.myTokenEndOffset += 3;
                            }
                        } else {
                            while (this.detectLeadingAsterisks()) {
                                int n = this.myTokenEndOffset;
                                this.myTokenEndOffset = n + 1;
                            }
                        }
                        this.myInLeadingSpace = true;
                        if (this.myBufferIndex < this.myTokenEndOffset) {
                            this.myTokenType = JavaDocSyntaxTokenType.DOC_COMMENT_LEADING_ASTERISKS;
                            return;
                        }
                    }
                    if (!this.myInLeadingSpace) break block17;
                    this.myInLeadingSpace = false;
                    lf = false;
                    while (this.myTokenEndOffset < this.myBufferEndOffset) {
                        CharSequence charSequence = this.myBuffer;
                        if (charSequence == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
                            charSequence = null;
                        }
                        if (!CharsKt.isWhitespace((char)charSequence.charAt(this.myTokenEndOffset))) break;
                        CharSequence charSequence2 = this.myBuffer;
                        if (charSequence2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
                            charSequence2 = null;
                        }
                        if (charSequence2.charAt(this.myTokenEndOffset) == '\n') {
                            lf = true;
                        }
                        int n = this.myTokenEndOffset;
                        this.myTokenEndOffset = n + 1;
                    }
                    if ((state = this.myFlex.yystate()) == 4) break block18;
                    if (state == 24 || this.myTokenEndOffset >= this.myBufferEndOffset) break block19;
                    CharSequence charSequence = this.myBuffer;
                    if (charSequence == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
                        charSequence = null;
                    }
                    char it = charSequence.charAt(this.myTokenEndOffset);
                    boolean bl = false;
                    boolean bl2 = it == '@' || it == '{' || it == '\"' || it == '<';
                    if (!bl2) break block19;
                }
                this.myFlex.yybegin(2);
            }
            if (this.myBufferIndex < this.myTokenEndOffset) {
                this.myTokenType = lf || state == 8 || state == 6 || state == 16 || state == 12 || state == 22 ? JavaDocSyntaxTokenType.DOC_SPACE : JavaDocSyntaxTokenType.DOC_COMMENT_DATA;
                return;
            }
        }
        this.flexLocateToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean detectLeadingAsterisks() {
        if (this.myTokenEndOffset >= this.myBufferEndOffset) return false;
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence = null;
        }
        if (charSequence.charAt(this.myTokenEndOffset) != '*') return false;
        if (this.myTokenEndOffset + 1 >= this.myBufferEndOffset) return true;
        CharSequence charSequence2 = this.myBuffer;
        if (charSequence2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence2 = null;
        }
        if (charSequence2.charAt(this.myTokenEndOffset + 1) == '/') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean detectLeadingSlashes() {
        if (this.myTokenEndOffset + 2 >= this.myBufferEndOffset) return false;
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBuffer");
            charSequence = null;
        }
        if (!StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)"///", (int)this.myTokenEndOffset, (boolean)false, (int)4, null)) return false;
        return true;
    }

    public final void flexLocateToken() {
        this.myState = this.myFlex.yystate();
        this.myFlex.goTo(this.myBufferIndex);
        this.myTokenType = this.myFlex.advance();
        this.myTokenEndOffset = this.myFlex.getTokenEnd();
    }
}

