/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.AnnotationAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaElementArrangementEntry
extends DefaultArrangementEntry
implements TypeAwareArrangementEntry,
NameAwareArrangementEntry,
ModifierAwareArrangementEntry,
AnnotationAwareArrangementEntry {
    @NotNull
    private final Set<ArrangementSettingsToken> myModifiers;
    @NotNull
    private final Set<ArrangementSettingsToken> myTypes;
    @NotNull
    private final ArrangementSettingsToken myType;
    @Nullable
    private final String myName;
    private boolean myHasAnnotation;

    public JavaElementArrangementEntry(@Nullable ArrangementEntry parent, @NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable String name, boolean canBeMatched) {
        if (range == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(1);
        }
        this(parent, range.getStartOffset(), range.getEndOffset(), type, name, canBeMatched);
    }

    public JavaElementArrangementEntry(@Nullable ArrangementEntry parent, int startOffset, int endOffset, @NotNull ArrangementSettingsToken type, @Nullable String name, boolean canBeArranged) {
        if (type == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(2);
        }
        super(parent, startOffset, endOffset, canBeArranged);
        this.myModifiers = new HashSet<ArrangementSettingsToken>();
        this.myTypes = new HashSet<ArrangementSettingsToken>();
        this.myHasAnnotation = false;
        this.myType = type;
        this.myTypes.add(type);
        this.myName = name;
    }

    @NotNull
    public Set<? extends ArrangementSettingsToken> getModifiers() {
        Set<ArrangementSettingsToken> set = this.myModifiers;
        if (set == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(3);
        }
        return set;
    }

    public void addModifier(@NotNull ArrangementSettingsToken modifier) {
        if (modifier == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(4);
        }
        this.myModifiers.add(modifier);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Set<? extends ArrangementSettingsToken> getTypes() {
        Set<ArrangementSettingsToken> set = this.myTypes;
        if (set == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public ArrangementSettingsToken getType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myType;
        if (arrangementSettingsToken == null) {
            JavaElementArrangementEntry.$$$reportNull$$$0(6);
        }
        return arrangementSettingsToken;
    }

    @Override
    public boolean hasAnnotation() {
        return this.myHasAnnotation;
    }

    public String toString() {
        return String.format("[%d; %d): %s %s %s", this.getStartOffset(), this.getEndOffset(), StringUtil.toLowerCase((String)StringUtil.join(this.myModifiers, (String)" ")), StringUtil.toLowerCase((String)this.myTypes.iterator().next().toString()), this.myName == null ? "<no name>" : this.myName);
    }

    @Override
    public void setHasAnnotation() {
        this.myHasAnnotation = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/JavaElementArrangementEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

