/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.cache.ExplicitTypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.AnnotationTextCollector;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeAnnotationCollector;
import com.intellij.psi.impl.compiled.FirstPassData;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiRecordComponentStub;
import com.intellij.psi.impl.java.stubs.PsiRecordHeaderStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiPackageStatementStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiRecordComponentStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiRecordHeaderStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

public class StubBuildingVisitor<T>
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance(StubBuildingVisitor.class);
    private static final String DOUBLE_POSITIVE_INF = "1.0 / 0.0";
    private static final String DOUBLE_NEGATIVE_INF = "-1.0 / 0.0";
    private static final String DOUBLE_NAN = "0.0d / 0.0";
    private static final String FLOAT_POSITIVE_INF = "1.0f / 0.0";
    private static final String FLOAT_NEGATIVE_INF = "-1.0f / 0.0";
    private static final String FLOAT_NAN = "0.0f / 0.0";
    private static final String SYNTHETIC_CLASS_INIT_METHOD = "<clinit>";
    private static final String SYNTHETIC_INIT_METHOD = "<init>";
    private final T mySource;
    private final InnerClassSourceStrategy<T> myInnersStrategy;
    private final StubElement<?> myParent;
    private final int myAccess;
    private final String myShortName;
    @NotNull
    private final FirstPassData myFirstPassData;
    private final boolean myAnonymousInner;
    private final boolean myLocalClassInner;
    private String myInternalName;
    private PsiClassStub<?> myResult;
    private PsiModifierListStub myModList;
    private PsiRecordHeaderStub myHeaderStub;
    private Map<TypeInfo, ClsTypeAnnotationCollector> myAnnoBuilders;
    private List<String> myPermittedSubclasses;
    private ClassInfo myClassInfo;
    private static final String[] parameterNames = new String[]{"p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9"};
    public static final Function<String, String> GUESSING_MAPPER = internalName -> {
        String canonicalText = internalName;
        if (canonicalText.indexOf(36) >= 0) {
            int start;
            StringBuilder sb = new StringBuilder(canonicalText);
            boolean updated = false;
            for (int p = start = canonicalText.lastIndexOf(47) + 2; p < sb.length(); ++p) {
                char c = sb.charAt(p);
                if (c != '$' || p >= sb.length() - 1 || sb.charAt(p + 1) == '$') continue;
                sb.setCharAt(p, '.');
                updated = true;
            }
            if (updated) {
                canonicalText = sb.toString();
            }
        }
        return canonicalText.replace('/', '.');
    };
    public static final SignatureParsing.TypeInfoProvider GUESSING_PROVIDER = SignatureParsing.TypeInfoProvider.from(GUESSING_MAPPER);

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement<?> parent, int access, String shortName) {
        this(classSource, innersStrategy, parent, access, shortName, false, false);
    }

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement<?> parent, int access, String shortName, boolean anonymousInner, boolean localClassInner) {
        super(589824);
        this.mySource = classSource;
        this.myInnersStrategy = innersStrategy;
        this.myParent = parent;
        this.myAccess = access;
        this.myShortName = shortName;
        this.myFirstPassData = FirstPassData.create(classSource);
        this.myAnonymousInner = anonymousInner;
        this.myLocalClassInner = localClassInner;
    }

    public PsiClassStub<?> getResult() {
        return this.myResult;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        block13: {
            TypeInfo.RefTypeInfo fqn;
            this.myInternalName = name;
            TypeInfo.RefTypeInfo refTypeInfo = fqn = this.myAnonymousInner || this.myLocalClassInner ? null : this.myFirstPassData.toTypeInfo(name);
            String shortName = this.myShortName != null && name.endsWith(this.myShortName) ? this.myShortName : (fqn != null ? fqn.getShortTypeText() : this.myShortName);
            int flags = this.myAccess | access;
            boolean isDeprecated = BitUtil.isSet((int)flags, (int)131072);
            boolean isInterface = BitUtil.isSet((int)flags, (int)512);
            boolean isEnum = BitUtil.isSet((int)flags, (int)16384);
            boolean isAnnotationType = BitUtil.isSet((int)flags, (int)8192);
            boolean isRecord = BitUtil.isSet((int)flags, (int)65536);
            short stubFlags = PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, false, false, isAnnotationType, false, false, this.myAnonymousInner, this.myLocalClassInner, false, isRecord, false, false);
            int classFlags = StubBuildingVisitor.packClassFlags(flags);
            if (this.myFirstPassData.isSealed()) {
                classFlags |= 0x8000;
            }
            String packageName = !(this.myParent instanceof PsiFileStub) || name.lastIndexOf(47) == -1 ? "" : name.substring(0, name.lastIndexOf(47)).replace('/', '.');
            PsiPackageStatementStubImpl packageStatement = null;
            if (!packageName.isEmpty()) {
                packageStatement = new PsiPackageStatementStubImpl(this.myParent, packageName);
            }
            this.myResult = new PsiClassStubImpl((IJavaElementType)JavaStubElementTypes.CLASS, this.myParent, fqn == null ? TypeInfo.SimpleTypeInfo.NULL : fqn, shortName, null, stubFlags);
            this.myModList = new PsiModifierListStubImpl((StubElement)this.myResult, classFlags);
            if ("package-info".equals(shortName)) {
                this.myModList = new PsiModifierListStubImpl(packageStatement, 0);
            }
            if (isRecord) {
                this.myHeaderStub = new PsiRecordHeaderStubImpl((StubElement)this.myResult);
            }
            if (signature != null) {
                try {
                    this.myClassInfo = this.parseClassSignature(signature);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug("source=" + this.mySource + " signature=" + signature, (Throwable)e);
                }
            }
        }
        if (this.myClassInfo == null) {
            this.myClassInfo = this.parseClassDescription(superName, interfaces);
        }
        new PsiTypeParameterListStubImpl((StubElement)this.myResult);
        if (this.myResult.isInterface()) {
            if (this.myClassInfo.interfaces != null && this.myResult.isAnnotationType()) {
                this.myClassInfo.interfaces = ContainerUtil.filter((Collection)this.myClassInfo.interfaces, info -> info.getKind() != TypeInfo.TypeKind.JAVA_LANG_ANNOTATION_ANNOTATION);
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, this.myClassInfo.interfaces);
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, this.myResult, Collections.emptyList());
        } else {
            if (this.myClassInfo.superType == null || this.myResult.isEnum() && "java/lang/Enum".equals(superName) || this.myResult.isRecord() && "java/lang/Record".equals(superName)) {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, Collections.emptyList());
            } else {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, Collections.singletonList(this.myClassInfo.superType));
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, this.myResult, this.myClassInfo.interfaces);
        }
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        if (this.myPermittedSubclasses == null) {
            this.myPermittedSubclasses = new SmartList();
        }
        this.myPermittedSubclasses.add(permittedSubclass);
    }

    private ClassInfo parseClassSignature(String signature) throws ClsFormatException {
        ClassInfo result = new ClassInfo();
        SignatureParsing.CharIterator iterator = new SignatureParsing.CharIterator(signature);
        result.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator, this.myFirstPassData);
        result.superType = SignatureParsing.parseTopLevelClassRefSignatureToTypeInfo(iterator, this.myFirstPassData);
        ArrayList<TypeInfo> interfaces = new ArrayList<TypeInfo>();
        while (iterator.current() != '\uffff') {
            TypeInfo anInterface = SignatureParsing.parseTopLevelClassRefSignatureToTypeInfo(iterator, this.myFirstPassData);
            if (anInterface == null) {
                throw new ClsFormatException();
            }
            interfaces.add(anInterface);
        }
        result.interfaces = interfaces;
        return result;
    }

    @NotNull
    private ClassInfo parseClassDescription(String superClass, String[] superInterfaces) {
        ClassInfo result = new ClassInfo();
        result.typeParameters = SignatureParsing.TypeParametersDeclaration.EMPTY;
        if (superClass != null) {
            result.superType = this.myFirstPassData.toTypeInfo(superClass, false);
        } else {
            result.superType = null;
        }
        result.interfaces = this.myFirstPassData.createTypes(superInterfaces);
        ClassInfo classInfo = result;
        if (classInfo == null) {
            StubBuildingVisitor.$$$reportNull$$$0(0);
        }
        return classInfo;
    }

    private static void newReferenceList(@NotNull JavaClassReferenceListElementType type, StubElement<?> parent, @Nullable List<? extends TypeInfo> types) {
        if (type == null) {
            StubBuildingVisitor.$$$reportNull$$$0(1);
        }
        new PsiClassReferenceListStubImpl((IJavaElementType)type, parent, types == null ? TypeInfo.EMPTY_ARRAY : types.toArray(TypeInfo.EMPTY_ARRAY));
    }

    private static int packCommonFlags(int access) {
        int flags = 0;
        flags = BitUtil.isSet((int)access, (int)2) ? (flags |= 2) : (BitUtil.isSet((int)access, (int)4) ? (flags |= 4) : (BitUtil.isSet((int)access, (int)1) ? (flags |= 1) : (flags |= 0x1000)));
        if (BitUtil.isSet((int)access, (int)8)) {
            flags |= 8;
        }
        if (BitUtil.isSet((int)access, (int)16)) {
            flags |= 0x10;
        }
        return flags;
    }

    private static int packClassFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet((int)access, (int)1024)) {
            flags |= 0x400;
        }
        return flags;
    }

    private static int packFieldFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet((int)access, (int)64)) {
            flags |= 0x40;
        }
        if (BitUtil.isSet((int)access, (int)128)) {
            flags |= 0x80;
        }
        return flags;
    }

    private static int packMethodFlags(int access, boolean isInterface) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet((int)access, (int)32)) {
            flags |= 0x20;
        }
        if (BitUtil.isSet((int)access, (int)256)) {
            flags |= 0x100;
        }
        if (BitUtil.isSet((int)access, (int)2048)) {
            flags |= 0x800;
        }
        if (BitUtil.isSet((int)access, (int)1024)) {
            flags |= 0x400;
        } else if (isInterface && !BitUtil.isSet((int)access, (int)8)) {
            flags |= 0x200;
        }
        return flags;
    }

    public void visitSource(String source, String debug) {
        ((PsiClassStubImpl)this.myResult).setSourceFileName(source);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (this.myParent instanceof PsiFileStub) {
            throw new OutOfOrderInnerClassException();
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationTextCollector(desc, this.myFirstPassData, (Consumer<? super String>)((Consumer)text -> new PsiAnnotationStubImpl(this.myModList, (String)text)));
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        TypeReference ref = new TypeReference(typeRef);
        TypeInfo info = null;
        if (ref.getSort() == 17) {
            info = this.myClassInfo.typeParameters.getBoundType(ref);
        } else if (ref.getSort() == 0) {
            info = this.myClassInfo.typeParameters.getParameterType(ref);
        } else if (ref.getSort() == 16) {
            int index = ref.getSuperTypeIndex();
            if (index == -1) {
                info = this.myClassInfo.superType;
            } else if (index >= 0 && index < this.myClassInfo.interfaces.size()) {
                info = (TypeInfo)this.myClassInfo.interfaces.get(index);
            }
        }
        if (info == null) {
            return null;
        }
        if (this.myAnnoBuilders == null) {
            this.myAnnoBuilders = new HashMap<TypeInfo, ClsTypeAnnotationCollector>();
        }
        return this.myAnnoBuilders.computeIfAbsent(info, typeInfo -> new ClsTypeAnnotationCollector((TypeInfo)typeInfo, this.myFirstPassData)).collect(typePath, desc);
    }

    public void visitEnd() {
        if (this.myAnnoBuilders != null) {
            this.myAnnoBuilders.values().forEach(ExplicitTypeAnnotationContainer.Collector::install);
        }
        if (this.myClassInfo != null) {
            this.myClassInfo.typeParameters.fillInTypeParameterList((StubElement<?>)this.myResult);
        }
        if (this.myPermittedSubclasses != null) {
            List<TypeInfo> permittedTypes = this.myFirstPassData.createTypes(ArrayUtil.toStringArray(this.myPermittedSubclasses));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.PERMITS_LIST, this.myResult, permittedTypes);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        T innerClass;
        boolean isLocalClassInner;
        if (BitUtil.isSet((int)access, (int)4096) && !name.startsWith(outerName + "$Trait$")) {
            return;
        }
        String jvmClassName = innerName;
        boolean isAnonymousInner = innerName == null;
        boolean bl = isLocalClassInner = !isAnonymousInner && outerName == null;
        if (innerName == null || outerName == null) {
            int $index;
            if (this.myInternalName.equals(name) || ($index = name.lastIndexOf(36)) == -1) {
                return;
            }
            if (isAnonymousInner) {
                innerName = jvmClassName = name.substring($index + 1);
                outerName = name.substring(0, $index);
            } else {
                outerName = name.substring(0, $index);
                jvmClassName = name.substring($index + 1);
            }
        } else if (name.startsWith(outerName + "$")) {
            jvmClassName = name.substring(outerName.length() + 1);
        }
        if (this.myParent instanceof PsiFileStub && this.myInternalName.equals(name)) {
            throw new OutOfOrderInnerClassException();
        }
        if (this.myInternalName.equals(outerName) && (innerClass = this.myInnersStrategy.findInnerClass(jvmClassName, this.mySource)) != null) {
            StubBuildingVisitor<T> visitor = new StubBuildingVisitor<T>(innerClass, this.myInnersStrategy, (StubElement<?>)this.myResult, access, innerName, isAnonymousInner, isLocalClassInner);
            this.myInnersStrategy.accept(innerClass, visitor);
        }
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        if (this.myHeaderStub == null) {
            return null;
        }
        boolean isEllipsis = this.myFirstPassData.isVarArgComponent(name);
        byte flags = PsiRecordComponentStubImpl.packFlags(isEllipsis, false);
        TypeInfo type = this.fieldType(descriptor, signature);
        if (isEllipsis) {
            type = type.withEllipsis();
        }
        PsiRecordComponentStubImpl stub = new PsiRecordComponentStubImpl(this.myHeaderStub, name, type, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, 0);
        return new RecordComponentAnnotationCollectingVisitor(stub, modList, this.myFirstPassData);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (BitUtil.isSet((int)access, (int)4096)) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (this.myResult.isRecord() && access == 18) {
            return null;
        }
        byte flags = PsiFieldStubImpl.packFlags(BitUtil.isSet((int)access, (int)16384), BitUtil.isSet((int)access, (int)131072), false, false);
        TypeInfo type = this.fieldType(desc, signature);
        String initializer = null;
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            StubBuildingVisitor.constToString(sb, value, type, false, this.myFirstPassData);
            initializer = sb.toString();
        }
        PsiFieldStubImpl stub = new PsiFieldStubImpl((StubElement)this.myResult, name, type, initializer, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packFieldFlags(access));
        return new FieldAnnotationCollectingVisitor(stub, modList, this.myFirstPassData);
    }

    private TypeInfo fieldType(String desc, String signature) {
        block3: {
            if (signature != null) {
                try {
                    return SignatureParsing.parseTypeStringToTypeInfo(new SignatureParsing.CharIterator(signature), this.myFirstPassData);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("source=" + this.mySource + " signature=" + signature, (Throwable)e);
                }
            }
        }
        return StubBuildingVisitor.toTypeInfo(Type.getType((String)desc), this.myFirstPassData);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int paramIgnoreCount;
        boolean hasSignature;
        MethodInfo info;
        String canonicalMethodName;
        byte flags;
        boolean isStatic;
        boolean isVarargs;
        boolean isEnum;
        boolean isConstructor;
        block16: {
            if (BitUtil.isSet((int)access, (int)4096) || name == null || SYNTHETIC_CLASS_INIT_METHOD.equals(name)) {
                return null;
            }
            isConstructor = SYNTHETIC_INIT_METHOD.equals(name);
            if (isConstructor && this.myAnonymousInner) {
                return null;
            }
            isEnum = this.myResult.isEnum();
            if (isEnum) {
                if ("values".equals(name) && desc.startsWith("()")) {
                    return null;
                }
                if ("valueOf".equals(name) && desc.startsWith("(Ljava/lang/String;)")) {
                    return null;
                }
            }
            if (this.myFirstPassData.isSyntheticRecordMethod(name, desc)) {
                return null;
            }
            boolean isDeprecated = BitUtil.isSet((int)access, (int)131072);
            isVarargs = BitUtil.isSet((int)access, (int)128);
            isStatic = BitUtil.isSet((int)access, (int)8);
            boolean isAnnotationMethod = this.myResult.isAnnotationType();
            flags = PsiMethodStubImpl.packFlags(isConstructor, isAnnotationMethod, isVarargs, isDeprecated, false, false);
            canonicalMethodName = isConstructor ? this.myResult.getName() : name;
            info = null;
            hasSignature = false;
            if (signature != null) {
                try {
                    info = this.parseMethodSignature(signature, exceptions);
                    hasSignature = true;
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block16;
                    LOG.debug("source=" + this.mySource + " signature=" + signature, (Throwable)e);
                }
            }
        }
        if (info == null) {
            info = this.parseMethodDescription(desc, exceptions);
        }
        PsiMethodStubImpl stub = new PsiMethodStubImpl((StubElement)this.myResult, canonicalMethodName, info.returnType, flags, null);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packMethodFlags(access, this.myResult.isInterface()));
        new PsiTypeParameterListStubImpl((StubElement)stub);
        boolean isEnumConstructor = isConstructor && isEnum;
        boolean isInnerClassConstructor = isConstructor && !isEnum && this.isInner() && !this.isGroovyClosure(canonicalMethodName);
        List args = info.argTypes;
        if (!hasSignature) {
            if (isEnumConstructor && args.size() >= 2 && ((TypeInfo)args.get(0)).getKind() == TypeInfo.TypeKind.JAVA_LANG_STRING && ((TypeInfo)args.get(1)).getKind() == TypeInfo.TypeKind.INT) {
                args = args.subList(2, args.size());
            } else if (isInnerClassConstructor && !args.isEmpty()) {
                args = args.subList(1, args.size());
            }
        }
        PsiParameterListStubImpl parameterList = new PsiParameterListStubImpl((StubElement)stub);
        int paramCount = args.size();
        PsiParameterStubImpl[] paramStubs = new PsiParameterStubImpl[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            PsiParameterStubImpl parameterStub;
            boolean isEllipsisParam;
            TypeInfo typeInfo = (TypeInfo)args.get(i);
            boolean bl = isEllipsisParam = isVarargs && i == paramCount - 1;
            if (isEllipsisParam) {
                typeInfo = typeInfo.withEllipsis();
            }
            String paramName = i < parameterNames.length ? parameterNames[i] : "p" + (i + 1);
            paramStubs[i] = parameterStub = new PsiParameterStubImpl(parameterList, paramName, typeInfo, isEllipsisParam, true);
            new PsiModifierListStubImpl((StubElement)parameterStub, 0);
        }
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.THROWS_LIST, stub, info.throwTypes);
        int n = isEnumConstructor ? 2 : (paramIgnoreCount = isInnerClassConstructor ? 1 : 0);
        int localVarIgnoreCount = isEnumConstructor ? 3 : (isInnerClassConstructor ? 2 : (!isStatic ? 1 : 0));
        return new MethodAnnotationCollectingVisitor(stub, info, modList, paramStubs, paramIgnoreCount, localVarIgnoreCount, this.myFirstPassData);
    }

    private boolean isInner() {
        return this.myParent instanceof PsiClassStub && !BitUtil.isSet((int)this.myModList.getModifiersMask(), (int)8);
    }

    private boolean isGroovyClosure(String canonicalMethodName) {
        PsiClassReferenceListStub extendsList;
        if (canonicalMethodName != null && canonicalMethodName.startsWith("_closure") && (extendsList = (PsiClassReferenceListStub)this.myResult.findChildStubByElementType(JavaStubElementTypes.EXTENDS_LIST)) != null) {
            String[] names = extendsList.getReferencedNames();
            return names.length == 1 && "groovy.lang.Closure".equals(names[0]);
        }
        return false;
    }

    private MethodInfo parseMethodSignature(String signature, String[] exceptions) throws ClsFormatException {
        MethodInfo result = new MethodInfo();
        SignatureParsing.CharIterator iterator = new SignatureParsing.CharIterator(signature);
        result.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator, this.myFirstPassData);
        if (iterator.current() != '(') {
            throw new ClsFormatException();
        }
        iterator.next();
        if (iterator.current() == ')') {
            result.argTypes = ContainerUtil.emptyList();
        } else {
            result.argTypes = (List)new SmartList();
            while (iterator.current() != ')' && iterator.current() != '\uffff') {
                result.argTypes.add(SignatureParsing.parseTypeStringToTypeInfo(iterator, this.myFirstPassData));
            }
            if (iterator.current() != ')') {
                throw new ClsFormatException();
            }
        }
        iterator.next();
        result.returnType = SignatureParsing.parseTypeStringToTypeInfo(iterator, this.myFirstPassData);
        result.throwTypes = null;
        while (iterator.current() == '^') {
            iterator.next();
            if (result.throwTypes == null) {
                result.throwTypes = (List)new SmartList();
            }
            result.throwTypes.add(SignatureParsing.parseTypeStringToTypeInfo(iterator, this.myFirstPassData));
        }
        if (exceptions != null && (result.throwTypes == null || exceptions.length > result.throwTypes.size())) {
            result.throwTypes = this.myFirstPassData.createTypes(exceptions);
        }
        return result;
    }

    private MethodInfo parseMethodDescription(String desc, String[] exceptions) {
        MethodInfo result = new MethodInfo();
        result.typeParameters = SignatureParsing.TypeParametersDeclaration.EMPTY;
        result.returnType = StubBuildingVisitor.toTypeInfo(Type.getReturnType((String)desc), this.myFirstPassData);
        result.argTypes = ContainerUtil.map((Object[])Type.getArgumentTypes((String)desc), type -> StubBuildingVisitor.toTypeInfo(type, this.myFirstPassData));
        result.throwTypes = this.myFirstPassData.createTypes(exceptions);
        return result;
    }

    static void constToString(@NotNull StringBuilder builder, @NotNull Object value, TypeInfo type, boolean anno, SignatureParsing.TypeInfoProvider mapping) {
        if (builder == null) {
            StubBuildingVisitor.$$$reportNull$$$0(2);
        }
        if (value == null) {
            StubBuildingVisitor.$$$reportNull$$$0(3);
        }
        if (value instanceof String) {
            builder.append('\"');
            StringUtil.escapeStringCharacters((int)((String)value).length(), (String)((String)value), (String)"\"", (StringBuilder)builder);
            builder.append('\"');
        } else if (value instanceof Boolean || value instanceof Short || value instanceof Byte) {
            builder.append(value);
        } else if (value instanceof Character) {
            builder.append('\'');
            String s = value.toString();
            StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)builder);
            builder.append('\'');
        } else if (value instanceof Long) {
            builder.append(value).append('L');
        } else if (value instanceof Integer) {
            if (type.getKind() == TypeInfo.TypeKind.BOOLEAN) {
                builder.append(value.equals(0) ? "false" : "true");
            } else if (type.getKind() == TypeInfo.TypeKind.CHAR) {
                char ch = (char)((Integer)value).intValue();
                builder.append('\'');
                String s = String.valueOf(ch);
                StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)builder);
                builder.append('\'');
            } else {
                builder.append(value);
            }
        } else if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d)) {
                builder.append(d > 0.0 ? DOUBLE_POSITIVE_INF : DOUBLE_NEGATIVE_INF);
            } else if (Double.isNaN(d)) {
                builder.append(DOUBLE_NAN);
            } else {
                builder.append(d);
            }
        } else if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if (Float.isInfinite(v)) {
                builder.append(v > 0.0f ? FLOAT_POSITIVE_INF : FLOAT_NEGATIVE_INF);
            } else if (Float.isNaN(v)) {
                builder.append(FLOAT_NAN);
            } else {
                builder.append(v).append('f');
            }
        } else if (value.getClass().isArray()) {
            builder.append('{');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                StubBuildingVisitor.constToString(builder, Array.get(value, i), type, anno, mapping);
            }
            builder.append('}');
        } else if (anno && value instanceof Type) {
            StubBuildingVisitor.toJavaType(builder, (Type)value, mapping);
            builder.append(".class");
        } else {
            builder.append("null");
        }
    }

    static void toJavaType(@NotNull StringBuilder sb, Type type, @NotNull SignatureParsing.TypeInfoProvider mapping) {
        if (sb == null) {
            StubBuildingVisitor.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            StubBuildingVisitor.$$$reportNull$$$0(5);
        }
        int dimensions = 0;
        if (type.getSort() == 9) {
            dimensions = type.getDimensions();
            type = type.getElementType();
        }
        sb.append(type.getSort() == 10 ? mapping.toTypeInfo(type.getInternalName()).text() : type.getClassName());
        while (dimensions-- > 0) {
            sb.append("[]");
        }
    }

    private static TypeInfo toTypeInfo(Type type, @NotNull FirstPassData mapping) {
        TypeInfo typeInfo;
        if (mapping == null) {
            StubBuildingVisitor.$$$reportNull$$$0(6);
        }
        int dimensions = 0;
        if (type.getSort() == 9) {
            dimensions = type.getDimensions();
            type = type.getElementType();
        }
        TypeInfo typeInfo2 = typeInfo = type.getSort() == 10 ? mapping.toTypeInfo(type.getInternalName()) : TypeInfo.fromString(type.getClassName());
        while (dimensions > 0) {
            --dimensions;
            typeInfo = typeInfo.arrayOf();
        }
        return typeInfo;
    }

    public static AnnotationVisitor getAnnotationTextCollector(String desc, Consumer<? super String> consumer) {
        return new AnnotationTextCollector(desc, GUESSING_PROVIDER, consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/StubBuildingVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "newReferenceList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constToString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toJavaType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toTypeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassInfo {
        private SignatureParsing.TypeParametersDeclaration typeParameters;
        private TypeInfo superType;
        private @Unmodifiable List<TypeInfo> interfaces;

        private ClassInfo() {
        }
    }

    private static final class RecordComponentAnnotationCollectingVisitor
    extends RecordComponentVisitor {
        @NotNull
        private final PsiModifierListStub myModList;
        @NotNull
        private final FirstPassData myFirstPassData;
        @NotNull
        private final ClsTypeAnnotationCollector myAnnoBuilder;

        private RecordComponentAnnotationCollectingVisitor(@NotNull PsiRecordComponentStub stub, @NotNull PsiModifierListStub modList, @NotNull FirstPassData firstPassData) {
            if (stub == null) {
                RecordComponentAnnotationCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (modList == null) {
                RecordComponentAnnotationCollectingVisitor.$$$reportNull$$$0(1);
            }
            if (firstPassData == null) {
                RecordComponentAnnotationCollectingVisitor.$$$reportNull$$$0(2);
            }
            super(589824);
            this.myModList = modList;
            this.myFirstPassData = firstPassData;
            this.myAnnoBuilder = new ClsTypeAnnotationCollector(stub.getType(), firstPassData);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myFirstPassData, (Consumer<? super String>)((Consumer)text -> new PsiAnnotationStubImpl(this.myModList, (String)text)));
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return this.myAnnoBuilder.collect(typePath, desc);
        }

        public void visitEnd() {
            this.myAnnoBuilder.install();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stub";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstPassData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor$RecordComponentAnnotationCollectingVisitor";
            objectArray[2] = StubBuildingVisitor.SYNTHETIC_INIT_METHOD;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FieldAnnotationCollectingVisitor
    extends FieldVisitor {
        @NotNull
        private final PsiModifierListStub myModList;
        @NotNull
        private final FirstPassData myFirstPassData;
        @NotNull
        private final ClsTypeAnnotationCollector myAnnoBuilder;

        private FieldAnnotationCollectingVisitor(@NotNull PsiFieldStub stub, @NotNull PsiModifierListStub modList, @NotNull FirstPassData firstPassData) {
            if (stub == null) {
                FieldAnnotationCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (modList == null) {
                FieldAnnotationCollectingVisitor.$$$reportNull$$$0(1);
            }
            if (firstPassData == null) {
                FieldAnnotationCollectingVisitor.$$$reportNull$$$0(2);
            }
            super(589824);
            this.myModList = modList;
            this.myFirstPassData = firstPassData;
            this.myAnnoBuilder = new ClsTypeAnnotationCollector(stub.getType(), firstPassData);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myFirstPassData, (Consumer<? super String>)((Consumer)text -> new PsiAnnotationStubImpl(this.myModList, (String)text)));
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return this.myAnnoBuilder.collect(typePath, desc);
        }

        public void visitEnd() {
            this.myAnnoBuilder.install();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stub";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstPassData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor$FieldAnnotationCollectingVisitor";
            objectArray[2] = StubBuildingVisitor.SYNTHETIC_INIT_METHOD;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MethodInfo {
        private SignatureParsing.TypeParametersDeclaration typeParameters;
        private TypeInfo returnType;
        private List<TypeInfo> argTypes;
        private List<TypeInfo> throwTypes;

        private MethodInfo() {
        }
    }

    private static final class MethodAnnotationCollectingVisitor
    extends MethodVisitor {
        private final PsiMethodStub myOwner;
        @NotNull
        private final MethodInfo myMethodInfo;
        @NotNull
        private final PsiModifierListStub myModList;
        private final PsiParameterStubImpl[] myParamStubs;
        private final int myParamCount;
        private final int myLocalVarIgnoreCount;
        @NotNull
        private final FirstPassData myFirstPassData;
        private int myParamIgnoreCount;
        private int myParamNameIndex;
        private int myUsedParamSize;
        private int myUsedParamCount;
        private Map<TypeInfo, ClsTypeAnnotationCollector> myAnnoBuilders;

        private MethodAnnotationCollectingVisitor(PsiMethodStub owner, @NotNull MethodInfo methodInfo, @NotNull PsiModifierListStub modList, PsiParameterStubImpl[] paramStubs, int paramIgnoreCount, int localVarIgnoreCount, @NotNull FirstPassData firstPassData) {
            if (methodInfo == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (modList == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(1);
            }
            if (firstPassData == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(2);
            }
            super(589824);
            this.myOwner = owner;
            this.myMethodInfo = methodInfo;
            this.myModList = modList;
            this.myParamStubs = paramStubs;
            this.myParamCount = paramStubs.length;
            this.myLocalVarIgnoreCount = localVarIgnoreCount;
            this.myParamIgnoreCount = paramIgnoreCount;
            this.myFirstPassData = firstPassData;
        }

        public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
            if (this.myParamIgnoreCount > 0 && parameterCount == this.myParamCount) {
                this.myParamIgnoreCount = 0;
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myFirstPassData, (Consumer<? super String>)((Consumer)text -> new PsiAnnotationStubImpl(this.myModList, (String)text)));
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return parameter < this.myParamIgnoreCount ? null : new AnnotationTextCollector(desc, this.myFirstPassData, (Consumer<? super String>)((Consumer)text -> {
                int idx = parameter - this.myParamIgnoreCount;
                new PsiAnnotationStubImpl(this.myOwner.findParameter(idx).getModList(), (String)text);
            }));
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            int index;
            TypeReference ref = new TypeReference(typeRef);
            TypeInfo info = null;
            if (ref.getSort() == 20) {
                info = this.myOwner.getReturnTypeText();
            } else if (ref.getSort() == 22) {
                int parameterIndex = ref.getFormalParameterIndex();
                if (parameterIndex < this.myParamStubs.length) {
                    info = this.myParamStubs[parameterIndex].getType();
                }
            } else if (ref.getSort() == 1) {
                info = this.myMethodInfo.typeParameters.getParameterType(ref);
            } else if (ref.getSort() == 18) {
                info = this.myMethodInfo.typeParameters.getBoundType(ref);
            } else if (ref.getSort() == 23 && (index = ref.getExceptionIndex()) < this.myMethodInfo.throwTypes.size()) {
                info = (TypeInfo)this.myMethodInfo.throwTypes.get(index);
            }
            if (info == null) {
                return null;
            }
            if (this.myAnnoBuilders == null) {
                this.myAnnoBuilders = new HashMap<TypeInfo, ClsTypeAnnotationCollector>();
            }
            return this.myAnnoBuilders.computeIfAbsent(info, typeInfo -> new ClsTypeAnnotationCollector((TypeInfo)typeInfo, this.myFirstPassData)).collect(typePath, desc);
        }

        public void visitEnd() {
            if (this.myAnnoBuilders != null) {
                this.myAnnoBuilders.values().forEach(ExplicitTypeAnnotationContainer.Collector::install);
            }
            this.myMethodInfo.typeParameters.fillInTypeParameterList((StubElement<?>)this.myOwner);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTextCollector(null, this.myFirstPassData, (Consumer<? super String>)((Consumer)text -> ((PsiMethodStubImpl)this.myOwner).setDefaultValueText((String)text)));
        }

        public void visitParameter(String name, int access) {
            int paramIndex = this.myParamNameIndex++ - this.myParamIgnoreCount;
            if (name != null && !BitUtil.isSet((int)access, (int)4096) && paramIndex >= 0 && paramIndex < this.myParamCount) {
                this.setParameterName(name, paramIndex);
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index >= this.myLocalVarIgnoreCount) {
                int paramIndex;
                int n = paramIndex = index - this.myLocalVarIgnoreCount == this.myUsedParamSize ? this.myUsedParamCount : index - this.myLocalVarIgnoreCount;
                if (paramIndex < this.myParamCount) {
                    this.setParameterName(name, paramIndex);
                    this.myUsedParamCount = paramIndex + 1;
                    this.myUsedParamSize += "D".equals(desc) || "J".equals(desc) ? 2 : 1;
                }
            }
        }

        private void setParameterName(@NotNull String name, int paramIndex) {
            if (name == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(3);
            }
            if (ClsParsingUtil.isJavaIdentifier(name, LanguageLevel.HIGHEST)) {
                this.myParamStubs[paramIndex].setName(name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstPassData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor$MethodAnnotationCollectingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = StubBuildingVisitor.SYNTHETIC_INIT_METHOD;
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setParameterName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

