/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.gateway.endpoints;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.cloud.gateway.endpoints.SpringCloudGatewayUrlTargetInfo;
import com.intellij.spring.boot.cloud.gateway.utils.SpringCloudGatewayUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.utils.SpringEndpointsIconProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringCloudGatewayServerProvider
implements EndpointsUrlTargetProvider<SpringBeanPointer<?>, SpringCloudGatewayUrlTargetInfo> {
    private final FrameworkPresentation myPresentation = new FrameworkPresentation("Spring-Cloud-Gateway", "Spring Cloud Gateway", SpringApiIcons.SpringWeb);

    SpringCloudGatewayServerProvider() {
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        FrameworkPresentation frameworkPresentation = this.myPresentation;
        if (frameworkPresentation == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(0);
        }
        return frameworkPresentation;
    }

    public boolean isValidEndpoint(@NotNull SpringBeanPointer<?> group, @NotNull SpringCloudGatewayUrlTargetInfo endpoint) {
        PsiElement element;
        if (group == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(1);
        }
        if (endpoint == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(2);
        }
        return (element = endpoint.resolveToPsiElement()) != null && element.isValid();
    }

    @Nullable
    private static String getLocationString(@NotNull SpringBeanPointer<?> beanPointer) {
        PsiElement psiElement;
        if (beanPointer == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(3);
        }
        if ((psiElement = beanPointer.getPsiElement()) != null) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            if (containingClass != null) {
                return containingClass.getName();
            }
            return beanPointer.getContainingFile().getName();
        }
        return beanPointer.getContainingFile().getName();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SpringBeanPointer<?> group, @NotNull SpringCloudGatewayUrlTargetInfo endpoint) {
        if (group == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(4);
        }
        if (endpoint == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(5);
        }
        return new HttpMethodPresentation(endpoint.getUrlPath(), new ArrayList<String>(endpoint.getMethods()), SpringCloudGatewayServerProvider.getLocationString(group), SpringEndpointsIconProvider.getEndpointIcon((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)group.getContainingFile()), (String)endpoint.getUrlPath(), (String[])ArrayUtil.toStringArray(endpoint.getMethods())), (TextAttributesKey)(endpoint.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SpringBeanPointer<?> group, @NotNull SpringCloudGatewayUrlTargetInfo endpoint) {
        if (group == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(6);
        }
        if (endpoint == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(7);
        }
        return endpoint.getDocumentationPsiElement();
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull SpringBeanPointer<?> group, @NotNull SpringCloudGatewayUrlTargetInfo endpoint) {
        if (group == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(8);
        }
        if (endpoint == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(9);
        }
        return endpoint.resolveToPsiElement();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull SpringBeanPointer<?> group, @NotNull SpringCloudGatewayUrlTargetInfo endpoint) {
        if (group == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(10);
        }
        if (endpoint == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(11);
        }
        List<UrlTargetInfo> list = Collections.singletonList(endpoint);
        if (list == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public Iterable<SpringCloudGatewayUrlTargetInfo> getEndpoints(SpringBeanPointer<?> group) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)group.getContainingFile());
        if (module == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringCloudGatewayServerProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        Set<SpringCloudGatewayUrlTargetInfo> set = SpringCloudGatewayUtil.getRouteLocatorPaths(module, group);
        if (set == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
        if (endpointType == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(15);
        }
        return endpointType;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(16);
        }
        if (!SpringCloudGatewayUtil.hasSpringCloudGatewayLibrary(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                SpringCloudGatewayServerProvider.$$$reportNull$$$0(17);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
        if (status == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(18);
        }
        return status;
    }

    @NotNull
    public Iterable<SpringBeanPointer<?>> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(19);
        }
        if (filter == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(20);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringCloudGatewayServerProvider.$$$reportNull$$$0(21);
            }
            return list;
        }
        Module module = ((ModuleEndpointsFilter)filter).getModule();
        if (!SpringCloudGatewayUtil.hasSpringCloudGatewayLibrary(module)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringCloudGatewayServerProvider.$$$reportNull$$$0(22);
            }
            return list;
        }
        Set<SpringBeanPointer<?>> set = SpringCloudGatewayUtil.getRouteLocators(module);
        if (set == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(23);
        }
        return set;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(24);
        }
        ModificationTracker modificationTracker = SpringModificationTrackersManager.getInstance((Project)project).getEndpointsModificationTracker();
        if (modificationTracker == null) {
            SpringCloudGatewayServerProvider.$$$reportNull$$$0(25);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 19, 20, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/gateway/endpoints/SpringCloudGatewayServerProvider";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 20: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/gateway/endpoints/SpringCloudGatewayServerProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTargetInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUrlTargetInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 19, 20, 24 -> new IllegalArgumentException(string);
        };
    }
}

