/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.docker.DockerContainerStatus;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerServerStatus;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.LayeredIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0000\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\r\u001a\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"checkHealthyAnimatedIcon", "Lcom/intellij/ui/AnimatedIcon;", "getCheckHealthyAnimatedIcon", "()Lcom/intellij/ui/AnimatedIcon;", "checkHealthyAnimatedIcon$delegate", "Lkotlin/Lazy;", "getContainerIcon", "Ljavax/swing/Icon;", "status", "Lcom/intellij/docker/DockerContainerStatus;", "getServerIcon", "Lcom/intellij/docker/DockerServerStatus;", "getComposeProjectIcon", "Lcom/intellij/docker/runtimes/ComposeServiceStatus;", "getComposeServiceIcon", "scaledService", "", "intellij.clouds.docker.shared"})
@SourceDebugExtension(value={"SMAP\ndockerIconUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerIconUtils.kt\ncom/intellij/docker/ui/utils/DockerIconUtilsKt\n+ 2 sharedInternalUtils.kt\ncom/intellij/docker/utils/SharedInternalUtilsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n6#2,7:77\n37#3,2:84\n*S KotlinDebug\n*F\n+ 1 dockerIconUtils.kt\ncom/intellij/docker/ui/utils/DockerIconUtilsKt\n*L\n17#1:77,7\n17#1:84,2\n*E\n"})
public final class DockerIconUtilsKt {
    @NotNull
    private static final Lazy checkHealthyAnimatedIcon$delegate = LazyKt.lazy(DockerIconUtilsKt::checkHealthyAnimatedIcon_delegate$lambda$0);

    private static final AnimatedIcon getCheckHealthyAnimatedIcon() {
        Lazy lazy = checkHealthyAnimatedIcon$delegate;
        return (AnimatedIcon)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Icon getContainerIcon(@NotNull DockerContainerStatus status) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (ExperimentalUI.Companion.isNewUI()) {
            DockerContainerStatus dockerContainerStatus = status;
            if (dockerContainerStatus instanceof DockerContainerStatus.Up.Running || dockerContainerStatus instanceof DockerContainerStatus.Up.Healthy) {
                Icon icon2 = DockerIcons.SingleRunningContainer;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SingleRunningContainer");
                icon = new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Up.Unhealthy) {
                Icon icon3 = DockerIcons.SingleRunningContainer;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SingleRunningContainer");
                icon = new BadgeIconSupplier(icon3).getWarningIcon();
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Up.CheckHealthy) {
                icon = (Icon)DockerIconUtilsKt.getCheckHealthyAnimatedIcon();
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Stopped) {
                Icon icon4 = DockerIcons.SingleStoppedContainer;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SingleStoppedContainer");
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Paused) {
                Icon icon5 = AllIcons.RunConfigurations.TestPaused;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"TestPaused");
                return icon;
            } else {
                if (!(dockerContainerStatus instanceof DockerContainerStatus.Stopping)) throw new NoWhenBranchMatchedException();
                AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                icon = (Icon)animatedIcon;
            }
            return icon;
        } else {
            DockerContainerStatus dockerContainerStatus = status;
            if (dockerContainerStatus instanceof DockerContainerStatus.Stopped) {
                Icon icon6 = DockerIcons.SingleStoppedContainer;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"SingleStoppedContainer");
                return icon;
            } else if (dockerContainerStatus instanceof DockerContainerStatus.Paused) {
                Icon icon7 = AllIcons.RunConfigurations.TestPaused;
                icon = icon7;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"TestPaused");
                return icon;
            } else {
                Icon icon8 = DockerIcons.SingleRunningContainer;
                icon = icon8;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"SingleRunningContainer");
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon getServerIcon(@NotNull DockerServerStatus status) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        DockerServerStatus dockerServerStatus = status;
        if (Intrinsics.areEqual((Object)dockerServerStatus, (Object)DockerServerStatus.Connected.INSTANCE)) {
            if (ExperimentalUI.Companion.isNewUI()) {
                Icon icon2 = DockerIcons.Docker;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Docker");
                icon = new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
            } else {
                icon = (Icon)LayeredIcon.Companion.layeredIcon(DockerIconUtilsKt::getServerIcon$lambda$0);
            }
        } else if (dockerServerStatus instanceof DockerServerStatus.Error) {
            icon = (Icon)LayeredIcon.Companion.layeredIcon(DockerIconUtilsKt::getServerIcon$lambda$1);
        } else if (Intrinsics.areEqual((Object)dockerServerStatus, (Object)DockerServerStatus.Disconnected.INSTANCE)) {
            icon = (Icon)LayeredIcon.Companion.layeredIcon(DockerIconUtilsKt::getServerIcon$lambda$2);
        } else if (Intrinsics.areEqual((Object)dockerServerStatus, (Object)DockerServerStatus.Connecting.INSTANCE)) {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
            icon = (Icon)animatedIcon;
        } else {
            Icon icon3 = DockerIcons.Docker;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Docker");
        }
        return icon;
    }

    @NotNull
    public static final Icon getComposeProjectIcon(@NotNull ComposeServiceStatus $this$getComposeProjectIcon) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getComposeProjectIcon), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getComposeProjectIcon.ordinal()]) {
            case 1: {
                Icon[] iconArray = new Icon[2];
                Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.ContainersList_2_grey, (String)"ContainersList_2_grey");
                Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.InvalidConfigurationLayer, (String)"InvalidConfigurationLayer");
                icon = (Icon)LayeredIcon.Companion.layeredIcon(iconArray);
                break;
            }
            case 2: {
                Icon icon2 = DockerIcons.ContainersList_2_grey;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ContainersList_2_grey");
                icon = IconLoader.getTransparentIcon((Icon)icon2, (float)0.5f);
                break;
            }
            case 3: {
                Icon icon3 = DockerIcons.ContainersList_2_grey;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ContainersList_2_grey");
                break;
            }
            case 4: 
            case 5: {
                Icon icon4 = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ContainersList_2");
                icon = new BadgeIconSupplier(icon4).getLiveIndicatorIcon();
                break;
            }
            case 6: {
                Icon icon5 = DockerIcons.ContainersList_2;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ContainersList_2");
                icon = new BadgeIconSupplier(icon5).getWarningIcon();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon getComposeServiceIcon(@NotNull ComposeServiceStatus $this$getComposeServiceIcon, boolean scaledService) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getComposeServiceIcon), (String)"<this>");
        Icon icon = scaledService ? DockerIcons.DockerComposeScaledService : DockerIcons.DockerComposeService;
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        Icon icon3 = scaledService ? DockerIcons.DockerComposeScaledServiceStopped : DockerIcons.DockerComposeServiceStopped;
        Intrinsics.checkNotNull((Object)icon3);
        Icon iconStopped = icon3;
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getComposeServiceIcon.ordinal()]) {
            case 1 -> {
                Icon[] var5_5 = new Icon[2];
                var5_5[0] = iconStopped;
                Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.InvalidConfigurationLayer, (String)"InvalidConfigurationLayer");
                yield (Icon)LayeredIcon.Companion.layeredIcon(var5_5);
            }
            case 2 -> IconLoader.getTransparentIcon((Icon)iconStopped, (float)0.5f);
            case 4, 5 -> new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
            case 3 -> iconStopped;
            case 6 -> new BadgeIconSupplier(icon2).getWarningIcon();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final AnimatedIcon checkHealthyAnimatedIcon_delegate$lambda$0() {
        void n$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Icon icon = DockerIcons.SingleRunningContainer;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SingleRunningContainer");
        Icon icon2 = new BadgeIconSupplier(icon).getLiveIndicatorIcon();
        int n = 3;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        int n2 = 270;
        boolean $i$f$repeat = false;
        List list$iv = new ArrayList();
        int n3 = 0;
        while (n3 < n$iv) {
            void $this$repeat$iv;
            int it$iv = n3++;
            boolean bl = false;
            list$iv.add($this$repeat$iv);
        }
        Collection $this$toTypedArray$iv$iv = list$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        Icon[] iconArray = thisCollection$iv$iv.toArray(new Icon[0]);
        spreadBuilder2.addSpread((Object)iconArray);
        spreadBuilder.add((Object)DockerIcons.SingleRunningContainer);
        Icon[] iconArray2 = (Icon[])spreadBuilder.toArray((Object[])new Icon[spreadBuilder.size()]);
        int n4 = n2;
        return new AnimatedIcon(n4, iconArray2);
    }

    private static final Icon[] getServerIcon$lambda$0() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.Docker, (String)"Docker");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RemoteServers.ResumeScaled, (String)"ResumeScaled");
        return iconArray;
    }

    private static final Icon[] getServerIcon$lambda$1() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.Docker, (String)"Docker");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RunConfigurations.InvalidConfigurationLayer, (String)"InvalidConfigurationLayer");
        return iconArray;
    }

    private static final Icon[] getServerIcon$lambda$2() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)DockerIcons.Docker, (String)"Docker");
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.RemoteServers.SuspendScaled, (String)"SuspendScaled");
        return iconArray;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComposeServiceStatus.values().length];
            try {
                nArray[ComposeServiceStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.WITHOUT_CONTAINERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.UP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.HEALTHY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeServiceStatus.UNHEALTHY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

