/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JpaValidatorBase
extends InspectionValidator {
    public JpaValidatorBase(@NonNls String id, @Nls String description) {
        super(id, description, JpaMessages.message("progress.validating.persistence.model.text", new Object[0]));
    }

    protected abstract boolean acceptsFacet(PersistenceFacet var1);

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            JpaValidatorBase.$$$reportNull$$$0(0);
        }
        return !this.processScopeFacets(scope.getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> false));
    }

    private boolean processScopeFacets(Module[] modules, PairProcessor<Module, PersistenceFacet> processor) {
        for (Module module : modules) {
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                if (!this.acceptsFacet(facet) || ((Boolean)ReadAction.compute(() -> facet.getPersistenceUnits().isEmpty())).booleanValue() || processor.process((Object)module, (Object)facet)) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        VirtualFile[] javaFiles;
        HashSet enabledModules = new HashSet();
        HashSet enabledFacets = new HashSet();
        this.processScopeFacets(context.getCompileScope().getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> {
            enabledFacets.add(facet);
            enabledModules.add(module);
            return true;
        }));
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile javaFile : javaFiles = context.getCompileScope().getFiles((FileType)JavaFileType.INSTANCE, true)) {
            Module module2 = context.getModuleByFile(javaFile);
            if (module2 == null || !enabledModules.contains(module2)) continue;
            result.add(javaFile);
        }
        HashSet descriptorFiles = new HashSet();
        for (PersistenceFacet facet2 : enabledFacets) {
            for (ConfigFile configFile : facet2.getDescriptors()) {
                InspectionValidatorUtil.addDescriptor(descriptorFiles, (ConfigFile)configFile);
            }
            for (PersistencePackage unit : facet2.getPersistenceUnits()) {
                for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                    PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                    if (mappings == null) continue;
                    InspectionValidatorUtil.addFile(descriptorFiles, (PsiFile)mappings.getContainingFile());
                }
            }
        }
        result.addAll(InspectionValidatorUtil.expandCompileScopeIfNeeded(descriptorFiles, (CompileContext)context));
        return result;
    }

    @NotNull
    public Collection<PsiElement> getDependencies(PsiFile psiFile) {
        Module module;
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiFile) || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JpaValidatorBase.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            ArrayList result = new ArrayList();
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                if (!this.acceptsFacet(facet)) continue;
                for (PersistencePackage unit : facet.getPersistenceUnits()) {
                    for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                        PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                        if (!(mappings instanceof DomElement)) continue;
                        ContainerUtil.addIfNotNull(result, (Object)mappings.getContainingFile());
                    }
                }
                for (ConfigFile configFile : facet.getDescriptors()) {
                    ContainerUtil.addIfNotNull(result, (Object)configFile.getPsiFile());
                }
            }
            return result;
        });
        if (collection == null) {
            JpaValidatorBase.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        HashSet result = new HashSet();
        this.processScopeFacets(context.getCompileScope().getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> {
            ContainerUtil.addAll((Collection)result, (Object[])facet.getInspectionToolClasses());
            return true;
        }));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            String inspectionName = ((Class)it.next()).getSimpleName();
            if (!"JpaQueryApiInspection".equals(inspectionName) && !"CriteriaApiResolveInspection".equals(inspectionName)) continue;
            it.remove();
        }
        Class[] classArray = result.toArray(new Class[result.size()]);
        if (classArray == null) {
            JpaValidatorBase.$$$reportNull$$$0(3);
        }
        return classArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaValidatorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaValidatorBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

