/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.maria;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.mysqlbase.MysqlBaseDomains;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MariaDomains
extends MysqlBaseDomains {
    public MariaDomains(@NotNull Dbms dbms) {
        if (dbms == null) {
            MariaDomains.$$$reportNull$$$0(0);
        }
        super(dbms, true, false);
        this.add((Domain)new TextDomain("tinytext", ConversionPoint.VARCHAR, 255L));
        this.add((Domain)new TextDomain(this, "text", ConversionPoint.TEXT, 65535L){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof DataConsumer.Column) {
                    int precision = ((DataConsumer.Column)descriptor).getSize();
                    return StringUtil.equalsIgnoreCase((CharSequence)"text", (CharSequence)descriptor.getTypeName()) || StringUtil.equalsIgnoreCase((CharSequence)"varchar", (CharSequence)descriptor.getTypeName()) && (long)precision == this.getLength();
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$1", "isSuitable"));
            }
        });
        this.add(new TextDomain(this, "mediumtext", ConversionPoint.CLOB, 0xFFFFFFL){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof DataConsumer.Column) {
                    int precision = ((DataConsumer.Column)descriptor).getSize();
                    return StringUtil.equalsIgnoreCase((CharSequence)"mediumtext", (CharSequence)descriptor.getTypeName()) || StringUtil.equalsIgnoreCase((CharSequence)"varchar", (CharSequence)descriptor.getTypeName()) && (long)precision == this.getLength();
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$2", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain(this, "longtext", ConversionPoint.CLOB, 0xFFFFFFFFL){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof DataConsumer.Column) {
                    return descriptor.getType() == -1;
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$3", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true, false));
        this.add((Domain)new TextDomain(this, "varchar", ConversionPoint.VARCHAR, 21844L, TextDomain.Length.mandatory((long)4368L, (boolean)true)){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof DataConsumer.Column) {
                    return super.isSuitable(descriptor) && descriptor.getType() == 12 && (long)((DataConsumer.Column)descriptor).getSize() <= this.getLength();
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/maria/MariaDomains$4", "isSuitable"));
            }
        });
        this.add((Domain)new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21844L, TextDomain.Length.mandatory((long)4368L, (boolean)true)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/maria/MariaDomains", "<init>"));
    }
}

