/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ssh;

import com.intellij.docker.auth.SshGuiAuthService;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.externalProcessAuthHelper.NativeSshAuthService;
import com.intellij.externalProcessAuthHelper.NativeSshGuiAuthenticator;
import com.intellij.externalProcessAuthHelper.PassthroughAuthenticationGate;
import com.intellij.externalProcessAuthHelper.ScriptGenerator;
import com.intellij.externalProcessAuthHelper.ScriptGeneratorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.StringKt;
import externalApp.ExternalAppHandler;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/ssh/SshGuiAuthServiceImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/docker/auth/SshGuiAuthService;", "<init>", "()V", "mySshAskPort", "", "mySshAskHandlerUUID", "Ljava/util/UUID;", "myAskPassScriptPass", "Ljava/io/File;", "getAskPassEnvs", "", "", "dispose", "", "Companion", "intellij.clouds.docker.ssh"})
@ApiStatus.Internal
public final class SshGuiAuthServiceImpl
implements Disposable,
SshGuiAuthService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int mySshAskPort;
    @NotNull
    private final UUID mySshAskHandlerUUID;
    @NotNull
    private final File myAskPassScriptPass;
    @NotNull
    private static final String SCRIPT_ID = "com.intellij.clouds.docker";
    @NotNull
    private static final String DISPLAY_ENV = "DISPLAY";

    public SshGuiAuthServiceImpl() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
        Project defaultProject = project;
        NativeSshAuthService service = NativeSshAuthService.Companion.getInstance();
        PassthroughAuthenticationGate authenticationGate = PassthroughAuthenticationGate.Companion.getInstance();
        NativeSshGuiAuthenticator authenticator = new NativeSshGuiAuthenticator(defaultProject, (AuthenticationGate)authenticationGate, AuthenticationMode.FULL, false);
        this.mySshAskHandlerUUID = service.registerHandler((ExternalAppHandler)authenticator, (Disposable)this);
        this.mySshAskPort = service.getIdePort();
        this.myAskPassScriptPass = service.getCallbackScriptPath(SCRIPT_ID, (ScriptGenerator)new ScriptGeneratorImpl(), SystemInfo.isWindows);
    }

    @NotNull
    public Map<String, String> getAskPassEnvs() {
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"SSH_ASKPASS", (Object)this.myAskPassScriptPass.getAbsolutePath());
        pairArray[1] = TuplesKt.to((Object)"INTELLIJ_SSH_ASKPASS_HANDLER", (Object)this.mySshAskHandlerUUID.toString());
        pairArray[2] = TuplesKt.to((Object)"INTELLIJ_SSH_ASKPASS_PORT", (Object)String.valueOf(this.mySshAskPort));
        pairArray[3] = TuplesKt.to((Object)"SSH_ASKPASS_REQUIRE", (Object)"force");
        String string = StringKt.nullize((String)System.getenv(DISPLAY_ENV), (boolean)true);
        if (string == null) {
            string = ":0.0";
        }
        pairArray[4] = TuplesKt.to((Object)DISPLAY_ENV, (Object)string);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/ssh/SshGuiAuthServiceImpl$Companion;", "", "<init>", "()V", "SCRIPT_ID", "", "DISPLAY_ENV", "intellij.clouds.docker.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

