/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.orm;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.orm.jpa.AbstractJpaOrmProvider;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.re.ReverseEngineeringHelper;
import com.intellij.re.orm.OrmReInfoProvider;
import com.intellij.re.util.DatatypeUtilKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J4\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0084@\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/re/orm/JpaOrmReInfoProvider;", "Lcom/intellij/jpa/jpb/model/orm/jpa/AbstractJpaOrmProvider;", "Lcom/intellij/re/orm/OrmReInfoProvider;", "<init>", "()V", "generateClassName", "", "project", "Lcom/intellij/openapi/project/Project;", "tableName", "getAppropriateParents", "", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "idAttributes", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkTypesCompatibility", "", "attribute", "attributeWithSql", "getFilteredEntities", "filter", "Ljava/util/function/Predicate;", "Lcom/intellij/jpa/jpb/model/model/Entity;", "(Lcom/intellij/openapi/project/Project;Ljava/util/function/Predicate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nJpaOrmReInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaOrmReInfoProvider.kt\ncom/intellij/re/orm/JpaOrmReInfoProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1740#2,2:91\n1761#2,3:93\n1742#2:96\n*S KotlinDebug\n*F\n+ 1 JpaOrmReInfoProvider.kt\ncom/intellij/re/orm/JpaOrmReInfoProvider\n*L\n57#1:91,2\n58#1:93,3\n57#1:96\n*E\n"})
public class JpaOrmReInfoProvider
implements AbstractJpaOrmProvider,
OrmReInfoProvider {
    @Override
    @Nullable
    public String generateClassName(@NotNull Project project, @NotNull String tableName) {
        String unpluralizeClassName;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        char c = Character.toUpperCase(tableName.charAt(0));
        String string = tableName.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string;
        String javaName = c + string2;
        javaName = ReverseEngineeringHelper.Companion.convertToJavaIdentifier(project, javaName, ReverseEngineeringHelper.IdentifierType.CLASS);
        if (javaName != null && JpaPluginProjectConfig.Companion.getInstance((Project)project).getState().unpluralizeTableName && StringUtil.isNotEmpty((String)(unpluralizeClassName = StringUtil.unpluralize((String)javaName)))) {
            return unpluralizeClassName;
        }
        return javaName;
    }

    @Override
    @Nullable
    public Object getAppropriateParents(@NotNull Project project, @NotNull List<? extends EntityAttribute> idAttributes, @Nullable DbType dbType, @NotNull Continuation<? super List<? extends OrmEntity>> $completion) {
        return JpaOrmReInfoProvider.getAppropriateParents$suspendImpl(this, project, idAttributes, dbType, $completion);
    }

    static /* synthetic */ Object getAppropriateParents$suspendImpl(JpaOrmReInfoProvider $this, Project project, List<? extends EntityAttribute> idAttributes, DbType dbType, Continuation<? super List<? extends OrmEntity>> $completion) {
        if (idAttributes.isEmpty()) {
            return $this.getFilteredEntities(project, JpaOrmReInfoProvider::getAppropriateParents$lambda$0, $completion);
        }
        if (idAttributes.size() == 1 && !(((EntityAttribute)CollectionsKt.first(idAttributes)).getType() instanceof EntityModel)) {
            EntityAttribute dbIdAttr = (EntityAttribute)CollectionsKt.first(idAttributes);
            return $this.getFilteredEntities(project, arg_0 -> JpaOrmReInfoProvider.getAppropriateParents$lambda$1($this, dbIdAttr, dbType, project, arg_0), $completion);
        }
        if (idAttributes.size() == 1 && ((EntityAttribute)CollectionsKt.first(idAttributes)).getType() instanceof EntityModel) {
            EntityAttribute dbIdAttr = (EntityAttribute)CollectionsKt.first(idAttributes);
            Datatype datatype = dbIdAttr.getType();
            Intrinsics.checkNotNull((Object)datatype, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.model.EntityModel");
            List list = ((EntityModel)datatype).getAllAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAttributes(...)");
            List embIdAttrs = list;
            return $this.getFilteredEntities(project, arg_0 -> JpaOrmReInfoProvider.getAppropriateParents$lambda$2(embIdAttrs, $this, dbType, project, arg_0), $completion);
        }
        return $this.getFilteredEntities(project, JpaOrmReInfoProvider::getAppropriateParents$lambda$3, $completion);
    }

    private final boolean checkTypesCompatibility(EntityAttribute attribute, EntityAttribute attributeWithSql, DbType dbType, Project project) {
        Datatype datatype = attribute.getType();
        Intrinsics.checkNotNullExpressionValue((Object)datatype, (String)"getType(...)");
        Object v = attributeWithSql.getAdditionalProperties().get("sqlType");
        return DatatypeUtilKt.isCompatibleToType(datatype, v != null ? v.toString() : null, dbType, project);
    }

    @Nullable
    protected final Object getFilteredEntities(@NotNull Project project, @NotNull Predicate<Entity> filter, @NotNull Continuation<? super List<? extends OrmEntity>> $completion) {
        return CoroutinesKt.readAction(() -> JpaOrmReInfoProvider.getFilteredEntities$lambda$0(project, filter), $completion);
    }

    private static final boolean getAppropriateParents$lambda$0(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isMappedSuperclass();
    }

    private static final boolean getAppropriateParents$lambda$1(JpaOrmReInfoProvider this$0, EntityAttribute $dbIdAttr, DbType $dbType, Project $project, Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = ReadAction.compute(() -> JpaOrmReInfoProvider.getAppropriateParents$lambda$1$0(it, this$0, $dbIdAttr, $dbType, $project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean getAppropriateParents$lambda$1$0(Entity $it, JpaOrmReInfoProvider this$0, EntityAttribute $dbIdAttr, DbType $dbType, Project $project) {
        boolean bl;
        block2: {
            block3: {
                if (!$it.isMappedSuperclass()) break block2;
                if ($it.getIdAttributeOrNull() == null) break block3;
                EntityAttribute entityAttribute = $it.getIdAttribute();
                Intrinsics.checkNotNullExpressionValue((Object)entityAttribute, (String)"getIdAttribute(...)");
                if (!this$0.checkTypesCompatibility(entityAttribute, $dbIdAttr, $dbType, $project)) break block2;
            }
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getAppropriateParents$lambda$2(List $embIdAttrs, JpaOrmReInfoProvider this$0, DbType $dbType, Project $project, Entity it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isMappedSuperclass()) {
            return false;
        }
        EntityAttribute entityAttribute = it.getIdAttributeOrNull();
        if (entityAttribute == null) {
            return true;
        }
        EntityAttribute parentId2 = entityAttribute;
        Datatype datatype = parentId2.getType();
        if (!(datatype instanceof Entity)) return false;
        Entity entity = (Entity)datatype;
        if (entity == null) {
            return false;
        }
        Entity parentIdClass = entity;
        List list = parentIdClass.getAllAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAttributes(...)");
        List parentEmbAttrs = list;
        if (parentEmbAttrs.size() != $embIdAttrs.size()) return false;
        Iterable $this$all$iv = parentEmbAttrs;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            Object object;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            EntityAttribute parentAttr = (EntityAttribute)element$iv;
            boolean bl2 = false;
            Iterable $this$any$iv = $embIdAttrs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv2 = iterator2.next();
                EntityAttribute embAttr = (EntityAttribute)element$iv2;
                boolean bl3 = false;
                object = ReadAction.compute(() -> JpaOrmReInfoProvider.getAppropriateParents$lambda$2$0$0$0(embAttr, parentAttr, this$0, $dbType, $project));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            } while (!((Boolean)object).booleanValue());
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean getAppropriateParents$lambda$2$0$0$0(EntityAttribute $embAttr, EntityAttribute $parentAttr, JpaOrmReInfoProvider this$0, DbType $dbType, Project $project) {
        boolean bl;
        if (Intrinsics.areEqual((Object)$embAttr.getColumnPhysical(), (Object)$parentAttr.getColumnPhysical())) {
            Intrinsics.checkNotNull((Object)$parentAttr);
            Intrinsics.checkNotNull((Object)$embAttr);
            if (this$0.checkTypesCompatibility($parentAttr, $embAttr, $dbType, $project)) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }

    private static final boolean getAppropriateParents$lambda$3(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isMappedSuperclass() && it.getIdAttributeOrNull() == null;
    }

    private static final List getFilteredEntities$lambda$0(Project $project, Predicate $filter) {
        List list = EntitySearch.getInstance((Project)$project).getAllWrapEntities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllWrapEntities(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> JpaOrmReInfoProvider.getFilteredEntities$lambda$0$0($filter, arg_0)), JpaOrmReInfoProvider::getFilteredEntities$lambda$0$1));
    }

    private static final boolean getFilteredEntities$lambda$0$0(Predicate $filter, Entity it) {
        return $filter.test(it);
    }

    private static final CustomJpaOrmEntity getFilteredEntities$lambda$0$1(Entity it) {
        Intrinsics.checkNotNull((Object)it);
        return new CustomJpaOrmEntity(it);
    }
}

