/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.tags;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.polySymbols.completion.PolySymbolCodeCompletionItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.inspections.quickfixes.VueImportComponentQuickFix;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/vuejs/codeInsight/tags/VueInsertHandler;", "Lcom/intellij/codeInsight/completion/XmlTagInsertHandler;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "intellij.vuejs.backend"})
public final class VueInsertHandler
extends XmlTagInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VueInsertHandler INSTANCE = new VueInsertHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (VueInsertHandler.Companion.shouldHandleXmlInsert(context)) {
            super.handleInsert(context, item);
        }
        PsiElement psiElement = PolySymbolCodeCompletionItem.Companion.getPsiElement(item);
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        PsiFile importedFile = element.getContainingFile();
        if (Intrinsics.areEqual((Object)importedFile, (Object)context.getFile())) {
            return;
        }
        VirtualFile nodeModule = NodeModuleSearchUtil.findDependencyRoot((VirtualFile)element.getContainingFile().getVirtualFile());
        if (VueInsertHandler.Companion.isSkippedModule(nodeModule)) {
            return;
        }
        context.commitDocument();
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        XmlTagNameSynchronizer.Companion.runWithoutCancellingSyncTagsEditing(document, () -> VueInsertHandler.handleInsert$lambda$0(context, item, element));
    }

    private static final void handleInsert$lambda$0(InsertionContext $context, LookupElement $item, PsiElement $element) {
        PsiElement psiElement = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$context.getFile(), (int)$context.getStartOffset(), PsiElement.class, (boolean)false);
        if (psiElement == null) {
            return;
        }
        PsiElement location = psiElement;
        String string = $item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        new VueImportComponentQuickFix(location, StringsKt.removePrefix((String)string, (CharSequence)"<"), $element).applyFix();
        PostprocessReformattingAspect.getInstance((Project)$context.getProject()).doPostponedFormatting();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/codeInsight/tags/VueInsertHandler$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/vuejs/codeInsight/tags/VueInsertHandler;", "getINSTANCE", "()Lorg/jetbrains/vuejs/codeInsight/tags/VueInsertHandler;", "reformatElement", "", "element", "Lcom/intellij/psi/PsiElement;", "shouldHandleXmlInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "isSkippedModule", "nodeModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vuejs.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VueInsertHandler getINSTANCE() {
            return INSTANCE;
        }

        public final void reformatElement(@Nullable PsiElement element) {
            if (element != null && element.isValid()) {
                TextRange range = element.getTextRange();
                PsiElement psiElement = element;
                PsiFile psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
                if (psiFile == null) {
                    psiFile = element.getContainingFile();
                }
                FormatFixer.doReformat((PsiFile)psiFile, (int)range.getStartOffset(), (int)range.getEndOffset());
            }
        }

        private final boolean shouldHandleXmlInsert(InsertionContext context) {
            PsiFile psiFile = context.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            PsiFile file = psiFile;
            if (!file.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
                return false;
            }
            XmlTag element = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), XmlTag.class, (boolean)false);
            return element == null || element.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSkippedModule(VirtualFile nodeModule) {
            if (nodeModule == null) return false;
            VirtualFile virtualFile = nodeModule.getParent();
            if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)"node_modules")) return false;
            if (Intrinsics.areEqual((Object)"vue", (Object)nodeModule.getName())) return true;
            if (!Intrinsics.areEqual((Object)"vue-router", (Object)nodeModule.getName())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

