/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.mesh;

import com.github.weisj.jsvg.geometry.mesh.Bezier;
import com.github.weisj.jsvg.geometry.mesh.Split;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;

final class LineBezier
extends Bezier {
    LineBezier(@NotNull Point2D.Float a2, @NotNull Point2D.Float b2) {
        super(a2, GeometryUtil.lerp(0.33333334f, b2, a2), GeometryUtil.lerp(0.6666667f, b2, a2), b2);
    }

    @Override
    public void appendTo(@NotNull Path2D p) {
        p.lineTo(this.d.x, this.d.y);
    }

    @Override
    @NotNull
    public Split<Bezier> split() {
        Point2D.Float mid = GeometryUtil.midPoint(this.a, this.d);
        return new Split<Bezier>(new LineBezier(this.a, mid), new LineBezier(mid, this.d));
    }
}

