/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.path;

import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

final class Vertical
extends PathCommand {
    private final float y;

    public Vertical(boolean isRelative, float y2) {
        super(isRelative, 2);
        this.y = y2;
    }

    @Override
    public void appendPath(@NotNull Path2D path2, @NotNull BuildHistory hist) {
        float xOff = hist.lastPoint.x;
        float yOff = this.isRelative() ? hist.lastPoint.y : 0.0f;
        path2.lineTo(xOff, this.y + yOff);
        hist.setLastPoint(path2.getCurrentPoint());
        hist.setLastKnot(path2.getCurrentPoint());
    }

    public String toString() {
        return "V " + this.y;
    }
}

