/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.canvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.AffineTransform;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.core.canvas.Path2d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 62\u00020\u0001:\u000656789:B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006JJ\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u0019JZ\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u0019Jb\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J@\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J \u0010/\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u0019J \u00100\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006;"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d;", "", "commands", "", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$PathCommand;", "(Ljava/util/List;)V", "()V", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "isEmpty", "", "()Z", "arc", "x", "", "y", "radius", "startAngle", "endAngle", "anticlockwise", "connect", "at", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "radiusX", "radiusY", "rotation", "x1", "", "y1", "x2", "y2", "rxIn", "ryIn", "angle", "largeArcFlag", "sweepFlag", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "closePath", "copy", "getCommands", "lineTo", "moveTo", "toString", "", "transform", "affineTransform", "ClosePath", "Companion", "CubicCurveTo", "LineTo", "MoveTo", "PathCommand", "canvas"})
@SourceDebugExtension(value={"SMAP\nPath2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path2d.kt\norg/jetbrains/letsPlot/core/canvas/Path2d\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,440:1\n1549#2:441\n1620#2,3:442\n1#3:445\n*S KotlinDebug\n*F\n+ 1 Path2d.kt\norg/jetbrains/letsPlot/core/canvas/Path2d\n*L\n31#1:441\n31#1:442,3\n*E\n"})
public final class Path2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleRectangle bounds = DoubleRectangle.Companion.getZERO();
    @NotNull
    private final List<PathCommand> commands = new ArrayList();

    public Path2d() {
    }

    private Path2d(List<? extends PathCommand> commands) {
        this();
        CollectionsKt.addAll((Collection)this.commands, (Iterable)commands);
    }

    public final boolean isEmpty() {
        return this.commands.isEmpty();
    }

    @NotNull
    public final DoubleRectangle getBounds() {
        return this.bounds;
    }

    @NotNull
    public final Path2d copy() {
        return new Path2d(CollectionsKt.toMutableList((Collection)this.commands));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path2d transform(@NotNull AffineTransform affineTransform) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)affineTransform, (String)"affineTransform");
        Iterable $this$map$iv = this.commands;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PathCommand pathCommand = (PathCommand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.transform(affineTransform));
        }
        List list2 = (List)destination$iv$iv;
        return new Path2d(list2);
    }

    @NotNull
    public final List<PathCommand> getCommands() {
        return CollectionsKt.toList((Iterable)this.commands);
    }

    @NotNull
    public final Path2d closePath() {
        ((Collection)this.commands).add(ClosePath.INSTANCE);
        return this;
    }

    @NotNull
    public final Path2d moveTo(double x2, double y2, @NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        DoubleVector p = at.transform(x2, y2);
        ((Collection)this.commands).add(new MoveTo(p.getX(), p.getY()));
        return this;
    }

    public static /* synthetic */ Path2d moveTo$default(Path2d path2d, double d, double d2, AffineTransform affineTransform, int n, Object object) {
        if ((n & 4) != 0) {
            affineTransform = AffineTransform.Companion.getIDENTITY();
        }
        return path2d.moveTo(d, d2, affineTransform);
    }

    @NotNull
    public final Path2d lineTo(double x2, double y2, @NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        DoubleVector p = at.transform(x2, y2);
        ((Collection)this.commands).add(new LineTo(p.getX(), p.getY()));
        return this;
    }

    public static /* synthetic */ Path2d lineTo$default(Path2d path2d, double d, double d2, AffineTransform affineTransform, int n, Object object) {
        if ((n & 4) != 0) {
            affineTransform = AffineTransform.Companion.getIDENTITY();
        }
        return path2d.lineTo(d, d2, affineTransform);
    }

    @NotNull
    public final Path2d arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean anticlockwise, boolean connect, @NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        this.arc(x2, y2, radius, radius, 0.0, startAngle, endAngle, anticlockwise, connect, at);
        return this;
    }

    public static /* synthetic */ Path2d arc$default(Path2d path2d, double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, AffineTransform affineTransform, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        if ((n & 0x80) != 0) {
            affineTransform = AffineTransform.Companion.getIDENTITY();
        }
        return path2d.arc(d, d2, d3, d4, d5, bl, bl2, affineTransform);
    }

    @NotNull
    public final Path2d arc(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise, boolean connect, @NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        Pair pair2 = Path2d.Companion.approximateEllipseWithBezierCurve(x2, y2, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
        boolean bl = false;
        DoubleVector moveTo = (DoubleVector)pair2.component1();
        List controlPoints = (List)pair2.component2();
        Pair pair3 = TuplesKt.to((Object)at.transform(moveTo), at.transform(controlPoints));
        DoubleVector moveTo2 = (DoubleVector)pair3.component1();
        List controlPoints2 = (List)pair3.component2();
        if (this.commands.isEmpty()) {
            Path2d.moveTo$default(this, moveTo2.getX(), moveTo2.getY(), null, 4, null);
        } else if (connect) {
            Path2d.lineTo$default(this, moveTo2.getX(), moveTo2.getY(), null, 4, null);
        }
        ((Collection)this.commands).add(new CubicCurveTo(controlPoints2));
        return this;
    }

    public static /* synthetic */ Path2d arc$default(Path2d path2d, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, AffineTransform affineTransform, int n, Object object) {
        if ((n & 0x100) != 0) {
            bl2 = true;
        }
        if ((n & 0x200) != 0) {
            affineTransform = AffineTransform.Companion.getIDENTITY();
        }
        return path2d.arc(d, d2, d3, d4, d5, d6, d7, bl, bl2, affineTransform);
    }

    @NotNull
    public final Path2d arc(@NotNull Number x1, @NotNull Number y1, @NotNull Number x2, @NotNull Number y2, @NotNull Number rxIn, @NotNull Number ryIn, @NotNull Number angle, boolean largeArcFlag, boolean sweepFlag, boolean connect, @NotNull AffineTransform at) {
        double y1p;
        Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
        Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x2");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y2");
        Intrinsics.checkNotNullParameter((Object)rxIn, (String)"rxIn");
        Intrinsics.checkNotNullParameter((Object)ryIn, (String)"ryIn");
        Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        if (Intrinsics.areEqual((Object)rxIn, (Object)0.0) || Intrinsics.areEqual((Object)ryIn, (Object)0.0)) {
            this.lineTo(x2.doubleValue(), y2.doubleValue(), at);
            return this;
        }
        double startX = x1.doubleValue();
        double startY = y1.doubleValue();
        double endX = x2.doubleValue();
        double endY = y2.doubleValue();
        double angleRad = MathKt.toRadians(angle.doubleValue());
        double rx = Math.abs(rxIn.doubleValue());
        double ry = Math.abs(ryIn.doubleValue());
        double dx2 = (startX - endX) / 2.0;
        double dy2 = (startY - endY) / 2.0;
        double x1p = Math.cos(angleRad) * dx2 + Math.sin(angleRad) * dy2;
        double lambda = x1p * x1p / (rx * rx) + (y1p = -Math.sin(angleRad) * dx2 + Math.cos(angleRad) * dy2) * y1p / (ry * ry);
        if (lambda > 1.0) {
            double sqrtLambda = Math.sqrt(lambda);
            rx *= sqrtLambda;
            ry *= sqrtLambda;
        }
        double rxSq = rx * rx;
        double rySq = ry * ry;
        double x1pSq = x1p * x1p;
        double y1pSq = y1p * y1p;
        double denom = rxSq * y1pSq + rySq * x1pSq;
        double num = rxSq * rySq - rxSq * y1pSq - rySq * x1pSq;
        double factor = Math.sqrt(Math.max(0.0, num / denom)) * (double)(largeArcFlag == sweepFlag ? -1 : 1);
        double cxp = factor * (rx * y1p / ry);
        double cyp = factor * (-ry * x1p / rx);
        double cx = Math.cos(angleRad) * cxp - Math.sin(angleRad) * cyp + (startX + endX) / 2.0;
        double cy = Math.sin(angleRad) * cxp + Math.cos(angleRad) * cyp + (startY + endY) / 2.0;
        double v1x = (x1p - cxp) / rx;
        double v1y = (y1p - cyp) / ry;
        double v2x = (-x1p - cxp) / rx;
        double v2y = (-y1p - cyp) / ry;
        double theta1 = Math.atan2(v1y, v1x);
        double deltaTheta = Math.atan2(v2y, v2x) - theta1;
        if (sweepFlag) {
            if (deltaTheta < 0.0) {
                deltaTheta += Math.PI * 2;
            }
        } else if (deltaTheta > 0.0) {
            deltaTheta -= Math.PI * 2;
        }
        double startAngle = theta1;
        double endAngle = theta1 + deltaTheta;
        boolean anticlockwise = !sweepFlag;
        this.arc(cx, cy, rx, ry, angleRad, startAngle, endAngle, anticlockwise, connect, at);
        return this;
    }

    public static /* synthetic */ Path2d arc$default(Path2d path2d, Number number, Number number2, Number number3, Number number4, Number number5, Number number6, Number number7, boolean bl, boolean bl2, boolean bl3, AffineTransform affineTransform, int n, Object object) {
        if ((n & 0x200) != 0) {
            bl3 = true;
        }
        if ((n & 0x400) != 0) {
            affineTransform = AffineTransform.Companion.getIDENTITY();
        }
        return path2d.arc(number, number2, number3, number4, number5, number6, number7, bl, bl2, bl3, affineTransform);
    }

    @NotNull
    public final Path2d bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2, @NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        Collection collection = this.commands;
        Object[] objectArray = new DoubleVector[]{new DoubleVector(cp1x, cp1y), new DoubleVector(cp2x, cp2y), new DoubleVector(x2, y2)};
        collection.add(new CubicCurveTo(at.transform(CollectionsKt.listOf((Object[])objectArray))));
        return this;
    }

    public static /* synthetic */ Path2d bezierCurveTo$default(Path2d path2d, double d, double d2, double d3, double d4, double d5, double d6, AffineTransform affineTransform, int n, Object object) {
        if ((n & 0x40) != 0) {
            affineTransform = AffineTransform.Companion.getIDENTITY();
        }
        return path2d.bezierCurveTo(d, d2, d3, d4, d5, d6, affineTransform);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.commands, (CharSequence)" ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d$ClosePath;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$PathCommand;", "()V", "toString", "", "transform", "at", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "canvas"})
    public static final class ClosePath
    extends PathCommand {
        @NotNull
        public static final ClosePath INSTANCE = new ClosePath();

        private ClosePath() {
            super(null);
        }

        @Override
        @NotNull
        public PathCommand transform(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            return this;
        }

        @NotNull
        public String toString() {
            return "Z";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JZ\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JR\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d$Companion;", "", "()V", "approximateEllipseWithBezierCurve", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "", "x", "", "y", "radiusX", "radiusY", "rotation", "startAngle", "endAngle", "anticlockwise", "", "approximateEllipticalArcWithBezier", "cx", "cy", "rx", "ry", "arcStartAngle", "sweepAngle", "normalizeAnglesAndSweep", "transformEllipsePoint", "px", "py", "canvas"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<DoubleVector, List<DoubleVector>> approximateEllipseWithBezierCurve(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
            if (radiusX < 0.0 || radiusY < 0.0) {
                return TuplesKt.to((Object)new DoubleVector(x2, y2), (Object)CollectionsKt.emptyList());
            }
            double sweepAngle = this.normalizeAnglesAndSweep(startAngle, endAngle, anticlockwise);
            Pair<DoubleVector, List<DoubleVector>> segments = this.approximateEllipticalArcWithBezier(x2, y2, radiusX, radiusY, rotation, startAngle, sweepAngle);
            return segments;
        }

        private final double normalizeAnglesAndSweep(double startAngle, double endAngle, boolean anticlockwise) {
            double twoPi = Math.PI * 2;
            double normStart = (startAngle % twoPi + twoPi) % twoPi;
            double normEnd = (endAngle % twoPi + twoPi) % twoPi;
            double sweepMagnitude = !anticlockwise ? (normEnd >= normStart ? normEnd - normStart : twoPi - normStart + normEnd) : (normStart >= normEnd ? normStart - normEnd : twoPi - normEnd + normStart);
            double angleDiff = endAngle - startAngle;
            double wraps = Math.abs(angleDiff) / twoPi;
            if (wraps >= 1.0) {
                double shortestSweepClockwise = normEnd >= normStart ? normEnd - normStart : twoPi - normStart + normEnd;
                double wrapsClockwise = Math.floor(angleDiff / twoPi);
                double wrapsAntiClockwise = Math.floor(-angleDiff / twoPi);
                if (!anticlockwise && angleDiff > 1.0E-9) {
                    sweepMagnitude = shortestSweepClockwise + wrapsClockwise * twoPi;
                } else if (anticlockwise && angleDiff < -1.0E-9) {
                    sweepMagnitude = twoPi - shortestSweepClockwise + wrapsAntiClockwise * twoPi;
                }
            }
            if (Math.abs(sweepMagnitude) < 1.0E-9 && Math.abs(angleDiff) > 1.0E-9) {
                sweepMagnitude = twoPi;
            }
            return anticlockwise ? -sweepMagnitude : sweepMagnitude;
        }

        private final Pair<DoubleVector, List<DoubleVector>> approximateEllipticalArcWithBezier(double cx, double cy, double rx, double ry, double rotation, double arcStartAngle, double sweepAngle) {
            if (rx <= 0.0 || ry <= 0.0 || Math.abs(sweepAngle) < 1.0E-9) {
                double cosA = Math.cos(arcStartAngle);
                double sinA = Math.sin(arcStartAngle);
                double p0xLocal = rx * cosA;
                double p0yLocal = ry * sinA;
                DoubleVector p0e = this.transformEllipsePoint(p0xLocal, p0yLocal, cx, cy, rotation);
                return TuplesKt.to((Object)p0e, (Object)CollectionsKt.emptyList());
            }
            double maxAnglePerSegment = 1.5707963267948966;
            int numSegments = RangesKt.coerceAtLeast((int)((int)Math.ceil(Math.abs(sweepAngle) / maxAnglePerSegment)), (int)1);
            double deltaAngle = sweepAngle / (double)numSegments;
            double dir = Math.signum(deltaAngle);
            double kappa = 1.3333333333333333 * Math.tan(Math.abs(deltaAngle) / 4.0);
            double currentAngle = 0.0;
            currentAngle = arcStartAngle;
            DoubleVector moveTo = null;
            List controlPoints = new ArrayList();
            for (int i = 0; i < numSegments; ++i) {
                int it = i;
                boolean bl = false;
                double angle1 = currentAngle;
                double angle2 = currentAngle + deltaAngle;
                double cosA1 = Math.cos(angle1);
                double sinA1 = Math.sin(angle1);
                double cosA2 = Math.cos(angle2);
                double sinA2 = Math.sin(angle2);
                double p0xLocal = rx * cosA1;
                double p0yLocal = ry * sinA1;
                double p3xLocal = rx * cosA2;
                double p3yLocal = ry * sinA2;
                double tx1 = -rx * sinA1;
                double ty1 = ry * cosA1;
                double tx2 = -rx * sinA2;
                double ty2 = ry * cosA2;
                double p1xLocal = p0xLocal + dir * kappa * tx1;
                double p1yLocal = p0yLocal + dir * kappa * ty1;
                double p2xLocal = p3xLocal - dir * kappa * tx2;
                double p2yLocal = p3yLocal - dir * kappa * ty2;
                if (moveTo == null) {
                    moveTo = Companion.transformEllipsePoint(p0xLocal, p0yLocal, cx, cy, rotation);
                }
                ((Collection)controlPoints).add(Companion.transformEllipsePoint(p1xLocal, p1yLocal, cx, cy, rotation));
                ((Collection)controlPoints).add(Companion.transformEllipsePoint(p2xLocal, p2yLocal, cx, cy, rotation));
                ((Collection)controlPoints).add(Companion.transformEllipsePoint(p3xLocal, p3yLocal, cx, cy, rotation));
                currentAngle = angle2;
            }
            DoubleVector doubleVector = moveTo;
            Intrinsics.checkNotNull(doubleVector);
            return TuplesKt.to(doubleVector, (Object)controlPoints);
        }

        private final DoubleVector transformEllipsePoint(double px, double py, double cx, double cy, double rotation) {
            double cosRot = Math.cos(rotation);
            double sinRot = Math.sin(rotation);
            double pxRotated = px * cosRot - py * sinRot;
            double pyRotated = px * sinRot + py * cosRot;
            return new DoubleVector(pxRotated + cx, pyRotated + cy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d$CubicCurveTo;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$PathCommand;", "controlPoints", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Ljava/util/List;)V", "getControlPoints", "()Ljava/util/List;", "toString", "", "transform", "at", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "canvas"})
    public static final class CubicCurveTo
    extends PathCommand {
        @NotNull
        private final List<DoubleVector> controlPoints;

        public CubicCurveTo(@NotNull List<DoubleVector> controlPoints) {
            Intrinsics.checkNotNullParameter(controlPoints, (String)"controlPoints");
            super(null);
            this.controlPoints = controlPoints;
        }

        @NotNull
        public final List<DoubleVector> getControlPoints() {
            return this.controlPoints;
        }

        @Override
        @NotNull
        public PathCommand transform(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            return new CubicCurveTo(at.transform(this.controlPoints));
        }

        @NotNull
        public String toString() {
            String controlPointsStr2 = CollectionsKt.joinToString$default((Iterable)this.controlPoints, (CharSequence)" ", null, null, (int)0, null, (Function1)toString.controlPointsStr.1.INSTANCE, (int)30, null);
            return "C " + controlPointsStr2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d$LineTo;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$PathCommand;", "x", "", "y", "(DD)V", "getX", "()D", "getY", "toString", "", "transform", "at", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "canvas"})
    public static final class LineTo
    extends PathCommand {
        private final double x;
        private final double y;

        public LineTo(double x2, double y2) {
            super(null);
            this.x = x2;
            this.y = y2;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        @Override
        @NotNull
        public PathCommand transform(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            DoubleVector doubleVector = at.transform(this.x, this.y);
            double tx = doubleVector.component1();
            double ty = doubleVector.component2();
            return new LineTo(tx, ty);
        }

        @NotNull
        public String toString() {
            return "L " + this.x + ' ' + this.y;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d$MoveTo;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$PathCommand;", "x", "", "y", "(DD)V", "getX", "()D", "getY", "toString", "", "transform", "at", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "canvas"})
    public static final class MoveTo
    extends PathCommand {
        private final double x;
        private final double y;

        public MoveTo(double x2, double y2) {
            super(null);
            this.x = x2;
            this.y = y2;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        @Override
        @NotNull
        public PathCommand transform(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            DoubleVector doubleVector = at.transform(this.x, this.y);
            double tx = doubleVector.component1();
            double ty = doubleVector.component2();
            return new MoveTo(tx, ty);
        }

        @NotNull
        public String toString() {
            return "M " + this.x + ' ' + this.y;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Path2d$PathCommand;", "", "()V", "transform", "at", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$ClosePath;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$CubicCurveTo;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$LineTo;", "Lorg/jetbrains/letsPlot/core/canvas/Path2d$MoveTo;", "canvas"})
    public static abstract class PathCommand {
        private PathCommand() {
        }

        @NotNull
        public abstract PathCommand transform(@NotNull AffineTransform var1);

        public /* synthetic */ PathCommand(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

