/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.LineRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.VLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLineRangeGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1#2:94\n1855#3,2:95\n*S KotlinDebug\n*F\n+ 1 LineRangeGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom\n*L\n59#1:95,2\n*E\n"})
public final class LineRangeGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;
    public static final double MIN_TOOLTIP_RECTANGLE_WIDTH = 2.0;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return VLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper helper2 = geomHelper.createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.LINE_RANGE, ctx2);
        Aes[] aesArray = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
        RectangleTooltipHelper tooltipHelper2 = new RectangleTooltipHelper(pos, coord, ctx2, CollectionsKt.listOf((Object[])aesArray), null, buildIntern.tooltipHelper.1.INSTANCE, colorsByDataPoint, 16, null);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Pair pair2;
            DoubleVector end;
            DoubleVector start2;
            if (GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getYMIN()) == null || GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getYMAX()) == null) continue;
            if (GeomHelper.SvgElementHelper.createLine$default(helper2, start2, end, p, null, 8, null) == null) continue;
            boolean bl = false;
            SvgNode svgElement = (SvgNode)pair2.component1();
            root.add(svgElement);
        }
        Iterable<DataPointAesthetics> $this$forEach$iv = aesthetics2.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            DoubleRectangle clientRect;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator2.next();
            boolean bl = false;
            if ((DoubleRectangle)this.clientRectByDataPoint(geomHelper).invoke((Object)p) == null) continue;
            boolean bl2 = false;
            SvgRectElement svgRect = new SvgRectElement(clientRect);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgRect, p, false, null, false, 28, null);
            tooltipHelper2.addTarget(p, clientRect);
        }
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(geomHelper){
            final /* synthetic */ GeomHelper $geomHelper;
            {
                this.$geomHelper = $geomHelper;
                super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LineRangeGeom.access$clientRectByDataPoint$factory(this.$geomHelper, p0);
            }
        };
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(GeomHelper $geomHelper, DataPointAesthetics p) {
        Double d = p.finiteOrNull(Aes.Companion.getX());
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(Aes.Companion.getYMIN());
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(Aes.Companion.getYMAX());
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        double height = ymax - ymin;
        DoubleRectangle it = new DoubleRectangle(new DoubleVector(x2, ymax - height / 2.0), DoubleVector.Companion.getZERO());
        boolean bl = false;
        DoubleRectangle doubleRectangle = $geomHelper.toClient(it, p);
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle rect2 = doubleRectangle;
        double width2 = Math.max(AesScaling.INSTANCE.strokeWidth(p), 2.0);
        return GeomUtil.INSTANCE.extendWidth$plot_base(rect2, width2, $geomHelper.getCtx$plot_base().getFlipped());
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(GeomHelper $geomHelper, DataPointAesthetics p) {
        return LineRangeGeom.clientRectByDataPoint$factory($geomHelper, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LineRangeGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "MIN_TOOLTIP_RECTANGLE_WIDTH", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

