/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShapeSvg;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PointLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "fatten", "", "(D)V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minimumKeySize", "plot-base"})
public final class PointLegendKeyElementFactory
implements LegendKeyElementFactory {
    private final double fatten;

    public PointLegendKeyElementFactory(double fatten) {
        this.fatten = fatten;
    }

    public /* synthetic */ PointLegendKeyElementFactory(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        this(d);
    }

    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        DoubleVector location2 = new DoubleVector(size2.getX() / (double)2, size2.getY() / (double)2);
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        PointShape shape = pointShape;
        SvgSlimObject slimObject = PointShapeSvg.INSTANCE.create(shape, location2, p, this.fatten, true);
        return GeomBase.Companion.wrap(slimObject);
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        PointShape shape = pointShape;
        double shapeSize = shape.size(p, this.fatten);
        double strokeWidth = shape.strokeWidth(p);
        double size2 = shapeSize + strokeWidth + 2.0;
        return new DoubleVector(size2, size2);
    }

    public PointLegendKeyElementFactory() {
        this(0.0, 1, null);
    }
}

