/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.QuantilesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShapeSvg;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseYDensityStat;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimGroup;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J0\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J5\u0010(\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u00010-0)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SinaGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "quantiles", "", "", "getQuantiles", "()Ljava/util/List;", "setQuantiles", "(Ljava/util/List;)V", "seed", "", "getSeed", "()Ljava/lang/Long;", "setSeed", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "showHalf", "getShowHalf", "()D", "setShowHalf", "(D)V", "buildGroup", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "rand", "Lkotlin/random/Random;", "buildIntern", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "toJitterTransform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "p", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nSinaGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinaGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/SinaGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n1#2:110\n1477#3:111\n1502#3,3:112\n1505#3,3:122\n1855#3,2:129\n1855#3,2:131\n372#4,7:115\n125#5:125\n152#5,3:126\n*S KotlinDebug\n*F\n+ 1 SinaGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/SinaGeom\n*L\n44#1:111\n44#1:112,3\n44#1:122,3\n46#1:129,2\n63#1:131,2\n44#1:115,7\n45#1:125\n45#1:126,3\n*E\n"})
public final class SinaGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Long seed;
    @NotNull
    private List<Double> quantiles = BaseYDensityStat.Companion.getDEF_QUANTILES();
    private double showHalf;
    public static final boolean HANDLES_GROUPS = true;
    public static final double DEF_SHOW_HALF = 0.0;

    @Nullable
    public final Long getSeed() {
        return this.seed;
    }

    public final void setSeed(@Nullable Long l) {
        this.seed = l;
    }

    @NotNull
    public final List<Double> getQuantiles() {
        return this.quantiles;
    }

    public final void setQuantiles(@NotNull List<Double> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.quantiles = list2;
    }

    public final double getShowHalf() {
        return this.showHalf;
    }

    public final void setShowHalf(double d) {
        this.showHalf = d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable<DataPointAesthetics> dataPoints2;
        Long l;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                l = this.seed;
                if (l == null) break block8;
                long it = ((Number)l).longValue();
                boolean bl = false;
                Long l2 = this.seed;
                Intrinsics.checkNotNull((Object)l2);
                Random random = RandomKt.Random((long)l2);
                l = random;
                if (random != null) break block9;
            }
            l = (Random)Random.Default;
        }
        Long rand = l;
        Iterable<DataPointAesthetics> iterable = dataPoints2 = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY());
        boolean $i$f$groupBy = false;
        void it = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p0 = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double key$iv$iv = p0.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            Double x2 = (Double)entry.getKey();
            List nonOrderedPoints = (List)entry.getValue();
            object.add(TuplesKt.to((Object)x2, GeomUtil.INSTANCE.ordered_Y(nonOrderedPoints, false)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair2 = (Pair)element$iv;
            boolean bl = false;
            Iterable dataPoints3 = (Iterable)pair2.component2();
            this.buildGroup(root, dataPoints3, pos, coord, ctx2, (Random)rand);
        }
    }

    private final void buildGroup(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2, Random rand) {
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        QuantilesHelper quantilesHelper = new QuantilesHelper(pos, coord, ctx2, this.quantiles, Aes.Companion.getX());
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.POINT, ctx2);
        Function1<DataPointAesthetics, DoubleVector> jitterTransform = this.toJitterTransform(ctx2, rand);
        Iterable $this$forEach$iv = quantilesHelper.splitByQuantiles$plot_base(dataPoints2, Aes.Companion.getY());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List points2 = (List)element$iv;
            boolean bl = false;
            SvgSlimGroup slimGroup = SvgSlimElements.INSTANCE.g(points2.size());
            for (DataPointAesthetics p : points2) {
                PointShape shape;
                DoubleVector location2;
                DoubleVector point2;
                Double d = p.size();
                if (d == null) continue;
                d.doubleValue();
                if (p.shape() == null || (DoubleVector)jitterTransform.invoke((Object)p) == null || helper2.toClient(point2, p) == null) continue;
                GeomTargetCollector.DefaultImpls.addPoint$default(targetCollector, p.index(), location2, (PointShape.DefaultImpls.size$default(shape, p, 0.0, 2, null) + shape.strokeWidth(p)) / (double)2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)p), 7, null), null, 16, null);
                SvgSlimObject o = PointShapeSvg.create$default(PointShapeSvg.INSTANCE, shape, location2, p, 0.0, false, 24, null);
                o.appendTo(slimGroup);
            }
            root.add(GeomBase.Companion.wrap(slimGroup));
        }
    }

    private final Function1<DataPointAesthetics, DoubleVector> toJitterTransform(GeomContext ctx2, Random rand) {
        double resolutionX = ctx2.getResolution(Aes.Companion.getX());
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, rand, resolutionX){
            final /* synthetic */ SinaGeom this$0;
            final /* synthetic */ Random $rand;
            final /* synthetic */ double $resolutionX;
            {
                this.this$0 = $receiver;
                this.$rand = $rand;
                this.$resolutionX = $resolutionX;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Pair<Double, Double> pair2 = p.finiteOrNull(Aes.Companion.getX(), Aes.Companion.getY());
                if (pair2 == null) {
                    return null;
                }
                Pair<Double, Double> pair3 = pair2;
                double x2 = ((Number)pair3.component1()).doubleValue();
                double y2 = ((Number)pair3.component2()).doubleValue();
                Pair<Double, Double> pair4 = p.finiteOrNull(Aes.Companion.getWIDTH(), Aes.Companion.getVIOLINWIDTH());
                if (pair4 == null) {
                    return null;
                }
                Pair<Double, Double> pair5 = pair4;
                double width2 = ((Number)pair5.component1()).doubleValue();
                double violinWidth = ((Number)pair5.component2()).doubleValue();
                int signX = this.this$0.getShowHalf() > 0.0 ? 1 : (this.this$0.getShowHalf() < 0.0 ? -1 : (this.$rand.nextBoolean() ? 1 : -1));
                double randomWidthShift = this.$rand.nextDouble();
                double widthLimit = this.$resolutionX / 2.0 * width2 * violinWidth;
                return new DoubleVector(x2 + (double)signX * randomWidthShift * widthLimit, y2);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SinaGeom$Companion;", "", "()V", "DEF_SHOW_HALF", "", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

