/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/BoxLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "whiskers", "", "showMidline", "(ZZ)V", "getShowMidline", "()Z", "getWhiskers", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
final class BoxLegendKeyElementFactory
implements LegendKeyElementFactory {
    private final boolean whiskers;
    private final boolean showMidline;

    public BoxLegendKeyElementFactory(boolean whiskers, boolean showMidline) {
        this.whiskers = whiskers;
        this.showMidline = showMidline;
    }

    public final boolean getWhiskers() {
        return this.whiskers;
    }

    public final boolean getShowMidline() {
        return this.showMidline;
    }

    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        double whiskerSize = 0.2;
        double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
        double width2 = (size2.getX() - strokeWidth) * 0.8;
        double height = size2.getY() - strokeWidth;
        double x2 = (size2.getX() - width2) / (double)2;
        double y2 = strokeWidth / (double)2;
        double boxHeight = height;
        double boxY = y2;
        if (this.whiskers) {
            boxHeight = height * (1.0 - (double)2 * whiskerSize);
            boxY = y2 + height * whiskerSize;
        }
        SvgRectElement rect2 = new SvgRectElement(x2, boxY, width2, boxHeight);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, rect2, p, false, null, false, 28, null);
        double middleY = y2 + height * 0.5;
        SvgLineElement middle = new SvgLineElement(x2, middleY, x2 + width2, middleY);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, middle, p, false, null, false, 28, null);
        SvgGElement g = new SvgGElement();
        g.children().add(rect2);
        if (this.showMidline) {
            g.children().add(middle);
        }
        if (this.whiskers) {
            double middleX = x2 + width2 * 0.5;
            SvgLineElement lowerWhisker = new SvgLineElement(middleX, y2 + height * (1.0 - whiskerSize), middleX, y2 + height);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, lowerWhisker, p, false, null, false, 28, null);
            SvgLineElement upperWhisker = new SvgLineElement(middleX, y2, middleX, y2 + height * whiskerSize);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, upperWhisker, p, false, null, false, 28, null);
            g.children().add(lowerWhisker);
            g.children().add(upperWhisker);
        }
        return g;
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
    }
}

