/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J8\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b\u001fJ\u0016\u0010 \u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J>\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/AxisUtil;", "", "()V", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "breakTransformedValues", "", "", "breakLabels", "", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "dataDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "buildGridLine", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "tick", "coordinateSystem", "horizontal", "minorDomainBreaks", "majorDomainBreaks", "minorDomainBreaks$plot_builder", "tickLabelBaseOffset", "toClient", "breaks", "TickLabelsMap", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1549#2:227\n1620#2,3:228\n1569#2,11:231\n1864#2,2:242\n1866#2:245\n1580#2:246\n766#2:247\n857#2,2:248\n1549#2:250\n1620#2,3:251\n1569#2,11:254\n1864#2,2:265\n1866#2:268\n1580#2:269\n1603#2,9:270\n1855#2:279\n1856#2:281\n1612#2:282\n1603#2,9:283\n1855#2:292\n1856#2:294\n1612#2:295\n1549#2:296\n1620#2,3:297\n1549#2:300\n1620#2,3:301\n1549#2:304\n1620#2,3:305\n1549#2:308\n1620#2,3:309\n1549#2:312\n1620#2,3:313\n1549#2:316\n1620#2,3:317\n1549#2:320\n1620#2,3:321\n1549#2:324\n1620#2,3:325\n1549#2:328\n1620#2,3:329\n1#3:244\n1#3:267\n1#3:280\n1#3:293\n*S KotlinDebug\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil\n*L\n25#1:227\n25#1:228,3\n63#1:231,11\n63#1:242,2\n63#1:245\n63#1:246\n68#1:247\n68#1:248,2\n76#1:250\n76#1:251,3\n79#1:254,11\n79#1:265,2\n79#1:268\n79#1:269\n87#1:270,9\n87#1:279\n87#1:281\n87#1:282\n94#1:283,9\n94#1:292\n94#1:294\n94#1:295\n101#1:296\n101#1:297,3\n102#1:300\n102#1:301,3\n103#1:304\n103#1:305,3\n104#1:308\n104#1:309,3\n105#1:312\n105#1:313,3\n106#1:316\n106#1:317,3\n120#1:320\n120#1:321,3\n125#1:324\n125#1:325,3\n155#1:328\n155#1:329,3\n63#1:244\n79#1:267\n87#1:280\n94#1:293\n*E\n"})
public final class AxisUtil {
    @NotNull
    public static final AxisUtil INSTANCE = new AxisUtil();

    private AxisUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> minorDomainBreaks$plot_builder(@NotNull List<Double> majorDomainBreaks) {
        List list2;
        Intrinsics.checkNotNullParameter(majorDomainBreaks, (String)"majorDomainBreaks");
        if (majorDomainBreaks.size() > 1) {
            void $this$mapTo$iv$iv;
            double step2 = ((Number)majorDomainBreaks.get(1)).doubleValue() - ((Number)majorDomainBreaks.get(0)).doubleValue();
            double start2 = ((Number)majorDomainBreaks.get(0)).doubleValue() - step2 / 2.0;
            Iterable $this$map$iv = (Iterable)new IntRange(0, majorDomainBreaks.size());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(start2 + (double)it * step2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final AxisComponent.BreaksData breaksData(@NotNull ScaleBreaks scaleBreaks, @NotNull CoordinateSystem coord, @NotNull DoubleRectangle dataDomain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisTheme axisTheme, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)dataDomain, (String)"dataDomain");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        return this.breaksData(scaleBreaks.getTransformedValues(), scaleBreaks.getLabels(), coord, dataDomain, flipAxis, orientation, axisTheme, labelAdjustments);
    }

    public static /* synthetic */ AxisComponent.BreaksData breaksData$default(AxisUtil axisUtil, ScaleBreaks scaleBreaks, CoordinateSystem coordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisTheme axisTheme, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, Object object) {
        if ((n & 0x40) != 0) {
            tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, null, 62, null);
        }
        return axisUtil.breaksData(scaleBreaks, coordinateSystem, doubleRectangle, bl, orientation, axisTheme, tickLabelAdjustments);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AxisComponent.BreaksData breaksData(@NotNull List<Double> breakTransformedValues, @NotNull List<String> breakLabels, @NotNull CoordinateSystem coord, @NotNull DoubleRectangle dataDomain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisTheme axisTheme, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$mapTo$iv$iv4;
        void $this$mapTo$iv$iv5;
        void $this$mapTo$iv$iv6;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Pair it$iv$iv;
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv;
        void $this$mapTo$iv$iv7;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapIndexedNotNullTo$iv$iv2;
        Iterable $this$mapIndexedNotNull$iv2;
        Intrinsics.checkNotNullParameter(breakTransformedValues, (String)"breakTransformedValues");
        Intrinsics.checkNotNullParameter(breakLabels, (String)"breakLabels");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)dataDomain, (String)"dataDomain");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        DoubleVector tickLabelBaseOffset = this.tickLabelBaseOffset(axisTheme, orientation);
        TickLabelsMap labelsMap = new TickLabelsMap(orientation.isHorizontal(), PlotLabelSpecFactory.INSTANCE.axisTick(axisTheme), labelAdjustments.getRotationDegree());
        DoubleRectangle doubleRectangle = coord.toClient(dataDomain);
        if (doubleRectangle == null) {
            doubleRectangle = DoubleRectangle.Companion.LTRB(-1000000, -1000000, 1000000, 1000000);
        }
        DoubleRectangle gridRect = doubleRectangle;
        Iterable iterable = this.toClient(breakTransformedValues, dataDomain, coord, flipAxis, orientation.isHorizontal());
        boolean $i$f$mapIndexedNotNull = false;
        void var15_15 = $this$mapIndexedNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        Iterator $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv2;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv2 = 0;
        Iterator iterator2 = $this$forEachIndexed$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IndexedValue it$iv$iv2;
            void clientTick;
            void element$iv$iv;
            int n;
            Object item$iv$iv$iv = iterator2.next();
            if ((n = index$iv$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            DoubleVector doubleVector = (DoubleVector)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            if ((clientTick == null || !gridRect.contains((DoubleVector)clientTick) ? null : new IndexedValue(i, (Object)new Triple((Object)breakLabels.get(i), (Object)breakTransformedValues.get(i), (Object)clientTick))) == null) continue;
            it$iv$iv2 = it$iv$iv2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv2);
        }
        $this$mapIndexedNotNull$iv2 = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$mapIndexedNotNullTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexedValue index$iv$iv$iv2 = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int i = index$iv$iv$iv2.component1();
            Triple br = (Triple)index$iv$iv$iv2.component2();
            String label2 = (String)br.component1();
            DoubleVector clientBreak = (DoubleVector)br.component3();
            DoubleVector labelOffset = tickLabelBaseOffset.add(labelAdjustments.additionalOffset(i));
            List<DoubleRectangle> list2 = labelAdjustments.getBounds();
            DoubleRectangle bounds = list2 != null ? (DoubleRectangle)CollectionsKt.getOrNull(list2, (int)i) : null;
            double loc = orientation.isHorizontal() ? clientBreak.getX() : clientBreak.getY();
            if (!labelsMap.haveSpace(loc, label2, labelOffset, bounds)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List majorBreaks = (List)destination$iv$iv;
        Iterable $i$f$filter22 = majorBreaks;
        Object object = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv7) {
            void it;
            IndexedValue bl = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(((Number)((Triple)it.getValue()).getSecond()).doubleValue());
        }
        List<Double> minorDomainBreaks = ((AxisUtil)object).minorDomainBreaks$plot_builder((List)destination$iv$iv2);
        boolean bl = false;
        destination$iv$iv2 = INSTANCE.toClient(minorDomainBreaks, dataDomain, coord, flipAxis, orientation.isHorizontal());
        boolean $i$f$mapIndexedNotNull2 = false;
        Iterator element$iv$iv = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo2 = false;
        Iterator $this$forEachIndexed$iv$iv$iv2 = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv$iv$iv3 = 0;
        Iterator clientBreak = $this$forEachIndexed$iv$iv$iv2.iterator();
        while (clientBreak.hasNext()) {
            void clientBreak2;
            void element$iv$iv2;
            int bounds;
            Object item$iv$iv$iv = clientBreak.next();
            if ((bounds = index$iv$iv$iv3++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object loc = item$iv$iv$iv;
            int index$iv$iv = bounds;
            boolean bl5 = false;
            DoubleVector bl3 = (DoubleVector)element$iv$iv2;
            int i = index$iv$iv;
            boolean bl6 = false;
            void v2 = clientBreak2;
            if (((v2 == null ? true : !gridRect.contains((DoubleVector)v2)) ? null : new Pair((Object)minorDomainBreaks.get(i), (Object)clientBreak2)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean $i$a$-let-CollectionsKt___CollectionsKt$mapIndexedNotNullTo$1$1$iv$iv2 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List minorBreaks = (List)destination$iv$iv3;
        Iterable $this$mapNotNull$iv = majorBreaks;
        boolean $i$f$mapNotNull = false;
        $this$mapIndexedNotNull$iv = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        $this$forEachIndexed$iv$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while ($this$forEachIndexed$iv$iv$iv2.hasNext()) {
            List<DoubleVector> clientLine;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = $this$forEachIndexed$iv$iv$iv2.next();
            boolean bl7 = false;
            IndexedValue item$iv$iv$iv = (IndexedValue)element$iv$iv3;
            boolean bl8 = false;
            Triple br = (Triple)item$iv$iv$iv.component2();
            String label3 = (String)br.component1();
            double domainTick = ((Number)br.component2()).doubleValue();
            DoubleVector clientTick = (DoubleVector)br.component3();
            if ((INSTANCE.buildGridLine(domainTick, dataDomain, coord, flipAxis, orientation.isHorizontal()) == null ? null : new Triple((Object)label3, (Object)clientTick, clientLine)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl9 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List majorBreaksData = (List)destination$iv$iv4;
        Iterable $this$mapNotNull$iv2 = minorBreaks;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv4 = $this$mapNotNull$iv2;
        Iterable<Pair> destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator element$iv$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv.hasNext()) {
            Pair it$iv$iv3;
            List<DoubleVector> clientLine;
            Object element$iv$iv$iv2;
            Object element$iv$iv4 = element$iv$iv$iv2 = element$iv$iv$iv.next();
            boolean bl10 = false;
            Pair bl8 = (Pair)element$iv$iv4;
            boolean bl11 = false;
            double domainTick = ((Number)bl8.component1()).doubleValue();
            DoubleVector clientTick = (DoubleVector)bl8.component2();
            if ((INSTANCE.buildGridLine(domainTick, dataDomain, coord, flipAxis, orientation.isHorizontal()) == null ? null : new Pair((Object)clientTick, clientLine)) == null) continue;
            it$iv$iv3 = it$iv$iv3;
            boolean bl12 = false;
            destination$iv$iv5.add(it$iv$iv3);
        }
        List minorBreaksData = (List)destination$iv$iv5;
        Iterable $this$map$iv2 = majorBreaksData;
        boolean $i$f$map2 = false;
        destination$iv$iv5 = $this$map$iv2;
        Iterable destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv6) {
            Triple element$iv$iv$iv2 = (Triple)item$iv$iv;
            object = destination$iv$iv22;
            boolean bl13 = false;
            DoubleVector tick = (DoubleVector)element$iv$iv$iv2.component2();
            object.add(tick);
        }
        List list3 = (List)destination$iv$iv22;
        Iterable $this$map$iv3 = majorBreaks;
        boolean $i$f$map3 = false;
        destination$iv$iv22 = $this$map$iv3;
        Iterable destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            void it;
            IndexedValue bl13 = (IndexedValue)item$iv$iv;
            object = destination$iv$iv6;
            boolean bl14 = false;
            object.add(it.getIndex());
        }
        List list4 = (List)destination$iv$iv6;
        Iterable $this$map$iv4 = majorBreaksData;
        boolean $i$f$map4 = false;
        destination$iv$iv6 = $this$map$iv4;
        Iterable destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Triple bl14 = (Triple)item$iv$iv;
            object = destination$iv$iv7;
            boolean bl15 = false;
            List gridLine = (List)bl14.component3();
            object.add(gridLine);
        }
        List list5 = (List)destination$iv$iv7;
        Iterable $this$map$iv5 = majorBreaksData;
        boolean $i$f$map5 = false;
        destination$iv$iv7 = $this$map$iv5;
        Iterable destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Triple bl15 = (Triple)item$iv$iv;
            object = destination$iv$iv8;
            boolean bl16 = false;
            String label4 = (String)bl15.component1();
            object.add(label4);
        }
        List list6 = (List)destination$iv$iv8;
        Iterable $this$map$iv6 = minorBreaksData;
        boolean $i$f$map6 = false;
        destination$iv$iv8 = $this$map$iv6;
        Iterable destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
        boolean $i$f$mapTo6 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Pair bl16 = (Pair)item$iv$iv;
            object = destination$iv$iv9;
            boolean bl17 = false;
            DoubleVector tick = (DoubleVector)bl16.component1();
            object.add(tick);
        }
        List list7 = (List)destination$iv$iv9;
        Iterable $this$map$iv7 = minorBreaksData;
        boolean $i$f$map7 = false;
        destination$iv$iv9 = $this$map$iv7;
        Collection destination$iv$iv10 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
        boolean $i$f$mapTo7 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair2 = (Pair)item$iv$iv;
            object = destination$iv$iv10;
            boolean bl18 = false;
            List gridLine = (List)pair2.component2();
            object.add(gridLine);
        }
        List list8 = (List)destination$iv$iv10;
        return new AxisComponent.BreaksData(list3, list4, list6, list7, list5, list8);
    }

    public static /* synthetic */ AxisComponent.BreaksData breaksData$default(AxisUtil axisUtil, List list2, List list3, CoordinateSystem coordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisTheme axisTheme, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, Object object) {
        if ((n & 0x80) != 0) {
            tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, null, 62, null);
        }
        return axisUtil.breaksData(list2, list3, coordinateSystem, doubleRectangle, bl, orientation, axisTheme, tickLabelAdjustments);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DoubleVector> toClient(List<Double> breaks, DoubleRectangle dataDomain, CoordinateSystem coordinateSystem, boolean flipAxis, boolean horizontal) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        DoubleRectangle hvDomain = dataDomain.flipIf(flipAxis);
        Iterable $this$map$iv = breaks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void breakValue;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(horizontal ? new DoubleVector((double)breakValue, hvDomain.yRange().getUpperEnd()) : new DoubleVector(hvDomain.xRange().getLowerEnd(), (double)breakValue));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector breakValue = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DoubleVector pointInDataDomain = it.flipIf(flipAxis);
            DoubleVector doubleVector = SeriesUtil.INSTANCE.finiteOrNull(coordinateSystem.toClient(pointInDataDomain));
            if (doubleVector == null) {
                doubleVector = null;
            }
            collection.add(doubleVector);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DoubleVector> buildGridLine(double tick, DoubleRectangle dataDomain, CoordinateSystem coordinateSystem, boolean flipAxis, boolean horizontal) {
        void $this$mapTo$iv$iv;
        List list2;
        Object[] objectArray;
        DoubleRectangle hvDomain = dataDomain.flipIf(flipAxis);
        if (horizontal) {
            objectArray = new DoubleVector[]{new DoubleVector(tick, hvDomain.yRange().getLowerEnd()), new DoubleVector(tick, hvDomain.yRange().getUpperEnd())};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new DoubleVector[]{new DoubleVector(hvDomain.xRange().getLowerEnd(), tick), new DoubleVector(hvDomain.xRange().getUpperEnd(), tick)};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        List domainLine = list2;
        Iterable $this$map$iv = domainLine;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector doubleVector = (DoubleVector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DoubleVector pointInDataDomain = it.flipIf(flipAxis);
            collection.add(SeriesUtil.INSTANCE.finiteOrNull(coordinateSystem.toClient(pointInDataDomain)));
        }
        List clientLine = (List)destination$iv$iv;
        return clientLine.contains(null) ? null : CollectionsKt.requireNoNulls((List)clientLine);
    }

    @NotNull
    public final DoubleVector tickLabelBaseOffset(@NotNull AxisTheme axisTheme, @NotNull Orientation orientation) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        double distance = axisTheme.tickLabelDistance(orientation.isHorizontal());
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(axisTheme.tickLabelMargins().getLeft() - distance, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(distance - axisTheme.tickLabelMargins().getRight(), 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, axisTheme.tickLabelMargins().getTop() - distance);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, distance - axisTheme.tickLabelMargins().getBottom());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/AxisUtil$TickLabelsMap;", "", "horizontalAxis", "", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "rotationDegree", "", "(ZLorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;D)V", "filledAreas", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lkotlin/collections/ArrayList;", "haveSpace", "loc", "label", "", "labelOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "bounds", "isHorizontal", "isRelevant", "isVertical", "labelRect", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil$TickLabelsMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1747#2,3:227\n*S KotlinDebug\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil$TickLabelsMap\n*L\n190#1:227,3\n*E\n"})
    public static final class TickLabelsMap {
        private final boolean horizontalAxis;
        @NotNull
        private final LabelSpec labelSpec;
        private final double rotationDegree;
        @NotNull
        private final ArrayList<DoubleRectangle> filledAreas;

        public TickLabelsMap(boolean horizontalAxis, @NotNull LabelSpec labelSpec, double rotationDegree) {
            Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
            this.horizontalAxis = horizontalAxis;
            this.labelSpec = labelSpec;
            this.rotationDegree = rotationDegree;
            this.filledAreas = new ArrayList();
        }

        public final boolean haveSpace(double loc, @NotNull String label2, @NotNull DoubleVector labelOffset, @Nullable DoubleRectangle bounds) {
            boolean bl;
            DoubleRectangle rect2;
            block6: {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                Intrinsics.checkNotNullParameter((Object)labelOffset, (String)"labelOffset");
                if (!this.isRelevant(this.rotationDegree)) {
                    return true;
                }
                DoubleRectangle doubleRectangle = bounds;
                if (doubleRectangle == null) {
                    doubleRectangle = this.labelRect(loc, label2, this.rotationDegree, labelOffset);
                }
                rect2 = doubleRectangle;
                Iterable $this$any$iv = this.filledAreas;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DoubleRectangle it = (DoubleRectangle)element$iv;
                        boolean bl2 = false;
                        if (!it.intersects(rect2)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            this.filledAreas.add(rect2);
            return true;
        }

        private final boolean isRelevant(double rotationDegree) {
            return this.isVertical(rotationDegree) || this.isHorizontal(rotationDegree);
        }

        private final boolean isHorizontal(double rotationDegree) {
            return rotationDegree % (double)180 == 0.0;
        }

        private final boolean isVertical(double rotationDegree) {
            return Math.abs(rotationDegree / (double)90) % (double)2 == 1.0;
        }

        private final DoubleRectangle labelRect(double loc, String label2, double rotationDegree, DoubleVector labelOffset) {
            DoubleVector labelNormalSize = this.labelSpec.dimensions(label2);
            DoubleVector wh = labelNormalSize.flipIf(this.isVertical(rotationDegree));
            DoubleVector origin = this.horizontalAxis ? new DoubleVector(loc, 0.0) : new DoubleVector(0.0, loc);
            return new DoubleRectangle(origin, wh).subtract(wh.mul(0.5)).add(labelOffset);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

