/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.event.Button;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandlerExKt;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.NamedLineType;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.TooltipsTheme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTarget;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Defaults;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.VerticalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.CrosshairComponent;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.RetainableComponents;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.TooltipBox;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.LocatedTargetsPicker;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.loc.TransformedTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpec;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpecFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001]BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015JB\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0005082\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u0018\u0010@\u001a\u0002042\u0006\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u000200H\u0002J\b\u0010C\u001a\u000204H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010!2\u0006\u0010E\u001a\u00020\u0007H\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010B\u001a\u000200H\u0002J\b\u0010H\u001a\u000204H\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u000200H\u0002J\u0010\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u0002042\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010P\u001a\u0002042\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010Q\u001a\u0002042\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010R\u001a\u0002042\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010S\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u001e\u0010T\u001a\u0002042\f\u0010U\u001a\b\u0012\u0004\u0012\u00020+082\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010V\u001a\u0002042\u0006\u0010W\u001a\u00020\u0007H\u0002J\u001e\u0010X\u001a\b\u0012\u0004\u0012\u000200082\u0006\u0010Y\u001a\u00020Z2\u0006\u0010;\u001a\u00020\u0007H\u0002J\b\u0010[\u001a\u000204H\u0002J\f\u0010\\\u001a\u00020\u0005*\u00020\u000eH\u0002R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u00020**\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0018\u0010.\u001a\u00020/*\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006^"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "decorationLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "flippedAxis", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "xAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "yAxisTheme", "tooltipsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/TooltipsTheme;", "plotBackground", "Lorg/jetbrains/letsPlot/commons/values/Color;", "styleSheet", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;ZLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/TooltipsTheme;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;)V", "crosshairStorage", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/RetainableComponents;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/CrosshairComponent;", "fadeEffectRect", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement;", "measuringTooltipBox", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox;", "myLayoutManager", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager;", "myTileInfos", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;", "Lkotlin/collections/ArrayList;", "myTooltipLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "pinned", "regs", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "tooltipStorage", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "getOrientation", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;)Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "style", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "getStyle", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;)Ljava/lang/String;", "addTileInfo", "", "geomBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "targetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "layerYOrientations", "axisOrigin", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "applySpec", "tooltipBox", "spec", "dispose", "findTileInfo", "plotCoord", "getStrokeWidth", "", "hideTooltips", "measureTooltip", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "tooltipSpec", "onMouseClicked", "mouseEvent", "Lorg/jetbrains/letsPlot/commons/event/MouseEvent;", "onMouseDoubleClicked", "onMouseDragged", "onMouseLeft", "onMouseMoved", "pin", "showCrosshair", "tooltips", "showTooltips", "cursor", "tooltipSpecFromLookupResult", "lookupResult", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupResult;", "unpin", "isDark", "TileInfo", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nTooltipRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1#2:431\n1#2:466\n1360#3:432\n1446#3,5:433\n766#3:438\n857#3,2:439\n1549#3:441\n1620#3,3:442\n1855#3,2:445\n1747#3,3:447\n1747#3,3:450\n766#3:453\n857#3,2:454\n1603#3,9:456\n1855#3:465\n1856#3:467\n1612#3:468\n1855#3,2:469\n1360#3:471\n1446#3,5:472\n*S KotlinDebug\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer\n*L\n171#1:466\n129#1:432\n129#1:433,5\n130#1:438\n130#1:439,2\n132#1:441\n132#1:442,3\n146#1:445,2\n163#1:447,3\n164#1:450,3\n170#1:453\n170#1:454,2\n171#1:456,9\n171#1:465\n171#1:467\n171#1:468\n177#1:469,2\n427#1:471\n427#1:472,5\n*E\n"})
public final class TooltipRenderer
implements Disposable {
    private final boolean flippedAxis;
    @NotNull
    private final AxisTheme xAxisTheme;
    @NotNull
    private final AxisTheme yAxisTheme;
    @NotNull
    private final TooltipsTheme tooltipsTheme;
    @NotNull
    private final Color plotBackground;
    @NotNull
    private final StyleSheet styleSheet;
    @NotNull
    private final PlotContext plotContext;
    @NotNull
    private final CompositeRegistration regs;
    @NotNull
    private final LayoutManager myLayoutManager;
    @NotNull
    private final SvgGElement myTooltipLayer;
    @NotNull
    private final TooltipBox measuringTooltipBox;
    @NotNull
    private final ArrayList<TileInfo> myTileInfos;
    @NotNull
    private final RetainableComponents<TooltipBox> tooltipStorage;
    @NotNull
    private final RetainableComponents<CrosshairComponent> crosshairStorage;
    @NotNull
    private final SvgRectElement fadeEffectRect;
    private boolean pinned;

    /*
     * WARNING - void declaration
     */
    public TooltipRenderer(@NotNull SvgNode decorationLayer, boolean flippedAxis, @NotNull DoubleVector plotSize2, @NotNull AxisTheme xAxisTheme, @NotNull AxisTheme yAxisTheme, @NotNull TooltipsTheme tooltipsTheme, @NotNull Color plotBackground, @NotNull StyleSheet styleSheet, @NotNull PlotContext plotContext, @NotNull MouseEventPeer mouseEventPeer) {
        void $this$_init__u24lambda_u244;
        Object it;
        Object $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)xAxisTheme, (String)"xAxisTheme");
        Intrinsics.checkNotNullParameter((Object)yAxisTheme, (String)"yAxisTheme");
        Intrinsics.checkNotNullParameter((Object)tooltipsTheme, (String)"tooltipsTheme");
        Intrinsics.checkNotNullParameter((Object)plotBackground, (String)"plotBackground");
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        this.flippedAxis = flippedAxis;
        this.xAxisTheme = xAxisTheme;
        this.yAxisTheme = yAxisTheme;
        this.tooltipsTheme = tooltipsTheme;
        this.plotBackground = plotBackground;
        this.styleSheet = styleSheet;
        this.plotContext = plotContext;
        this.regs = new CompositeRegistration(new Registration[0]);
        this.myTileInfos = new ArrayList();
        DoubleRectangle viewport = new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize2);
        this.myLayoutManager = new LayoutManager(viewport, LayoutManager.HorizontalAlignment.LEFT);
        Object object = new TooltipBox(this.styleSheet);
        TooltipBox tooltipBox = object;
        TooltipRenderer tooltipRenderer = this;
        boolean bl = false;
        ((SvgComponent)$this$_init__u24lambda_u240).getRootGroup().visibility().set(SvgGraphicsElement.Visibility.HIDDEN);
        tooltipRenderer.measuringTooltipBox = object;
        $this$_init__u24lambda_u240 = object = new SvgGElement();
        tooltipRenderer = this;
        boolean bl2 = false;
        decorationLayer.children().add(it);
        tooltipRenderer.myTooltipLayer = object;
        this.myTooltipLayer.children().add(this.measuringTooltipBox.getRootGroup());
        it = object = new SvgGElement();
        Function0 function0 = 3.INSTANCE;
        tooltipRenderer = this;
        boolean bl3 = false;
        this.myTooltipLayer.children().add(it);
        Unit unit = Unit.INSTANCE;
        SvgNode svgNode = (SvgNode)object;
        Function0 function02 = function0;
        tooltipRenderer.crosshairStorage = new RetainableComponents(function02, svgNode);
        it = object = new SvgGElement();
        function0 = (Function0)new Function0<TooltipBox>(){

            @NotNull
            public final TooltipBox invoke() {
                return new TooltipBox(styleSheet);
            }
        };
        tooltipRenderer = this;
        boolean bl4 = false;
        this.myTooltipLayer.children().add(it);
        unit = Unit.INSTANCE;
        SvgNode svgNode2 = (SvgNode)object;
        Function0 function03 = function0;
        tooltipRenderer.tooltipStorage = new RetainableComponents(function03, svgNode2);
        it = object = new SvgRectElement();
        tooltipRenderer = this;
        boolean bl5 = false;
        $this$_init__u24lambda_u244.width().set(0.0);
        $this$_init__u24lambda_u244.height().set(0.0);
        $this$_init__u24lambda_u244.fillColor().set(this.plotBackground.changeAlpha(178));
        $this$_init__u24lambda_u244.visibility().set(SvgGraphicsElement.Visibility.HIDDEN);
        decorationLayer.children().add(0, $this$_init__u24lambda_u244);
        tooltipRenderer.fadeEffectRect = object;
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_MOVED, EventHandlerExKt.handler((Function1)new Function1<MouseEvent, Unit>((Object)this){

            public final void invoke(@NotNull MouseEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((TooltipRenderer)this.receiver).onMouseMoved(p0);
            }
        })));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_DRAGGED, EventHandlerExKt.handler((Function1)new Function1<MouseEvent, Unit>((Object)this){

            public final void invoke(@NotNull MouseEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((TooltipRenderer)this.receiver).onMouseDragged(p0);
            }
        })));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_LEFT, EventHandlerExKt.handler((Function1)new Function1<MouseEvent, Unit>((Object)this){

            public final void invoke(@NotNull MouseEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((TooltipRenderer)this.receiver).onMouseLeft(p0);
            }
        })));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_CLICKED, EventHandlerExKt.handler((Function1)new Function1<MouseEvent, Unit>((Object)this){

            public final void invoke(@NotNull MouseEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((TooltipRenderer)this.receiver).onMouseClicked(p0);
            }
        })));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_DOUBLE_CLICKED, EventHandlerExKt.handler((Function1)new Function1<MouseEvent, Unit>((Object)this){

            public final void invoke(@NotNull MouseEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((TooltipRenderer)this.receiver).onMouseDoubleClicked(p0);
            }
        })));
    }

    @Override
    public void dispose() {
        this.myTileInfos.clear();
        this.regs.dispose();
    }

    private final LayoutManager.MeasuredTooltip measureTooltip(TooltipSpec tooltipSpec) {
        this.applySpec(this.measuringTooltipBox, tooltipSpec);
        double d = this.getStrokeWidth(tooltipSpec);
        DoubleVector doubleVector = this.measuringTooltipBox.getContentRect().getDimension();
        return new LayoutManager.MeasuredTooltip(tooltipSpec, doubleVector, d);
    }

    /*
     * WARNING - void declaration
     */
    private final void showTooltips(DoubleVector cursor) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        TileInfo tileInfo = this.findTileInfo(cursor);
        if (tileInfo == null) {
            this.hideTooltips();
            return;
        }
        List<GeomTargetLocator.LookupResult> lookupResults = tileInfo.findTargets(cursor);
        Iterable iterable = lookupResults;
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GeomTargetLocator.LookupResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.tooltipSpecFromLookupResult((GeomTargetLocator.LookupResult)it, tileInfo.getAxisOrigin());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TooltipSpec)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)((TooltipSpec)it).getLines()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tooltips = (List)destination$iv$iv;
        Iterable $this$map$iv = tooltips;
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TooltipSpec bl = (TooltipSpec)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(this.measureTooltip((TooltipSpec)p0));
        }
        List measuredTooltips = (List)destination$iv$iv2;
        List<LayoutManager.PositionedTooltip> positionedTooltips = this.myLayoutManager.arrange(measuredTooltips, cursor, tileInfo.getGeomBounds(), tileInfo.getHAxisTooltipPosition(), tileInfo.getVAxisTooltipPosition());
        this.showCrosshair(positionedTooltips, tileInfo.getGeomBounds());
        Iterable $i$f$map22 = CollectionsKt.zip((Iterable)this.tooltipStorage.provide(positionedTooltips.size()), (Iterable)positionedTooltips);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair2 = (Pair)element$iv;
            boolean bl = false;
            TooltipBox tooltipComponent = (TooltipBox)pair2.component1();
            LayoutManager.PositionedTooltip info = (LayoutManager.PositionedTooltip)pair2.component2();
            this.applySpec(tooltipComponent, info.getTooltipSpec());
            tooltipComponent.setPosition(info.getTooltipCoord(), info.getStemCoord(), this.getOrientation(info), info.getTooltipSpec().getLayoutHint().getKind() == TipLayoutHint.Kind.ROTATED_TOOLTIP);
        }
    }

    private final void hideTooltips() {
        this.tooltipStorage.provide(0);
        this.crosshairStorage.provide(0);
    }

    /*
     * WARNING - void declaration
     */
    private final void showCrosshair(List<LayoutManager.PositionedTooltip> tooltips, DoubleRectangle geomBounds) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object tooltip;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean showHorizontal;
        Object element$iv3;
        boolean showVertical;
        block11: {
            boolean bl;
            boolean bl2;
            block10: {
                Iterable $this$any$iv = tooltips;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        LayoutManager.PositionedTooltip it = (LayoutManager.PositionedTooltip)element$iv2;
                        boolean bl3 = false;
                        if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.X_AXIS_TOOLTIP)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            showVertical = bl2;
            Iterable $this$any$iv = tooltips;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    LayoutManager.PositionedTooltip it = (LayoutManager.PositionedTooltip)element$iv3;
                    boolean bl4 = false;
                    if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP)) continue;
                    bl = true;
                    break block11;
                }
                bl = showHorizontal = false;
            }
        }
        if (!showVertical && !showHorizontal) {
            this.crosshairStorage.provide(0);
            return;
        }
        Iterable $i$f$any = tooltips;
        boolean $i$f$filter = false;
        element$iv3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            tooltip = (LayoutManager.PositionedTooltip)element$iv$iv;
            boolean bl = false;
            if (!((LayoutManager.PositionedTooltip)tooltip).getTooltipSpec().isCrosshairEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        tooltip = $this$forEach$iv$iv$iv.iterator();
        while (tooltip.hasNext()) {
            DoubleVector it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = tooltip.next();
            boolean bl = false;
            LayoutManager.PositionedTooltip tooltip2 = (LayoutManager.PositionedTooltip)element$iv$iv;
            boolean bl5 = false;
            if (tooltip2.getTooltipSpec().getLayoutHint().getCoord() == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List coords = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        List<CrosshairComponent> crosshairComponents = this.crosshairStorage.provide(coords.size());
        Iterable $i$f$mapNotNull22 = CollectionsKt.zip((Iterable)coords, (Iterable)crosshairComponents);
        boolean $i$f$forEach2 = false;
        for (Object element$iv4 : $this$forEach$iv) {
            Pair pair2 = (Pair)element$iv4;
            boolean bl = false;
            DoubleVector coord = (DoubleVector)pair2.component1();
            CrosshairComponent crosshairComponent = (CrosshairComponent)pair2.component2();
            crosshairComponent.update(coord, geomBounds, showHorizontal, showVertical);
        }
    }

    private final void onMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != Button.LEFT) {
            return;
        }
        if (mouseEvent.getModifiers().isCtrl()) {
            return;
        }
        if (this.pinned) {
            this.unpin();
            this.hideTooltips();
        } else {
            if (this.tooltipStorage.getSize() == 0) {
                return;
            }
            Object object = this.findTileInfo(mouseEvent.getLocation().toDoubleVector());
            if (object == null || (object = ((TileInfo)object).getGeomBounds()) == null) {
                return;
            }
            Object geomBounds = object;
            this.pin((DoubleRectangle)geomBounds);
        }
    }

    private final void onMouseDoubleClicked(MouseEvent mouseEvent) {
        if (this.pinned) {
            this.unpin();
        }
        this.hideTooltips();
    }

    private final void onMouseLeft(MouseEvent mouseEvent) {
        if (!this.pinned) {
            this.hideTooltips();
        }
    }

    private final void onMouseDragged(MouseEvent mouseEvent) {
        if (this.pinned) {
            this.unpin();
        }
        this.hideTooltips();
    }

    private final void onMouseMoved(MouseEvent mouseEvent) {
        if (!this.pinned) {
            this.showTooltips(mouseEvent.getLocation().toDoubleVector());
        }
    }

    private final void unpin() {
        this.fadeEffectRect.width().set(0.0);
        this.fadeEffectRect.height().set(0.0);
        this.fadeEffectRect.visibility().set(SvgGraphicsElement.Visibility.HIDDEN);
        this.pinned = false;
    }

    private final void pin(DoubleRectangle geomBounds) {
        this.fadeEffectRect.x().set(geomBounds.getLeft());
        this.fadeEffectRect.y().set(geomBounds.getTop());
        this.fadeEffectRect.width().set(geomBounds.getWidth());
        this.fadeEffectRect.height().set(geomBounds.getHeight());
        this.fadeEffectRect.visibility().set(SvgGraphicsElement.Visibility.VISIBLE);
        this.pinned = true;
    }

    public final void addTileInfo(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
        TileInfo tileInfo = new TileInfo(geomBounds, targetLocators, layerYOrientations, this.flippedAxis, axisOrigin, hAxisTooltipPosition, vAxisTooltipPosition);
        this.myTileInfos.add(tileInfo);
    }

    private final TileInfo findTileInfo(DoubleVector plotCoord) {
        for (TileInfo tileInfo : this.myTileInfos) {
            if (!tileInfo.contains(plotCoord)) continue;
            return tileInfo;
        }
        return null;
    }

    private final boolean isDark(Color $this$isDark) {
        return Colors.INSTANCE.luminance($this$isDark) < 0.5;
    }

    private final String getStyle(TooltipSpec $this$style) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$style.getLayoutHint().getKind().ordinal()]) {
            case 1: {
                string = "axis-tooltip-text-" + this.xAxisTheme.getAxis();
                break;
            }
            case 2: {
                string = "axis-tooltip-text-" + this.yAxisTheme.getAxis();
                break;
            }
            case 3: {
                string = "tooltip-text";
                break;
            }
            case 4: {
                string = "tooltip-text";
                break;
            }
            case 5: {
                string = "tooltip-text";
                break;
            }
            case 6: {
                string = "tooltip-text";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final TooltipBox.Orientation getOrientation(LayoutManager.PositionedTooltip $this$orientation) {
        TooltipBox.Orientation orientation;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$orientation.getHintKind$plot_builder().ordinal()]) {
            case 4: {
                orientation = TooltipBox.Orientation.HORIZONTAL;
                break;
            }
            case 2: {
                orientation = TooltipBox.Orientation.HORIZONTAL;
                break;
            }
            case 3: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 5: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 1: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 6: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return orientation;
    }

    private final void applySpec(TooltipBox tooltipBox, TooltipSpec spec) {
        double d;
        Color color;
        if (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP) {
            color = this.xAxisTheme.tooltipFill();
        } else if (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP) {
            color = this.yAxisTheme.tooltipFill();
        } else if (spec.isSide()) {
            Color color2 = spec.getFill();
            if (color2 == null) {
                color2 = Color.Companion.getWHITE();
            }
            Color it = color2;
            boolean bl = false;
            color = Colors.INSTANCE.mimicTransparency(it, (double)it.getAlpha() / 255.0, Color.Companion.getWHITE());
        } else {
            color = this.tooltipsTheme.tooltipFill();
        }
        Color fillColor = color;
        Color borderColor = spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipColor() : (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipColor() : (spec.isSide() ? (this.isDark(fillColor) ? Defaults.Common.Tooltip.INSTANCE.getLIGHT_TEXT_COLOR() : Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR()) : this.tooltipsTheme.tooltipColor()));
        TipLayoutHint.Kind[] bl = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.X_AXIS_TOOLTIP, TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        Color textColor2 = !CollectionsKt.listOf((Object[])bl).contains((Object)spec.getLayoutHint().getKind()) && spec.isSide() ? borderColor : null;
        double strokeWidth = this.getStrokeWidth(spec);
        LineType lineType2 = spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipLineType() : (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipLineType() : (spec.isSide() ? (LineType)NamedLineType.SOLID : this.tooltipsTheme.tooltipLineType()));
        switch (WhenMappings.$EnumSwitchMapping$0[spec.getLayoutHint().getKind().ordinal()]) {
            case 1: 
            case 2: {
                d = 0.0;
                break;
            }
            default: {
                d = 4.0;
            }
        }
        double borderRadius = d;
        tooltipBox.update(fillColor, textColor2, borderColor, strokeWidth, lineType2, spec.getLines(), spec.getTitle(), this.getStyle(spec), spec.getLayoutHint().getKind() == TipLayoutHint.Kind.ROTATED_TOOLTIP, spec.getMinWidth(), borderRadius, CollectionsKt.distinct((Iterable)spec.getMarkerColors()), this.plotBackground);
    }

    private final double getStrokeWidth(TooltipSpec spec) {
        return spec.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipStrokeWidth() : (spec.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipStrokeWidth() : (spec.isSide() ? 1.0 : this.tooltipsTheme.tooltipStrokeWidth()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TooltipSpec> tooltipSpecFromLookupResult(GeomTargetLocator.LookupResult lookupResult2, DoubleVector axisOrigin) {
        void $this$flatMapTo$iv$iv;
        TooltipSpecFactory it = new TooltipSpecFactory(lookupResult2.getContextualMapping(), axisOrigin, this.flippedAxis, this.xAxisTheme, this.yAxisTheme, this.plotContext);
        boolean bl = false;
        Iterable $this$flatMap$iv = lookupResult2.getTargets();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GeomTarget p0 = (GeomTarget)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.create(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001f BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0086\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u001c\u001a\u00020\u000bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;", "", "geomBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "targetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "layerYOrientations", "", "flippedAxis", "axisOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Ljava/util/List;Ljava/util/List;ZLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;)V", "getAxisOrigin", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getGeomBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getHAxisTooltipPosition", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "transformedLocators", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TransformedTargetLocator;", "getVAxisTooltipPosition", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "contains", "plotCoord", "findTargets", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupResult;", "FlippedTileTargetLocator", "TileTargetLocator", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1549#2:431\n1620#2,3:432\n*S KotlinDebug\n*F\n+ 1 TooltipRenderer.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo\n*L\n292#1:431\n292#1:432,3\n*E\n"})
    private static final class TileInfo {
        @NotNull
        private final DoubleRectangle geomBounds;
        private final boolean flippedAxis;
        @NotNull
        private final DoubleVector axisOrigin;
        @NotNull
        private final HorizontalAxisTooltipPosition hAxisTooltipPosition;
        @NotNull
        private final VerticalAxisTooltipPosition vAxisTooltipPosition;
        @NotNull
        private final List<TransformedTargetLocator> transformedLocators;

        /*
         * WARNING - void declaration
         */
        public TileInfo(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, boolean flippedAxis, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
            Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
            Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
            Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
            Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
            Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
            this.geomBounds = geomBounds;
            this.flippedAxis = flippedAxis;
            this.axisOrigin = axisOrigin;
            this.hAxisTooltipPosition = hAxisTooltipPosition;
            this.vAxisTooltipPosition = vAxisTooltipPosition;
            Iterable iterable = CollectionsKt.zip((Iterable)targetLocators, (Iterable)layerYOrientations);
            TileInfo tileInfo = this;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TransformedTargetLocator transformedTargetLocator;
                boolean flip;
                Pair pair2 = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GeomTargetLocator targetLocator = (GeomTargetLocator)pair2.component1();
                boolean isYOrientation = (Boolean)pair2.component2();
                boolean bl2 = flip = isYOrientation ? !this.flippedAxis : this.flippedAxis;
                if (bl2) {
                    transformedTargetLocator = new FlippedTileTargetLocator(targetLocator);
                } else if (!bl2) {
                    transformedTargetLocator = new TileTargetLocator(targetLocator);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(transformedTargetLocator);
            }
            tileInfo.transformedLocators = (List)destination$iv$iv;
        }

        @NotNull
        public final DoubleRectangle getGeomBounds() {
            return this.geomBounds;
        }

        @NotNull
        public final DoubleVector getAxisOrigin() {
            return this.axisOrigin;
        }

        @NotNull
        public final HorizontalAxisTooltipPosition getHAxisTooltipPosition() {
            return this.hAxisTooltipPosition;
        }

        @NotNull
        public final VerticalAxisTooltipPosition getVAxisTooltipPosition() {
            return this.vAxisTooltipPosition;
        }

        @NotNull
        public final List<GeomTargetLocator.LookupResult> findTargets(@NotNull DoubleVector plotCoord) {
            LocatedTargetsPicker locatedTargetsPicker;
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            LocatedTargetsPicker $this$findTargets_u24lambda_u241 = locatedTargetsPicker = new LocatedTargetsPicker(this.flippedAxis, plotCoord);
            boolean bl = false;
            for (TransformedTargetLocator locator : this.transformedLocators) {
                GeomTargetLocator.LookupResult result2 = locator.search(plotCoord);
                if (result2 == null) continue;
                $this$findTargets_u24lambda_u241.addLookupResult(result2);
            }
            LocatedTargetsPicker targetsPicker = locatedTargetsPicker;
            return targetsPicker.getPicked();
        }

        public final boolean contains(@NotNull DoubleVector plotCoord) {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            return this.geomBounds.contains(plotCoord);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo$FlippedTileTargetLocator;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TransformedTargetLocator;", "locator", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;)V", "convertToPlotCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder"})
        private final class FlippedTileTargetLocator
        extends TransformedTargetLocator {
            public FlippedTileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }

            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds().getOrigin()).flip();
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.flip().add(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo$TileTargetLocator;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/loc/TransformedTargetLocator;", "locator", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer$TileInfo;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;)V", "convertToPlotCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder"})
        private final class TileTargetLocator
        extends TransformedTargetLocator {
            public TileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }

            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.add(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TipLayoutHint.Kind.values().length];
            try {
                nArray[TipLayoutHint.Kind.X_AXIS_TOOLTIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.Y_AXIS_TOOLTIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.VERTICAL_TOOLTIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.HORIZONTAL_TOOLTIP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.CURSOR_TOOLTIP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.ROTATED_TOOLTIP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

