/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.intern.standardizing;

import java.awt.Color;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.intern.standardizing.JvmStandardizingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0001J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0001J\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/intern/standardizing/JvmStandardizing;", "", "()V", "getTimeZoneAnnotation", "", "o", "getTypeAnnotation", "isJvm", "", "standardize", "plot-api"})
public final class JvmStandardizing {
    @NotNull
    public static final JvmStandardizing INSTANCE = new JvmStandardizing();

    private JvmStandardizing() {
    }

    public final boolean isJvm(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (JvmStandardizingKt.access$getAWT_PRESENT$p() && o instanceof Color) {
            return true;
        }
        Object object = o;
        return object instanceof Date ? true : (object instanceof Instant ? true : (object instanceof ZonedDateTime ? true : (object instanceof OffsetDateTime ? true : (object instanceof LocalDate ? true : (object instanceof LocalTime ? true : object instanceof LocalDateTime)))));
    }

    @NotNull
    public final String getTypeAnnotation(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Object object = o;
        return object instanceof Date ? "datetime" : (object instanceof Instant ? "datetime" : (object instanceof ZonedDateTime ? "datetime" : (object instanceof OffsetDateTime ? "datetime" : (object instanceof LocalDate ? "date" : (object instanceof LocalTime ? "time" : (object instanceof LocalDateTime ? "datetime" : "unknown"))))));
    }

    @Nullable
    public final String getTimeZoneAnnotation(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Object object = o;
        return object instanceof ZonedDateTime ? (Intrinsics.areEqual((Object)((ZonedDateTime)o).getZone().getId(), (Object)"Z") ? "UTC" : ((ZonedDateTime)o).getZone().getId()) : (object instanceof OffsetDateTime ? (Intrinsics.areEqual((Object)((OffsetDateTime)o).getOffset().getId(), (Object)"Z") ? "UTC" : "UTC" + ((OffsetDateTime)o).getOffset().getId()) : null);
    }

    @NotNull
    public final Object standardize(@NotNull Object o) {
        long l;
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (JvmStandardizingKt.access$getAWT_PRESENT$p() && o instanceof Color) {
            String string = "#%02x%02x%02x";
            Object[] objectArray = new Object[]{((Color)o).getRed(), ((Color)o).getGreen(), ((Color)o).getBlue()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        Object object = o;
        if (object instanceof Date) {
            l = ((Date)o).getTime();
        } else if (object instanceof Instant) {
            l = ((Instant)o).toEpochMilli();
        } else if (object instanceof ZonedDateTime) {
            l = ((ZonedDateTime)o).toInstant().toEpochMilli();
        } else if (object instanceof OffsetDateTime) {
            l = ((OffsetDateTime)o).toInstant().toEpochMilli();
        } else if (object instanceof LocalDate) {
            l = ((LocalDate)o).atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        } else if (object instanceof LocalTime) {
            l = LocalDateTime.of(LocalDate.EPOCH, (LocalTime)o).toInstant(ZoneOffset.UTC).toEpochMilli();
        } else if (object instanceof LocalDateTime) {
            l = ((LocalDateTime)o).toInstant(ZoneOffset.UTC).toEpochMilli();
        } else {
            throw new IllegalArgumentException("Can't standardize value \"" + o + "\" of type " + Reflection.getOrCreateKotlinClass(o.getClass()).getQualifiedName() + " as string or number.");
        }
        return (double)l;
    }
}

