/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen.font;

import org.jetbrains.relocated.apache.batik.svggen.font.Point;
import org.jetbrains.relocated.apache.batik.svggen.font.table.GlyphDescription;

public class Glyph {
    protected short leftSideBearing;
    protected int advanceWidth;
    private Point[] points;

    public Glyph(GlyphDescription gd, short lsb, int advance) {
        this.leftSideBearing = lsb;
        this.advanceWidth = advance;
        this.describe(gd);
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public short getLeftSideBearing() {
        return this.leftSideBearing;
    }

    public Point getPoint(int i) {
        return this.points[i];
    }

    public int getPointCount() {
        return this.points.length;
    }

    public void reset() {
    }

    public void scale(int factor) {
        for (Point point2 : this.points) {
            point2.x = (point2.x << 10) * factor >> 26;
            point2.y = (point2.y << 10) * factor >> 26;
        }
        this.leftSideBearing = (short)(this.leftSideBearing * factor >> 6);
        this.advanceWidth = this.advanceWidth * factor >> 6;
    }

    private void describe(GlyphDescription gd) {
        int endPtIndex = 0;
        this.points = new Point[gd.getPointCount() + 2];
        for (int i = 0; i < gd.getPointCount(); ++i) {
            boolean endPt;
            boolean bl = endPt = gd.getEndPtOfContours(endPtIndex) == i;
            if (endPt) {
                ++endPtIndex;
            }
            this.points[i] = new Point(gd.getXCoordinate(i), gd.getYCoordinate(i), (gd.getFlags(i) & 1) != 0, endPt);
        }
        this.points[gd.getPointCount()] = new Point(0, 0, true, true);
        this.points[gd.getPointCount() + 1] = new Point(this.advanceWidth, 0, true, true);
    }
}

