/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.dom;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/dom/Window;", "", "<init>", "()V", "Companion", "intellij.httpClient.executor"})
public final class Window {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final String btoaUrl(Value ... args) {
        return Companion.btoaUrl(args);
    }

    @JvmStatic
    @Nullable
    public static final String btoa(Value ... args) {
        return Companion.btoa(args);
    }

    @JvmStatic
    @Nullable
    public static final String atob(Value ... args) {
        return Companion.atob(args);
    }

    @JvmStatic
    @Nullable
    public static final String atobUrl(Value ... args) {
        return Companion.atobUrl(args);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\tJ#\u0010\n\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\tJ+\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\tJ#\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\tJ+\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/dom/Window$Companion;", "", "<init>", "()V", "btoaUrl", "", "args", "", "Lorg/graalvm/polyglot/Value;", "([Lorg/graalvm/polyglot/Value;)Ljava/lang/String;", "btoa", "btoaImpl", "urlSafe", "", "([Lorg/graalvm/polyglot/Value;Z)Ljava/lang/String;", "atob", "atobUrl", "atobImpl", "isUrl", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Window.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/dom/Window$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,136:1\n11561#2:137\n11896#2,3:138\n*S KotlinDebug\n*F\n+ 1 Window.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/dom/Window$Companion\n*L\n62#1:137\n62#1:138,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String btoaUrl(Value ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.btoaImpl(Arrays.copyOf(args, args.length), true);
        }

        @JvmStatic
        @Nullable
        public final String btoa(Value ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.btoaImpl(Arrays.copyOf(args, args.length), false);
        }

        /*
         * WARNING - void declaration
         */
        private final String btoaImpl(Value[] args, boolean urlSafe) {
            byte[] byArray;
            if (args.length == 0) {
                Value.asValue((Object)1).getContext().eval("js", (CharSequence)"throw new TypeError('Not enough arguments')");
                return null;
            }
            Context ctx = args[0].getContext();
            Value a = args[0];
            if (a.isString()) {
                String s = a.asString();
                Intrinsics.checkNotNull((Object)s);
                String string = s;
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char ch = string.charAt(i);
                    if (ch <= '\u00ff') continue;
                    ctx.eval("js", (CharSequence)"throw new InvalidCharacterError()");
                    return null;
                }
                string = s;
                Charset charset = StandardCharsets.ISO_8859_1;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
                byte[] byArray2 = string.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            } else if (a.isProxyObject()) {
                ProxyArray pa = (ProxyArray)a.asProxyObject();
                byte[] out = new byte[(int)pa.getSize()];
                for (int i = 0; i < out.length; ++i) {
                    Object v = pa.get((long)i);
                    if (!(v instanceof Number)) {
                        ctx.eval("js", (CharSequence)"throw new TypeError('Array element is not a number')");
                        return null;
                    }
                    int n = ((Number)v).intValue();
                    out[i] = (byte)(n & 0xFF);
                }
                byArray = out;
            } else {
                void $this$mapTo$iv$iv;
                Value[] $this$map$iv = args;
                boolean $i$f$map = false;
                Value[] i = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    byte by;
                    void it;
                    void item$iv$iv;
                    void var14_19 = item$iv$iv = $this$mapTo$iv$iv[j];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (it.fitsInByte()) {
                        by = it.asByte();
                    } else if (it.fitsInInt()) {
                        by = (byte)(it.asInt() & 0xFF);
                    } else if (it.isNumber()) {
                        by = (byte)it.asDouble();
                    } else {
                        ctx.eval("js", (CharSequence)"throw new TypeError('Argument is not a number')");
                        return null;
                    }
                    collection.add(by);
                }
                byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
            }
            byte[] bytes = byArray;
            Base64.Encoder enc = urlSafe ? Base64.getUrlEncoder().withoutPadding() : Base64.getEncoder();
            return enc.encodeToString(bytes);
        }

        @JvmStatic
        @Nullable
        public final String atob(Value ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.atobImpl(Arrays.copyOf(args, args.length), false);
        }

        @JvmStatic
        @Nullable
        public final String atobUrl(Value ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return this.atobImpl(Arrays.copyOf(args, args.length), true);
        }

        private final String atobImpl(Value[] args, boolean isUrl) {
            if (args.length == 0) {
                Value.asValue((Object)1).getContext().eval("js", (CharSequence)"throw new TypeError('Not enough arguments')");
                return null;
            }
            Context ctx = args[0].getContext();
            try {
                byte[] bytes;
                Object s = args[0].asString();
                CharSequence charSequence = s;
                Intrinsics.checkNotNull((Object)charSequence);
                charSequence = charSequence;
                Regex regex = new Regex("[\\t\\n\\f\\r ]");
                Object object = "";
                s = regex.replace(charSequence, (String)object);
                if (isUrl) {
                    if (StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)'+', (int)0, (boolean)false, (int)6, null) >= 0 || StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)'/', (int)0, (boolean)false, (int)6, null) >= 0) {
                        ctx.eval("js", (CharSequence)"throw new InvalidCharacterError()");
                        return null;
                    }
                    if (((String)s).length() % 4 == 1) {
                        ctx.eval("js", (CharSequence)"throw new InvalidCharacterError()");
                        return null;
                    }
                    int pad = (4 - ((String)s).length() % 4) % 4;
                    if (pad != 0) {
                        s = (String)s + StringsKt.repeat((CharSequence)"=", (int)pad);
                    }
                    bytes = Base64.getUrlDecoder().decode((String)s);
                    Intrinsics.checkNotNull((Object)bytes);
                    object = bytes;
                    Charset charset = StandardCharsets.ISO_8859_1;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
                    Charset charset2 = charset;
                    return new String((byte[])object, charset2);
                }
                if (StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)'-', (int)0, (boolean)false, (int)6, null) >= 0 || StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)'_', (int)0, (boolean)false, (int)6, null) >= 0) {
                    ctx.eval("js", (CharSequence)"throw new InvalidCharacterError()");
                    return null;
                }
                if (((String)s).length() % 4 == 1) {
                    ctx.eval("js", (CharSequence)"throw new InvalidCharacterError()");
                    return null;
                }
                int pad = (4 - ((String)s).length() % 4) % 4;
                if (pad != 0) {
                    s = (String)s + StringsKt.repeat((CharSequence)"=", (int)pad);
                }
                bytes = Base64.getDecoder().decode((String)s);
                Intrinsics.checkNotNull((Object)bytes);
                object = bytes;
                Charset charset = StandardCharsets.ISO_8859_1;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
                Charset charset3 = charset;
                return new String((byte[])object, charset3);
            }
            catch (IllegalArgumentException e) {
                args[0].getContext().eval("js", (CharSequence)"throw new InvalidCharacterError()");
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

