/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.jsonPath.JsonPathUtilKt;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0013H\u0016J\r\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/jsonPath/CreateEnvFileFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "name", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "startInWriteAction", "", "intellij.restClient"})
final class CreateEnvFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String name;

    public CreateEnvFileFix(@NotNull PsiElement element, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(element);
        this.name = name;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (editor2 == null) {
            return;
        }
        HttpRequestPsiFile httpRequestPsiFile = JsonPathUtilKt.retrieveHostHttpFile(psiFile);
        if (httpRequestPsiFile == null || (httpRequestPsiFile = httpRequestPsiFile.getOriginalFile()) == null) {
            return;
        }
        HttpRequestPsiFile httpFile = httpRequestPsiFile;
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getContentComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext editorContext = dataContext;
        DataContext dataContext2 = CustomizedDataContext.withSnapshot((DataContext)editorContext, arg_0 -> CreateEnvFileFix.invoke$lambda$0(this, (PsiFile)httpFile, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"withSnapshot(...)");
        DataContext context2 = dataContext2;
        AnAction action = ActionManager.getInstance().getAction("HTTPClientNewEnvironmentFile");
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"IntentionMenu", (DataContext)context2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent event = anActionEvent;
        event.getPresentation().setPerformGroup(true);
        Intrinsics.checkNotNull((Object)action);
        ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.name};
        String string = RestClientBundle.message("http.client.unresolved.variable.create.env.with.var.quickfix.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static final void invoke$lambda$0(CreateEnvFileFix this$0, PsiFile $httpFile, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey<Consumer<String>> dataKey = HttpClientDataKeys.ENV_NAME_CHOSEN_LISTENER;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"ENV_NAME_CHOSEN_LISTENER");
        sink.set(dataKey, arg_0 -> CreateEnvFileFix.invoke$lambda$0$0($httpFile, arg_0));
        DataKey<String> dataKey2 = HttpClientDataKeys.ENV_VARIABLE_DEFAULT_NAME;
        Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"ENV_VARIABLE_DEFAULT_NAME");
        sink.set(dataKey2, (Object)this$0.name);
    }

    private static final void invoke$lambda$0$0(PsiFile $httpFile, String env) {
        Project project = $httpFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HttpClientSelectedEnvironments httpClientSelectedEnvironments = HttpClientSelectedEnvironments.Companion.getInstance(project);
        VirtualFile virtualFile = $httpFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        httpClientSelectedEnvironments.set(virtualFile, env);
    }
}

