/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.mysqlbase.MysqlBaseErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlErrorHandler
extends MysqlBaseErrorHandler {
    private static final Pattern UNRECOGNIZED_TIME_ZONE = Pattern.compile("The server time zone value '.*' is unrecognized");
    public static final String SERVER_TIMEZONE = "serverTimezone";
    private static final String TLS_PROTOCOLS = "enabledTLSProtocols";
    private static final String[] ALL_TLS_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};

    @NotNull
    protected ErrorInfo getErrorInfo(@NotNull Project project, @Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        String causeMessage;
        if (project == null) {
            MysqlErrorHandler.$$$reportNull$$$0(0);
        }
        if (original == null) {
            MysqlErrorHandler.$$$reportNull$$$0(1);
        }
        if (cause == null) {
            MysqlErrorHandler.$$$reportNull$$$0(2);
        }
        if ((causeMessage = cause.getMessage()) != null) {
            if (UNRECOGNIZED_TIME_ZONE.matcher(causeMessage).find()) {
                return new MysqlUnrecognizedTimeZoneErrorInfo(dataSource, original, cause);
            }
            if (MysqlErrorHandler.isHandshakeTerminated(original)) {
                return new MysqlHandshakeTerminatedErrorInfo(dataSource, original, cause, project);
            }
            if (MysqlErrorHandler.isNoSslProtocol((Throwable)cause)) {
                return new MysqlNoSslProtocolErrorInfo(dataSource, original, cause);
            }
        }
        ErrorInfo errorInfo = super.getErrorInfo(project, dataSource, original, cause);
        if (errorInfo == null) {
            MysqlErrorHandler.$$$reportNull$$$0(3);
        }
        return errorInfo;
    }

    private static boolean isHandshakeTerminated(@NotNull Throwable original) {
        Throwable hsEx;
        if (original == null) {
            MysqlErrorHandler.$$$reportNull$$$0(4);
        }
        return (hsEx = MysqlErrorHandler.findByClassName((Throwable)original, (String)"javax.net.ssl.SSLHandshakeException")) != null && MysqlErrorHandler.getMessage((Throwable)hsEx).contains("Remote host terminated the handshake");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isHandshakeTerminated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class MysqlUnrecognizedTimeZoneErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        MysqlUnrecognizedTimeZoneErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MysqlUnrecognizedTimeZoneErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MysqlUnrecognizedTimeZoneErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MysqlUnrecognizedTimeZoneErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MysqlUnrecognizedTimeZoneErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(DatabaseBundle.message((String)"error.message.mysql.invalid.timezone", (Object[])new Object[0]));
            MysqlUnrecognizedTimeZoneErrorInfo.addFix(fixes, f -> f.setDriverProperty(this.getDataSource(), DatabaseBundle.message((String)"error.message.mysql.invalid.timezone.fix", (Object[])new Object[0]), MysqlErrorHandler.SERVER_TIMEZONE, "UTC"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler$MysqlUnrecognizedTimeZoneErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MysqlHandshakeTerminatedErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        MysqlHandshakeTerminatedErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull Project project) {
            if (original == null) {
                MysqlHandshakeTerminatedErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MysqlHandshakeTerminatedErrorInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MysqlHandshakeTerminatedErrorInfo.$$$reportNull$$$0(2);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MysqlHandshakeTerminatedErrorInfo.$$$reportNull$$$0(3);
            }
            if (fixes == null) {
                MysqlHandshakeTerminatedErrorInfo.$$$reportNull$$$0(4);
            }
            sb.append(DatabaseBundle.message((String)"server.has.terminated.the.handshake.you.have.enabledtlsprotocols.set.that.option.causes.connection.issues.with.some.versions.of.mysql", (Object[])new Object[0]));
            MysqlHandshakeTerminatedErrorInfo.addFix(fixes, f -> f.setDriverProperty(this.getDataSource(), DatabaseBundle.message((String)"error.message.mysql.tls.protocol.version.clear", (Object[])new Object[0]), MysqlErrorHandler.TLS_PROTOCOLS, null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler$MysqlHandshakeTerminatedErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MysqlNoSslProtocolErrorInfo
    extends BaseDatabaseErrorHandler.NoSslProtocolErrorInfo {
        MysqlNoSslProtocolErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MysqlNoSslProtocolErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MysqlNoSslProtocolErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            boolean allSet;
            if (sb == null) {
                MysqlNoSslProtocolErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MysqlNoSslProtocolErrorInfo.$$$reportNull$$$0(3);
            }
            super.fillInfoData(sb, fixes);
            if (this.getDataSource() == null) {
                return;
            }
            String protocols = (String)this.getDataSource().getDriverProperties().get(MysqlErrorHandler.TLS_PROTOCOLS);
            boolean bl = allSet = protocols != null && ContainerUtil.find((Object[])ALL_TLS_PROTOCOLS, p -> !protocols.contains((CharSequence)p)) == null;
            if (!allSet) {
                boolean protocolsNotSet = StringUtil.isEmptyOrSpaces((String)protocols);
                @NotNull String message1 = DatabaseBundle.message((String)(protocolsNotSet ? "error.message.mysql.tls.protocol.version.all" : "error.message.mysql.tls.protocol.version.clear"), (Object[])new Object[0]);
                String value = protocolsNotSet ? StringUtil.join((String[])ALL_TLS_PROTOCOLS, (String)", ") : null;
                MysqlNoSslProtocolErrorInfo.addFix(fixes, f -> f.setDriverProperty(this.getDataSource(), message1, MysqlErrorHandler.TLS_PROTOCOLS, value));
            }
            sb.append("\n\n").append(DatabaseBundle.message((String)"error.message.mysql.tls.protocol.version", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler$MysqlNoSslProtocolErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

