/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.focus;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.content.Content;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.codeWithMe.model.RdEditorAreaFocusLocation;
import com.jetbrains.codeWithMe.model.RdFocusLocation;
import com.jetbrains.codeWithMe.model.RdToolWindowFocusLocation;
import com.jetbrains.codeWithMe.model.RdUserFocusNode;
import com.jetbrains.rd.platform.codeWithMe.focus.ToolWindowUserFocusHandler;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusHandler;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusHandlerRegistry;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusManager;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.Property;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001d\u001a\u00020\u001eH&J\u0006\u0010\u001f\u001a\u00020\u001cJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010&\u001a\u00020\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010(\u001a\u00020\u0018H\u0002J\u001e\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0018\u0018\u00010*2\u0006\u0010+\u001a\u00020\"H\u0002J\u001e\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0018\u0018\u00010*2\u0006\u0010,\u001a\u00020\u0018H\u0002J\"\u0010-\u001a\u0004\u0018\u00010\u00182\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*2\u0006\u0010,\u001a\u00020\u0018H\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "toolWindowHandler", "Lcom/jetbrains/rd/platform/codeWithMe/focus/ToolWindowUserFocusHandler;", "_currentFocus", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/codeWithMe/model/RdFocusLocation;", "currentFocus", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getCurrentFocus", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "currentActiveToolWindowId", "", "getCurrentActiveToolWindowId", "()Ljava/lang/String;", "findComponent", "Ljava/awt/Component;", "userFocus", "Lcom/jetbrains/codeWithMe/model/RdToolWindowFocusLocation;", "highlightFocus", "", "shouldSkipUpdatingFocusProperty", "", "updateCurrentFocus", "collectNodesPath", "", "Lcom/jetbrains/codeWithMe/model/RdUserFocusNode;", "focusOwner", "cutOffParent", "Ljavax/swing/JComponent;", "followNodesPath", "nodes", "rootComponent", "findFocusHandler", "Lcom/jetbrains/rd/platform/codeWithMe/focus/UserFocusHandler;", "node", "component", "findComponentFor", "handler", "Companion", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nUserFocusManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserFocusManager.kt\ncom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1563#2:218\n1634#2,3:219\n*S KotlinDebug\n*F\n+ 1 UserFocusManager.kt\ncom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager\n*L\n154#1:218\n154#1:219,3\n*E\n"})
public abstract class UserFocusManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project project;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final ToolWindowUserFocusHandler toolWindowHandler;
    @NotNull
    private final Property<RdFocusLocation> _currentFocus;

    public UserFocusManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.queue = MergingUpdateQueue.Companion.edtMergingUpdateQueue("CWMUserFocusManager", 100, coroutineScope, null);
        this.toolWindowHandler = new ToolWindowUserFocusHandler(this.project);
        this._currentFocus = new Property(null);
        PropertyChangeListener focusListener = arg_0 -> UserFocusManager._init_$lambda$0(this, arg_0);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("focusOwner", focusListener);
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", focusListener);
        this.getServiceLifetime().onTermination(() -> UserFocusManager._init_$lambda$1(keyboardFocusManager, focusListener));
    }

    @NotNull
    public final IPropertyView<RdFocusLocation> getCurrentFocus() {
        return (IPropertyView)this._currentFocus;
    }

    @Nullable
    public final String getCurrentActiveToolWindowId() {
        Object object = this.getCurrentFocus().getValue();
        RdToolWindowFocusLocation rdToolWindowFocusLocation = object instanceof RdToolWindowFocusLocation ? (RdToolWindowFocusLocation)object : null;
        return rdToolWindowFocusLocation != null ? rdToolWindowFocusLocation.getToolWindowId() : null;
    }

    @Nullable
    public final Component findComponent(@NotNull RdToolWindowFocusLocation userFocus) {
        RdUserFocusNode node;
        Intrinsics.checkNotNullParameter((Object)userFocus, (String)"userFocus");
        Content content = this.toolWindowHandler.getContent(userFocus);
        if (content == null) {
            return null;
        }
        Content content2 = content;
        JComponent jComponent = content2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        Component component = jComponent;
        Iterator iterator = userFocus.getPath().iterator();
        while (iterator.hasNext() && this.findFocusHandler(node = (RdUserFocusNode)iterator.next()) != null) {
            UserFocusHandler<RdUserFocusNode, Component> handler;
            Component targetComponent = this.findComponentFor(handler, component);
            if (targetComponent != null) {
                Component result2 = handler.follow(targetComponent, node, false);
                if (result2 == null) {
                    return targetComponent;
                }
                component = result2;
                continue;
            }
            if (handler.isOptional()) continue;
            break;
        }
        return null;
    }

    public final void highlightFocus(@NotNull RdToolWindowFocusLocation userFocus) {
        Intrinsics.checkNotNullParameter((Object)userFocus, (String)"userFocus");
        this.toolWindowHandler.follow(userFocus, (Function1<? super Component, Unit>)((Function1)arg_0 -> UserFocusManager.highlightFocus$lambda$0(this, userFocus, arg_0)));
    }

    public abstract boolean shouldSkipUpdatingFocusProperty();

    public final void updateCurrentFocus() {
        if (this.project.isDisposed() || this.shouldSkipUpdatingFocusProperty()) {
            this._currentFocus.set(null);
            return;
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null) {
            return;
        }
        Component focusOwner = component;
        EditorsSplitters editorSplitters = (EditorsSplitters)UIUtil.getParentOfType(EditorsSplitters.class, (Component)focusOwner);
        if (editorSplitters != null) {
            this._currentFocus.set((Object)new RdEditorAreaFocusLocation());
            return;
        }
        InternalDecoratorImpl internalDecorator = (InternalDecoratorImpl)UIUtil.getParentOfType(InternalDecoratorImpl.class, (Component)focusOwner);
        if (internalDecorator == null) {
            this._currentFocus.set(null);
            return;
        }
        String toolWindowId = internalDecorator.getToolWindowId();
        List<RdUserFocusNode> nodes = this.collectNodesPath(focusOwner, (JComponent)internalDecorator);
        RdToolWindowFocusLocation path = this.toolWindowHandler.createPath(toolWindowId, nodes);
        this._currentFocus.set((Object)path);
    }

    private final List<RdUserFocusNode> collectNodesPath(Component focusOwner, JComponent cutOffParent) {
        List nodes = new ArrayList();
        for (Component component = focusOwner; component != null && !Intrinsics.areEqual((Object)component, (Object)cutOffParent); component = (Component)component.getParent()) {
            RdUserFocusNode node;
            UserFocusHandler<RdUserFocusNode, Component> handler;
            UserFocusHandler<RdUserFocusNode, Component> userFocusHandler = handler = this.findFocusHandler(component);
            RdUserFocusNode rdUserFocusNode = node = userFocusHandler != null ? userFocusHandler.getNode(component, focusOwner) : null;
            if (node == null) continue;
            nodes.add(node);
        }
        return CollectionsKt.reversed((Iterable)nodes);
    }

    private final void followNodesPath(List<? extends RdUserFocusNode> nodes, Component rootComponent) {
        Component component = rootComponent;
        for (RdUserFocusNode rdUserFocusNode : nodes) {
            UserFocusHandler<RdUserFocusNode, Component> handler;
            if (this.findFocusHandler(rdUserFocusNode) == null) {
                return;
            }
            Component targetComponent = this.findComponentFor(handler, component);
            if (targetComponent != null) {
                if (handler.follow(targetComponent, rdUserFocusNode, true) != null) continue;
                return;
            }
            if (handler.isOptional()) continue;
            return;
        }
    }

    private final UserFocusHandler<RdUserFocusNode, Component> findFocusHandler(RdUserFocusNode node) {
        return (UserFocusHandler)UserFocusHandlerRegistry.Companion.getInstance().forClass(node.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private final UserFocusHandler<RdUserFocusNode, Component> findFocusHandler(Component component) {
        Object v2;
        block2: {
            void $this$mapTo$iv$iv;
            ExtensionPoint extensionPoint = UserFocusHandlerRegistry.Companion.getInstance().getPoint();
            Intrinsics.checkNotNull((Object)extensionPoint);
            List list = extensionPoint.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExtensionList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KeyedLazyInstance keyedLazyInstance = (KeyedLazyInstance)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((UserFocusHandler)it.getInstance());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                UserFocusHandler it = (UserFocusHandler)e;
                boolean bl = false;
                if (!it.acceptComponent(component)) continue;
                v2 = e;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final Component findComponentFor(UserFocusHandler<?, ?> handler, Component component) {
        return (Component)((JBTreeTraverser)UIUtil.uiTraverser((Component)component).expandAndFilter(arg_0 -> UserFocusManager.findComponentFor$lambda$0(findComponentFor.1.INSTANCE, arg_0))).bfsTraversal().find(arg_0 -> UserFocusManager.findComponentFor$lambda$2(arg_0 -> UserFocusManager.findComponentFor$lambda$1(handler, arg_0), arg_0));
    }

    private static final void _init_$lambda$0(UserFocusManager this$0, PropertyChangeEvent it) {
        this$0.queue.queue(Update.Companion.create((Object)"update", () -> UserFocusManager.lambda$0$0(this$0)));
    }

    private static final void lambda$0$0(UserFocusManager this$0) {
        this$0.updateCurrentFocus();
    }

    private static final Unit _init_$lambda$1(KeyboardFocusManager $keyboardFocusManager, PropertyChangeListener $focusListener) {
        $keyboardFocusManager.removePropertyChangeListener("focusOwner", $focusListener);
        $keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", $focusListener);
        return Unit.INSTANCE;
    }

    private static final Unit highlightFocus$lambda$0(UserFocusManager this$0, RdToolWindowFocusLocation $userFocus, Component rootComponent) {
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        this$0.followNodesPath($userFocus.getPath(), rootComponent);
        return Unit.INSTANCE;
    }

    private static final boolean findComponentFor$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findComponentFor$lambda$1(UserFocusHandler $handler, Component it) {
        Intrinsics.checkNotNull((Object)it);
        return $handler.acceptComponent(it);
    }

    private static final boolean findComponentFor$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.split"})
    @SourceDebugExtension(value={"SMAP\nUserFocusManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserFocusManager.kt\ncom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,217:1\n30#2,2:218\n*S KotlinDebug\n*F\n+ 1 UserFocusManager.kt\ncom/jetbrains/rd/platform/codeWithMe/focus/UserFocusManager$Companion\n*L\n30#1:218,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UserFocusManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UserFocusManager> serviceClass$iv = UserFocusManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UserFocusManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

