/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/testing/JsTestConfigurationUtil;", "", "<init>", "()V", "validatePath", "", "shouldBeDirectory", "", "pathLabelName", "", "path", "writeValue", "element", "Lorg/jdom/Element;", "tagName", "value", "readValue", "key", "intellij.javascript.backend"})
public final class JsTestConfigurationUtil {
    @NotNull
    public static final JsTestConfigurationUtil INSTANCE = new JsTestConfigurationUtil();

    private JsTestConfigurationUtil() {
    }

    public final void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path2) throws RuntimeConfigurationException {
        boolean exists;
        Intrinsics.checkNotNullParameter((Object)pathLabelName, (String)"pathLabelName");
        Object[] objectArray = (Object[])path2;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            objectArray = new Object[]{pathLabelName};
            throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.unspecified", (Object[])objectArray));
        }
        File file = new File(path2);
        if (!file.isAbsolute()) {
            Object[] objectArray2 = new Object[]{pathLabelName};
            throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.no.such", (Object[])objectArray2));
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            Object[] objectArray3 = new Object[]{pathLabelName};
            throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.no.such", (Object[])objectArray3));
        }
    }

    public final void writeValue(@NotNull Element element2, @NotNull String tagName, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element2, (String)tagName, (String)value);
        }
    }

    @Nullable
    public final String readValue(@NotNull Element element2, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JDOMExternalizerUtil.readCustomField((Element)element2, (String)key);
    }
}

