/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.frameworks.flow.validation.FlowJSAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class FlowJSAnnotatorCheckerProviderImpl
implements FlowJSAnnotatorCheckerProvider {
    @Override
    public boolean isAvailable(@NotNull PsiElement context2) {
        PsiFile file;
        if (context2 == null) {
            FlowJSAnnotatorCheckerProviderImpl.$$$reportNull$$$0(0);
        }
        if ((file = context2.getContainingFile()) != null && file.getLanguage() == JavaScriptSupportLoader.FLOW_JS) {
            FlowJSServerService service = FlowJSServerManager.getService(file);
            return service != null && FlowJSAnnotation.hasFlowAnnotation((PsiFile)file);
        }
        return false;
    }

    @Override
    public void checkExecutablePath(@NotNull JSFile file, @NotNull AnnotationHolder holder) {
        FlowJSSettings.FlowJSExecutable flowExecutable;
        if (file == null) {
            FlowJSAnnotatorCheckerProviderImpl.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            FlowJSAnnotatorCheckerProviderImpl.$$$reportNull$$$0(2);
        }
        if ((flowExecutable = FlowJSSettingsManager.getFlowExecutable(file.getVirtualFile(), file.getProject())) == null) {
            return;
        }
        if (FlowJSConfigService.getService((Project)file.getProject()).getNearestConfig(file.getVirtualFile()) == null) {
            return;
        }
        VirtualFile executableFile = LocalFileSystem.getInstance().findFileByPath(flowExecutable.getPackageOrExePath());
        if (executableFile != null) {
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, JavaScriptBundle.message((String)"javascript.validation.message.flowjs.path", (Object[])new Object[0])).range((PsiElement)file).fileLevel().withFix((IntentionAction)new BaseIntentionAction(this){

            @NotNull
            public String getText() {
                String string = this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = JavaScriptBundle.message((String)"flow.js.show.settings", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"Settings.JavaScript", (String)"");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSAnnotatorCheckerProviderImpl$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSAnnotatorCheckerProviderImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSAnnotatorCheckerProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExecutablePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

