/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.JSReplaceImplementsExtendsKeyword;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.highlighting.JSAddTypeMembersByLiteralFix;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.inspections.AssignParameterToFieldAction;
import com.intellij.lang.javascript.inspections.DownloadLibraryQuickFix;
import com.intellij.lang.javascript.inspections.ES6CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.inspections.ES6MakeFunctionAsyncFix;
import com.intellij.lang.javascript.inspections.JSMoveToScopeStartIntentionAction;
import com.intellij.lang.javascript.inspections.JSRemoveElementLocalQuickFix;
import com.intellij.lang.javascript.inspections.JSReplaceForEachWithForOfFix;
import com.intellij.lang.javascript.inspections.JSSuppressByCommentFix;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.AddStaticAndReadonlyModifierFix;
import com.intellij.lang.javascript.validation.fixes.AddSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.CreateInheritanceFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionFromArgumentIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSParameterIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.ES6InsertAwaitFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureWithDelegationUpdateFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeTypeFix;
import com.intellij.lang.javascript.validation.fixes.JSCreateArgumentStubsFix;
import com.intellij.lang.javascript.validation.fixes.JSInitializeParameterFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertCastFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertModifierFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertPrimitiveWrapperFix;
import com.intellij.lang.javascript.validation.fixes.JSJoinDeclarationAndAssignmentFix;
import com.intellij.lang.javascript.validation.fixes.JSRemoveInitializerQuickFix;
import com.intellij.lang.javascript.validation.fixes.JSRemoveReadonlyModifierFix;
import com.intellij.lang.javascript.validation.fixes.JSSetElementVisibilityFix;
import com.intellij.lang.javascript.validation.fixes.MakeMethodStaticFix;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.lang.javascript.validation.fixes.RemoveUnusedAssignmentFix;
import com.intellij.lang.javascript.validation.fixes.RenameReferenceFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptAddGenericArgumentsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementAllMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptInsertTypeGuardFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptRemoveGenericArgumentsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptWrapWithGenericTypeFix;
import com.intellij.lang.typescript.inspection.MakeTypeScriptFieldReadonlyFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddFileToConfigFix;
import com.intellij.lang.typescript.intentions.TypeScriptChangeConstructorAccessRightsFix;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidatorImpl;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.fix.JSRenameFix;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSFixFactoryImpl
extends JSFixFactory {
    public static final Logger LOG = Logger.getInstance(JSFixFactoryImpl.class);
    private static final LocalQuickFixAndIntentionActionOnPsiElement EMPTY_FIX = new LocalQuickFixAndIntentionActionOnPsiElement(null){

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                2.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                2.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                2.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                2.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getFamilyName() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$2";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @Override
    public LocalQuickFix createImplementMembersFix(JSExpression expr, boolean requiredOnly) {
        if (DialectDetector.isTypeScript((PsiElement)expr)) {
            return new TypeScriptImplementAllMembersFix((PsiElement)expr, false, requiredOnly);
        }
        return null;
    }

    @Override
    @NotNull
    public ModCommandAction changeTypeFix(JSNamedElement var, String expressionType, String nameKey) {
        return new JSChangeTypeFix(var, expressionType, nameKey);
    }

    @Override
    @NotNull
    public LocalQuickFix changeSignatureFix(JSFunction element2, @Nullable JSArgumentList argumentList) {
        return new JSChangeSignatureFix(element2, argumentList, true);
    }

    @Override
    @NotNull
    public LocalQuickFix createArgumentStubsFix(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(0);
        }
        return new JSCreateArgumentStubsFix(callExpression);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction function, @NotNull Map<String, String> parameterTypeOverrides, @Nullable String overriddenReturnType) {
        if (parameterTypeOverrides == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(1);
        }
        JSChangeSignatureFix fix = new JSChangeSignatureFix(function, null, true, true);
        fix.setReturnType(overriddenReturnType);
        fix.setParameterTypes(parameterTypeOverrides);
        return fix;
    }

    @Override
    public LocalQuickFix createInheritanceFix(JSClass expectedClass, PsiElement actualClass) {
        return new CreateInheritanceFix(actualClass, expectedClass.getQualifiedName(), expectedClass.isInterface());
    }

    @Override
    @NotNull
    public ModCommandAction jsInsertCastFix(String type2, @NotNull JSExpression expression) {
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(2);
        }
        return new JSInsertCastFix(type2, expression);
    }

    @Override
    public LocalQuickFix jsInsertPrimitiveWrapperFix(String type2, @NotNull JSExpression expr) {
        if (expr == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(3);
        }
        return new JSInsertPrimitiveWrapperFix(type2, expr);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement removeUnusedAssignmentFix(PsiElement assignment, boolean allInDestructuring) {
        return new RemoveUnusedAssignmentFix(assignment, allInDestructuring);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement removeASTNodeFix(@NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String propKey, boolean fixNewLines, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (propKey == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(6);
        }
        return new RemoveASTNodeFix(propKey, fixNewLines, startElement, endElement);
    }

    @Override
    @NotNull
    public LocalQuickFix renameReferenceFix() {
        return new RenameReferenceFix();
    }

    @Override
    @NotNull
    public LocalQuickFix createJSVariableIntentionAction(String name, boolean field, boolean constant, boolean isModuleScope) {
        return new CreateJSVariableIntentionAction(name, field, constant, isModuleScope);
    }

    @Override
    @NotNull
    public LocalQuickFix createJSParameterIntentionAction(JSReferenceExpression referenceExpression, String referencedName) {
        return new CreateJSParameterIntentionAction(referenceExpression, referencedName);
    }

    @Override
    @NotNull
    public LocalQuickFix createJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope, boolean isAsync) {
        return new CreateJSFunctionIntentionAction(name, isMethod, isModuleScope, isAsync, false);
    }

    @Override
    @NotNull
    public LocalQuickFix createJSArrowFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope, boolean isAsync) {
        return new CreateJSFunctionIntentionAction(name, isMethod, isModuleScope, isAsync, true);
    }

    @Override
    @NotNull
    public LocalQuickFix createJSFunctionFromArgumentIntentionAction(String name, JSExpression qualifier, boolean ecma) {
        return new CreateJSFunctionFromArgumentIntentionAction(name, qualifier, ecma);
    }

    @Override
    @NotNull
    public LocalQuickFix createClassOrInterfaceFix(@NotNull PsiElement expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        PsiElement parent;
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(7);
        }
        TypeScriptTypeArgumentList arguments = (parent = expression.getParent()) instanceof TypeScriptTypeArgumentsListOwner ? ((TypeScriptTypeArgumentsListOwner)parent).getTypeArgumentList() : null;
        return new ES6CreateClassOrInterfaceFix(expression, isInterface, constructorArguments, arguments, expectedType);
    }

    @Override
    public IntentionAction addSuperInvocationFix(JSFunction constructor, @Nullable JSFunction superConstructor) {
        return new AddSuperInvocationFix(constructor, superConstructor);
    }

    @Override
    @NotNull
    public LocalQuickFix changeSignatureWithDelegationUpdateFix(JSFunction element2, @NotNull JSFunction functionToTakeParamsFrom, @NotNull JSCallExpression node) {
        if (functionToTakeParamsFrom == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(8);
        }
        if (node == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(9);
        }
        return new JSChangeSignatureWithDelegationUpdateFix(element2, functionToTakeParamsFrom, node);
    }

    @Override
    public LocalQuickFix makeMethodStaticFix() {
        return new MakeMethodStaticFix();
    }

    public AssignParameterToFieldAction assignParameterToFieldAction(@Nullable PsiElement element2, @Nullable String fieldNameToCreate, String fieldName, String parameterName, String className) {
        return new AssignParameterToFieldAction(element2, fieldNameToCreate, fieldName, parameterName, className);
    }

    @Override
    public LocalQuickFix downloadLibraryQuickFix() {
        return new DownloadLibraryQuickFix();
    }

    @Override
    public LocalQuickFix jsMoveToScopeStartIntentionAction(boolean statement) {
        return new JSMoveToScopeStartIntentionAction(statement);
    }

    @Override
    public FixAndIntentionAction removeElementLocalQuickFix(String elementDescription) {
        return new JSRemoveElementLocalQuickFix(elementDescription);
    }

    @Override
    public void addFixesForFields(JSFunction node, PsiElement highlightedElement, String name, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes) {
        PsiElement element2;
        if (fixes == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(10);
        }
        if ((element2 = JSResolveUtil.findParent((PsiElement)node)) instanceof JSClass) {
            AssignParameterToFieldAction intentionAction;
            String fieldName2;
            String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(node.isSetProperty() ? node.getName() : name, (PsiElement)node);
            String string = fieldName2 = node.isSetProperty() ? null : JSFormatterUtil.transformVarNameToAccessorName((String)name, (PsiElement)node);
            if (StringUtil.equals((CharSequence)fieldName, (CharSequence)fieldName2)) {
                fieldName2 = null;
            }
            String className = ((JSClass)element2).getName();
            boolean noField = ((JSClass)element2).findFieldByName(fieldName) == null;
            String existingField = fieldName;
            if (noField && fieldName2 != null) {
                noField = ((JSClass)element2).findFieldByName(fieldName2) == null;
                existingField = fieldName2;
            }
            String fieldNameToCreate = null;
            if (noField) {
                if (fieldName2 != null) {
                    fieldNameToCreate = fieldName2;
                    intentionAction = this.assignParameterToFieldAction(highlightedElement, fieldNameToCreate, fieldName2, name, className);
                    fixes.add((LocalQuickFix)intentionAction);
                }
                fieldNameToCreate = fieldName;
            }
            intentionAction = this.assignParameterToFieldAction(highlightedElement, fieldNameToCreate, noField ? fieldName : existingField, name, className);
            fixes.add((LocalQuickFix)intentionAction);
        }
    }

    @Override
    public LocalQuickFix typeScriptImplementMembersFix(JSClass aClass, boolean requiredOnly) {
        return new TypeScriptImplementAllMembersFix((PsiElement)aClass, false, requiredOnly);
    }

    @Override
    public LocalQuickFix typeScriptImplementMembersAbstractFix(JSClass aClass) {
        return new TypeScriptImplementAllMembersFix((PsiElement)aClass, true, false);
    }

    @Override
    @NotNull
    public LocalQuickFix createInsertTypeGuardFix(@NotNull PsiElement element2, @NotNull JSType type2, @NotNull TypeScriptTypeGuardFixHelper.JSTypeGuardFixData data2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(11);
        }
        if (type2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(12);
        }
        if (data2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(13);
        }
        return new TypeScriptInsertTypeGuardFix(element2, type2, data2);
    }

    @Override
    public InspectionJSFix renameFix() {
        return new JSRenameFix();
    }

    @Override
    @NotNull
    public ModCommandAction replaceImplementsKeywordByExtendsFix(@NotNull JSReferenceList referenceList) {
        if (referenceList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(14);
        }
        return new JSReplaceImplementsExtendsKeyword(referenceList);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull LocalQuickFix> createAddTypeMembersByLiteralFixes(JSObjectLiteralExpression initializerLiteral, List<String> namesToAdd) {
        PsiElement parent = initializerLiteral.getParent();
        if (!(parent instanceof JSVariable)) {
            List<LocalQuickFix> list = List.of();
            if (list == null) {
                JSFixFactoryImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        JSVariable jsVariable = (JSVariable)parent;
        List<JSClass> jsClasses = JSAddTypeMembersByLiteralFix.getJSClasses(jsVariable);
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(jsClasses.size());
        for (int i = 0; i < jsClasses.size(); ++i) {
            JSClass clazz = jsClasses.get(i);
            fixes.add(LocalQuickFix.from((ModCommandAction)new JSAddTypeMembersByLiteralFix(initializerLiteral, namesToAdd, clazz.getName(), i)));
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull LocalQuickFix> typeScriptConfigFixes(JSElement placeExpression, PsiElement resolveResult) {
        List<LocalQuickFix> list = List.of(new TypeScriptAddFileToConfigFix(placeExpression, resolveResult));
        if (list == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    @NotNull
    public TypeScriptReferencePathValidator typeScriptReferencePathValidator() {
        TypeScriptReferencePathValidator typeScriptReferencePathValidator = TypeScriptReferencePathValidatorImpl.INSTANCE;
        if (typeScriptReferencePathValidator == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(18);
        }
        return typeScriptReferencePathValidator;
    }

    @Override
    @NotNull
    public ModCommandAction createChangeVisibilityFix(@NotNull JSAttributeListOwner method, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (method == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(19);
        }
        return new JSSetElementVisibilityFix(method, visibility, namespace);
    }

    @Override
    @NotNull
    public ModCommandAction insertModifier(@NotNull JSAttributeListOwner method, @NotNull JSAttributeList.ModifierType modifier) {
        if (method == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(20);
        }
        if (modifier == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(21);
        }
        return new JSInsertModifierFix(method, modifier);
    }

    @Override
    @NotNull
    public SuppressQuickFix suppressByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends JSSuppressionHolder> holderClass, @NotNull @IntentionName String text) {
        if (key == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(22);
        }
        if (holderClass == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(23);
        }
        if (text == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(24);
        }
        return new JSSuppressByCommentFix(key, holderClass, text);
    }

    @Override
    @NotNull
    public LocalQuickFix createConstructorFix(@NotNull JSCallExpression callExpression, @NotNull JSClass targetClass) {
        DialectOptionHolder holder;
        if (callExpression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(25);
        }
        if (targetClass == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(26);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)callExpression)) == null) {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement = EMPTY_FIX;
            if (localQuickFixAndIntentionActionOnPsiElement == null) {
                JSFixFactoryImpl.$$$reportNull$$$0(27);
            }
            return localQuickFixAndIntentionActionOnPsiElement;
        }
        return new ES6CreateConstructorFix(callExpression, targetClass);
    }

    @Override
    public LocalQuickFix insertUseStrict(@NotNull JSExecutionScope executionScope) {
        if (executionScope == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(28);
        }
        return new LocalQuickFixOnPsiElement(this, (PsiElement)executionScope){

            @NotNull
            public String getFamilyName() {
                String string = JavaScriptBundle.message((String)"js.strict.mode.inspection.fix", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getText() {
                String string = this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (psiFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (startElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                String quote = JSCodeStyleSettings.getQuote((PsiElement)startElement);
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)startElement);
                String useStrictStmt = quote + "use strict" + quote + semicolon + "\n";
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                assert (document != null);
                document.insertString(startElement.getTextOffset(), (CharSequence)useStrictStmt);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4, 5 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3, 4, 5 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    public LocalQuickFix implementJSDocMethodsFix(@NotNull String className, @NotNull Map<JSMethodToImplement.MethodKey, JSMethodToImplement> methods) {
        if (className == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(29);
        }
        if (methods == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(30);
        }
        return new ImplementJSDocMethodsFix(className, methods);
    }

    @Override
    @NotNull
    public LocalQuickFix removeInitializerFix() {
        return new JSRemoveInitializerQuickFix();
    }

    @Override
    @NotNull
    public LocalQuickFix changeConstructorAccessRightsFix(@NotNull JSFunction node, @NotNull JSAttributeList.AccessType accessType) {
        if (node == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(31);
        }
        if (accessType == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(32);
        }
        return new TypeScriptChangeConstructorAccessRightsFix(node, accessType);
    }

    @Override
    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMakeFunctionAsyncFix(@NotNull JSFunction function) {
        if (function == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(33);
        }
        return new ES6MakeFunctionAsyncFix(function);
    }

    @Override
    public LocalQuickFix createForEachToForOfFix() {
        return new JSReplaceForEachWithForOfFix();
    }

    @Override
    @NotNull
    public ModCommandAction createInitializeParameterFix(JSParameterListElement parameter, String value) {
        return new JSInitializeParameterFix(parameter, value);
    }

    @Override
    public LocalQuickFix createJoinDeclarationAndAssignmentFix(JSVariable node, JSReferenceExpression expression) {
        if (node.getContainingFile() != expression.getContainingFile()) {
            LOG.error("Must not be in different files: " + String.valueOf(node) + ", " + String.valueOf(expression));
            return null;
        }
        return new JSJoinDeclarationAndAssignmentFix(node, expression);
    }

    @Override
    public LocalQuickFix createInsertAwaitFix(JSExpression expression, boolean isAsyncGenerator) {
        return new ES6InsertAwaitFix(expression, isAsyncGenerator);
    }

    @Override
    public LocalQuickFix createWrapWithGenericTypeFix(@NotNull String className, @NotNull TypeScriptType element2) {
        if (className == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(34);
        }
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(35);
        }
        return new TypeScriptWrapWithGenericTypeFix(className, element2);
    }

    @Override
    @NotNull
    public LocalQuickFix addGenericArgumentFix(@NotNull TypeScriptTypeArgumentsListOwner element2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(36);
        }
        return new TypeScriptAddGenericArgumentsFix(element2);
    }

    @Override
    @NotNull
    public LocalQuickFix removeGenericArgumentFix(@NotNull JSElement element2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(37);
        }
        return new TypeScriptRemoveGenericArgumentsFix(element2);
    }

    @Override
    @NotNull
    public LocalQuickFix removeReadonlyModifierFix(@NotNull JSAttributeListOwner element2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(38);
        }
        return new JSRemoveReadonlyModifierFix(element2);
    }

    @Override
    public boolean isShowSmartCastText() {
        return !EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement();
    }

    @Override
    public IntentionAction addStaticAndReadonlyModifier(@NotNull JSAttributeListOwner element2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(39);
        }
        return new AddStaticAndReadonlyModifierFix((PsiElement)element2);
    }

    @Override
    public IntentionAction convertVarOrLetToConst(@NotNull JSVarStatement element2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(40);
        }
        return new ES6ConvertVarToLetConstQuickFix(element2).forceVariant(true);
    }

    @Override
    public IntentionAction addReadonlyModifierFix(@NotNull TypeScriptPropertySignature element2) {
        if (element2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(41);
        }
        return new MakeTypeScriptFieldReadonlyFix((PsiElement)element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 18, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeOverrides";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionToTakeParamsFrom";
                break;
            }
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 11: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holderClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionScope";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddTypeMembersByLiteralFixes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptConfigFixes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptReferencePathValidator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentStubsFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureFix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jsInsertCastFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "jsInsertPrimitiveWrapperFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeASTNodeFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClassOrInterfaceFix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureWithDelegationUpdateFix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFixesForFields";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInsertTypeGuardFix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplementsKeywordByExtendsFix";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createChangeVisibilityFix";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertModifier";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "suppressByCommentFix";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorFix";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "insertUseStrict";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "implementJSDocMethodsFix";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "changeConstructorAccessRightsFix";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createMakeFunctionAsyncFix";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createWrapWithGenericTypeFix";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentFix";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeGenericArgumentFix";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeReadonlyModifierFix";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addStaticAndReadonlyModifier";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "convertVarOrLetToConst";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addReadonlyModifierFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 18, 27 -> new IllegalStateException(string);
        };
    }
}

