/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCreateAccessorIntentionBase
extends PsiElementBaseIntentionAction {
    public JSCreateAccessorIntentionBase() {
        this.setText(this.getDescription());
    }

    @NotNull
    @IntentionName
    protected abstract String getDescription();

    protected abstract String getMessageKey();

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        String varName;
        PsiLanguageInjectionHost context2;
        PsiElement parentParent;
        DialectOptionHolder dialectOfElement;
        if (project == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(2);
        }
        if (!this.isAvailableForDialect(dialectOfElement = DialectDetector.dialectOfElement((PsiElement)element2))) {
            return false;
        }
        if (DialectOptionHolder.JS_WITH_JSX.equals(dialectOfElement) && this.tryConstructorPropertyVariant(element2) != null) {
            return true;
        }
        JSVariable variable = JSCreateAccessorIntentionBase.getVariable(element2);
        if (variable != null && variable.isConst()) {
            return false;
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)variable, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.ABSTRACT) || JSPsiImplUtils.hasModifier((JSAttributeListOwner)variable, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.OVERRIDE)) {
            return false;
        }
        PsiElement parent = variable == null ? null : variable.getParent();
        PsiElement psiElement = parentParent = parent instanceof JSVarStatement ? parent.getParent() : null;
        if (parentParent instanceof ES6Class && parent instanceof JSVarStatementBase) {
            return false;
        }
        if (parentParent instanceof TypeScriptEnum) {
            return false;
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = context2 = parentParent == null ? null : InjectedLanguageManager.getInstance((Project)parentParent.getProject()).getInjectionHost(parentParent);
        JSClass jsClass = parentParent instanceof JSClass ? (JSClass)parentParent : (parentParent instanceof JSFile && context2 instanceof XmlText ? XmlBackedJSClassImpl.getContainingComponent((XmlElement)((XmlText)context2)) : null);
        String string = varName = variable == null ? null : variable.getName();
        if (jsClass != null && StringUtil.isNotEmpty((String)varName)) {
            this.setText(JavaScriptBundle.message((String)this.getMessageKey(), (Object[])new Object[]{varName}));
            String accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)varName, (PsiElement)variable);
            return this.isAvailableFor(jsClass, accessorName);
        }
        return false;
    }

    protected boolean isAvailableForDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && !dialectOfElement.isECMA4;
    }

    private JSDefinitionExpression tryConstructorPropertyVariant(@NotNull PsiElement element2) {
        JSFunction constructor;
        JSReferenceExpression reference;
        PsiElement psiElement;
        if (element2 == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(3);
        }
        if ((psiElement = element2.getParent()) instanceof JSReferenceExpression && (reference = (JSReferenceExpression)psiElement).getQualifier() != null && "this".equals(reference.getQualifier().getText()) && (constructor = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)reference, JSFunction.class)) != null && "constructor".equals(constructor.getName()) && reference.getParent() instanceof JSDefinitionExpression && constructor.getParent() instanceof ES6Class) {
            String varName = reference.getReferenceName();
            this.setText(JavaScriptBundle.message((String)this.getMessageKey(), (Object[])new Object[]{varName}));
            String accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)varName, (PsiElement)element2);
            return this.isAvailableFor((JSClass)((ES6Class)constructor.getParent()), accessorName) ? (JSDefinitionExpression)reference.getParent() : null;
        }
        return null;
    }

    @Nullable
    private static JSVariable getVariable(PsiElement element2) {
        JSVariable variable = JavaScriptIntention.findParentVariable(element2, JSVariable.class);
        if (variable == null) {
            return null;
        }
        JSVarStatement statement = variable.getStatement();
        return statement != null && statement.getVariables().length == 1 ? variable : null;
    }

    protected abstract boolean isAvailableFor(JSClass var1, String var2);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        PsiFile file;
        PsiElement jsClass;
        if (project == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(5);
        }
        if ((jsClass = BaseJSGenerateHandler.findClassOrObjectLiteral(file = element2.getContainingFile(), editor, null)) == null) {
            return;
        }
        final Ref node = new Ref();
        JavaScriptGenerateAccessorHandler handler = new JavaScriptGenerateAccessorHandler(this, this.getGenerationMode(), true){

            @Override
            protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
                ContainerUtil.addIfNotNull(candidates, (Object)((Object)((JSNamedElementNode)((Object)node.get()))));
            }
        };
        JSVariable variable = JSCreateAccessorIntentionBase.getVariable(element2);
        if (variable == null) {
            JSDefinitionExpression expression;
            if (DialectOptionHolder.JS_WITH_JSX.equals(DialectDetector.dialectOfElement((PsiElement)element2)) && (expression = this.tryConstructorPropertyVariant(element2)) != null) {
                node.set((Object)new JSNamedElementNode((JSPsiNamedElementBase)expression));
            }
        } else {
            node.set((Object)new JSNamedElementNode((JSPsiNamedElementBase)variable));
        }
        handler.invoke(project, editor, file);
    }

    protected abstract JSGetterSetterGenerationMode getGenerationMode();

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryConstructorPropertyVariant";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

