/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.JSLinterReformatterTask;
import com.intellij.lang.javascript.linter.eslint.LinterExecutionException;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.LineSeparator;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintFixAction
extends JSLinterFixAction {
    public EsLintFixAction() {
        super(JavaScriptBundle.messagePointer((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), JavaScriptBundle.messagePointer((String)"eslint.action.fix.problems.description", (Object[])new Object[0]), JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    protected EsLintFixAction(@NotNull Supplier<String> message, @NotNull Supplier<String> description) {
        if (message == null) {
            EsLintFixAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            EsLintFixAction.$$$reportNull$$$0(1);
        }
        super(message, description, null);
    }

    @Override
    @NotNull
    protected JSLinterConfiguration getConfiguration(@NotNull Project project) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(2);
        }
        EslintConfiguration eslintConfiguration = EslintConfiguration.getInstance(project);
        if (eslintConfiguration == null) {
            EsLintFixAction.$$$reportNull$$$0(3);
        }
        return eslintConfiguration;
    }

    @Override
    protected boolean shouldSaveBeforeToolInvocation(@Nullable VirtualFile file) {
        return file != null && (EslintUtil.isFlatOrLegacyConfigFile(file) || PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)file));
    }

    @Override
    public boolean isFileAccepted(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            EsLintFixAction.$$$reportNull$$$0(5);
        }
        return (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null && EslintUtil.isPossiblyAcceptableFileType(psiFile);
    }

    @Override
    protected boolean needRefreshFilesAfter() {
        return false;
    }

    @Nullable
    public String fixFile(@NotNull PsiFile psiFile) throws LinterExecutionException {
        if (psiFile == null) {
            EsLintFixAction.$$$reportNull$$$0(6);
        }
        JSLinterInput input = (JSLinterInput)ReadAction.compute(() -> {
            EslintState state = (EslintState)EslintConfiguration.getInstance(psiFile.getProject()).getExtendedState().getState();
            return JSLinterInput.create(psiFile, state, null);
        });
        EslintLanguageServiceManager languageServiceManager = EslintLanguageServiceManager.getInstance(input.getProject());
        return languageServiceManager.useService(input.getVirtualFile(), ((EslintState)input.getState()).getNodePackageRef(), service -> {
            if (service == null) {
                return null;
            }
            return (String)service.useService(() -> EsLintExternalRunner.fixFile(input, service));
        });
    }

    @Override
    protected Task createTask(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filesToProcess, @NotNull Runnable completeCallback, boolean modalProgress) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(7);
        }
        if (filesToProcess == null) {
            EsLintFixAction.$$$reportNull$$$0(8);
        }
        if (completeCallback == null) {
            EsLintFixAction.$$$reportNull$$$0(9);
        }
        return new EsLintFixTask(project, filesToProcess, completeCallback).createTask(modalProgress);
    }

    @Override
    public boolean isEnabled(@NotNull Project project, VirtualFile @NotNull [] files) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(10);
        }
        if (files == null) {
            EsLintFixAction.$$$reportNull$$$0(11);
        }
        if (!super.isEnabled(project, files) || files.length == 0) {
            return false;
        }
        EslintState state = (EslintState)EslintConfiguration.getInstance(project).getExtendedState().getState();
        return EslintLanguageServiceManager.getInstance(project).useService(files[0], state.getNodePackageRef(), service -> service != null);
    }

    @RequiresWriteLock
    public static void applyResultText(@NotNull Project project, @NotNull Document document, @NotNull String resultText) {
        String newLineSeparatorString;
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(12);
        }
        if (document == null) {
            EsLintFixAction.$$$reportNull$$$0(13);
        }
        if (resultText == null) {
            EsLintFixAction.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertWriteAccess();
        String documentContent = StringUtil.convertLineSeparators((String)resultText);
        document.setText((CharSequence)documentContent);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return;
        }
        LineSeparator newLineSeparator = StringUtil.detectSeparators((CharSequence)resultText);
        String string = newLineSeparatorString = newLineSeparator != null ? newLineSeparator.getSeparatorString() : null;
        if (newLineSeparatorString != null && !StringUtil.equals((CharSequence)file.getDetectedLineSeparator(), (CharSequence)newLineSeparatorString)) {
            AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)file, (String)newLineSeparatorString);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyResultText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class EsLintFixTask
    extends JSLinterReformatterTask {
        private final List<EsLintResult> myResults;

        private EsLintFixTask(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filesToProcess, Runnable completeCallback) {
            if (project == null) {
                EsLintFixTask.$$$reportNull$$$0(0);
            }
            if (filesToProcess == null) {
                EsLintFixTask.$$$reportNull$$$0(1);
            }
            if (completeCallback == null) {
                EsLintFixTask.$$$reportNull$$$0(2);
            }
            super(project, JavaScriptBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), filesToProcess, completeCallback);
            this.myResults = new ArrayList<EsLintResult>(filesToProcess.size());
        }

        @Override
        protected void runLinter(@NotNull PsiFile psiFile, @NotNull Document document) {
            if (psiFile == null) {
                EsLintFixTask.$$$reportNull$$$0(3);
            }
            if (document == null) {
                EsLintFixTask.$$$reportNull$$$0(4);
            }
            long docModStamp = document.getModificationStamp();
            try {
                String result2 = EsLintFixAction.this.fixFile(psiFile);
                if (result2 != null) {
                    this.myResults.add(new EsLintResult(psiFile, docModStamp, result2));
                }
            }
            catch (LinterExecutionException e) {
                this.error(psiFile.getVirtualFile(), e.getAnnotation().getMessage(), new IntentionAction[0]);
            }
        }

        @Override
        protected void doOnSuccess() {
            for (EsLintResult result2 : this.myResults) {
                if (!result2.myPsiFile.isValid()) {
                    Logger.getInstance(((Object)((Object)EsLintFixAction.this)).getClass()).info("Can't apply 'eslint --fix' result because the file has become invalid: " + result2.myPsiFile.getName());
                    continue;
                }
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(result2.myPsiFile);
                if (document == null || document.getModificationStamp() != result2.myDocModStamp) {
                    Logger.getInstance(((Object)((Object)EsLintFixAction.this)).getClass()).info("Can't apply 'eslint --fix' result because the document was changed while running ESLint: " + result2.myPsiFile.getName());
                    continue;
                }
                String linterName = JavaScriptBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
                String commandName = JavaScriptBundle.message((String)"javascript.linter.action.fix.problems.name", (Object[])new Object[]{linterName});
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)commandName, null, () -> EsLintFixAction.applyResultText(this.myProject, document, result2.myResult), (PsiFile[])new PsiFile[0]);
            }
            super.doOnSuccess();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filesToProcess";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completeCallback";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction$EsLintFixTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runLinter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EsLintResult {
        @NotNull
        private final PsiFile myPsiFile;
        private final long myDocModStamp;
        @NotNull
        private final String myResult;

        /*
         * WARNING - void declaration
         */
        private EsLintResult(@NotNull PsiFile psiFile, long docModStamp, @NotNull String string) {
            void result2;
            if (psiFile == null) {
                EsLintResult.$$$reportNull$$$0(0);
            }
            if (string == null) {
                EsLintResult.$$$reportNull$$$0(1);
            }
            this.myPsiFile = psiFile;
            this.myDocModStamp = docModStamp;
            this.myResult = result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction$EsLintResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

