/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.remote;

import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesRegistry;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoteModule {
    private final String myUrl;
    private final VirtualFile myEntry;
    private final VirtualFile myRoot;
    private final Set<String> myDependencies;

    @Nullable
    public static JSRemoteModule fromModuleState(@NotNull JSRemoteModulesRegistry.JSRemoteModuleState moduleState) {
        if (moduleState == null) {
            JSRemoteModule.$$$reportNull$$$0(0);
        }
        if (!moduleState.isValid()) {
            return null;
        }
        VirtualFile entry = JSUrlImportsUtil.findFileByPath((String)moduleState.myEntry);
        if (entry == null || !entry.isValid()) {
            return null;
        }
        VirtualFile root = JSUrlImportsUtil.findFileByPath((String)moduleState.myRoot);
        if (root == null || !root.isValid()) {
            return null;
        }
        Set<String> dependencies = moduleState.myDependencies;
        return JSRemoteModule.create(moduleState.myUrl, entry, root, dependencies);
    }

    @Nullable
    public static JSRemoteModulesRegistry.JSRemoteModuleState toModuleState(@NotNull JSRemoteModule module) {
        if (module == null) {
            JSRemoteModule.$$$reportNull$$$0(1);
        }
        if (!module.isValid()) {
            return null;
        }
        return new JSRemoteModulesRegistry.JSRemoteModuleState(module.getUrl(), module.getEntry().getPath(), module.getRoot().getPath(), new HashSet<String>(module.getDependencies()));
    }

    @Nullable
    public static JSRemoteModule create(@NotNull String url, @NotNull VirtualFile entry, @NotNull VirtualFile root, @NotNull Set<String> dependencies) {
        if (url == null) {
            JSRemoteModule.$$$reportNull$$$0(2);
        }
        if (entry == null) {
            JSRemoteModule.$$$reportNull$$$0(3);
        }
        if (root == null) {
            JSRemoteModule.$$$reportNull$$$0(4);
        }
        if (dependencies == null) {
            JSRemoteModule.$$$reportNull$$$0(5);
        }
        if (!entry.isValid() || !root.isValid()) {
            return null;
        }
        return new JSRemoteModule(url, entry, root, dependencies);
    }

    private JSRemoteModule(@NotNull String url, @NotNull VirtualFile entry, @NotNull VirtualFile root, @NotNull Set<String> dependencies) {
        if (url == null) {
            JSRemoteModule.$$$reportNull$$$0(6);
        }
        if (entry == null) {
            JSRemoteModule.$$$reportNull$$$0(7);
        }
        if (root == null) {
            JSRemoteModule.$$$reportNull$$$0(8);
        }
        if (dependencies == null) {
            JSRemoteModule.$$$reportNull$$$0(9);
        }
        this.myUrl = url;
        this.myEntry = entry;
        this.myRoot = root;
        this.myDependencies = Set.copyOf(dependencies);
    }

    @NotNull
    @NlsSafe
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            JSRemoteModule.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public VirtualFile getEntry() {
        VirtualFile virtualFile = this.myEntry;
        if (virtualFile == null) {
            JSRemoteModule.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            JSRemoteModule.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @NotNull
    public Set<String> getDependencies() {
        Set<String> set = this.myDependencies;
        if (set == null) {
            JSRemoteModule.$$$reportNull$$$0(13);
        }
        return set;
    }

    public boolean isValid() {
        return this.myEntry.isValid() && this.myRoot.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSRemoteModule module = (JSRemoteModule)o;
        return Objects.equals(this.myUrl, module.myUrl) && Objects.equals(this.myEntry, module.myEntry) && Objects.equals(this.myRoot, module.myRoot) && Objects.equals(this.myDependencies, module.myDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.myUrl, this.myEntry, this.myRoot, this.myDependencies);
    }

    public String toString() {
        return "JSRemoteModule{myUrl='" + this.myUrl + "', myEntry=" + String.valueOf(this.myEntry) + ", myRoot=" + String.valueOf(this.myRoot) + ", myDependencies=" + String.valueOf(this.myDependencies) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromModuleState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toModuleState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

