/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSBasicGutterIconNavigationHandler;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSGotoTargetRendererProvider;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JavaScriptGotoSuperHandler
implements LanguageCodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Collection declarations;
        JSExpression rOperand;
        PsiElement parent;
        PsiElement at;
        if (project == null) {
            JavaScriptGotoSuperHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaScriptGotoSuperHandler.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            JavaScriptGotoSuperHandler.$$$reportNull$$$0(2);
        }
        if ((at = psiFile.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return;
        }
        JSNamedElement namedElement = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)at, JSNamedElement.class);
        PsiElement psiElement = parent = namedElement != null ? namedElement.getParent() : null;
        if (namedElement instanceof JSDefinitionExpression && parent instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)parent).getROperand()) instanceof JSFunctionExpression) {
            namedElement = (JSNamedElement)rOperand;
        }
        if (namedElement instanceof JSProperty) {
            JSProperty property = (JSProperty)namedElement;
            Pair pair = JSInheritanceUtil.findSuperMembersFromContextType((JSPsiElementBase)property);
            if (pair != null) {
                String name = new JSNamedElementPresenter((PsiElement)namedElement, Capitalization.EachWordUpperCase).describeWithShortName();
                List<JSPsiElementBase> supers = Collections.singletonList((JSPsiElementBase)pair.getSecond());
                boolean isMethod = property instanceof JSFunctionProperty || property.getValue() instanceof JSFunctionExpression;
                JavaScriptGotoSuperHandler.doNavigate(supers, JavaScriptBundle.message((String)(isMethod ? "choose.super.method" : "choose.super.function"), (Object[])new Object[]{name, supers.size()}), editor);
            }
        } else if (namedElement instanceof JSField) {
            JavaScriptGotoSuperHandler.handleField(editor, (JSField)namedElement);
        } else if (namedElement instanceof JSFunction) {
            JSFunction function = (JSFunction)namedElement;
            Collection methods = JavaScriptGotoSuperHandler.getSuperMembers((JSQualifiedNamedElement)function);
            String qName = function.getQualifiedName();
            if (function instanceof JSFunctionExpression) {
                JSQualifiedNamedElement element2 = JSPsiImplUtils.getInitializedElement((JSExpression)((JSFunctionExpression)function));
                if (element2 instanceof JSField && JSClassUtils.isES6ClassImplementation((PsiElement)namedElement)) {
                    JavaScriptGotoSuperHandler.handleField(editor, (JSField)element2);
                    return;
                }
                if (element2 instanceof JSDefinitionExpression) {
                    qName = ((JSDefinitionExpression)element2).getExpression().getText();
                }
            }
            if (methods.isEmpty() && qName != null && qName.equals(JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)function))) {
                methods = JSTypeEvaluateManager.findNearestExtendedJSTypes((JSPsiElementBase)function, (String)qName);
            }
            String name = new JSNamedElementPresenter((PsiElement)function, Capitalization.EachWordUpperCase).describeWithShortName();
            boolean isMethod = JSUtils.getMemberContainingClass((PsiElement)namedElement) != null;
            JavaScriptGotoSuperHandler.doNavigate(methods, JavaScriptBundle.message((String)(isMethod ? "choose.super.method" : "choose.super.function"), (Object[])new Object[]{name, methods.size()}), editor);
        } else if (namedElement instanceof JSClass) {
            JSClass jsClass = (JSClass)namedElement;
            String name = new JSNamedElementPresenter((PsiElement)jsClass, Capitalization.EachWordUpperCase).describeWithShortName();
            JSClass[] supers = jsClass.getSupers();
            ArrayList<JSClass> results = new ArrayList<JSClass>(Arrays.asList(supers));
            String qName = jsClass.getQualifiedName();
            if (qName != null && DialectDetector.isJavaScript((PsiElement)jsClass)) {
                results.addAll(JSTypeEvaluateManager.findNearestExtendedJSTypes((JSPsiElementBase)jsClass, (String)qName));
            }
            JavaScriptGotoSuperHandler.doNavigate(results, JavaScriptBundle.message((String)"choose.super.classifier", (Object[])new Object[]{name, supers.length}), editor);
        }
        if (namedElement instanceof JSQualifiedNamedElement && !(declarations = TypeScriptDeclarationMappings.getInstance((Project)namedElement.getProject()).getDeclarationElements((PsiNamedElement)namedElement)).isEmpty()) {
            JavaScriptGotoSuperHandler.doNavigate(declarations, JavaScriptBundle.message((String)"choose.declaration.element", (Object[])new Object[0]), editor);
        }
    }

    private static void handleField(Editor editor, @NotNull JSField field) {
        if (field == null) {
            JavaScriptGotoSuperHandler.$$$reportNull$$$0(3);
        }
        Collection<? extends JSPsiElementBase> members = JavaScriptGotoSuperHandler.getSuperMembers((JSQualifiedNamedElement)field);
        String name = new JSNamedElementPresenter((PsiElement)field, Capitalization.EachWordUpperCase).describeWithShortName();
        JavaScriptGotoSuperHandler.doNavigate(members, JavaScriptBundle.message((String)"choose.super.field", (Object[])new Object[]{name, members.size()}), editor);
    }

    private static Collection<? extends JSPsiElementBase> getSuperMembers(@NotNull JSQualifiedNamedElement member) {
        Collection members;
        if (member == null) {
            JavaScriptGotoSuperHandler.$$$reportNull$$$0(4);
        }
        if ((members = JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)member, (boolean)(member instanceof JSFunction))).isEmpty()) {
            members = JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)member);
        }
        return members;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return true;
    }

    private static void doNavigate(Collection<? extends JSPsiNamedElementBase> items, @NlsContexts.PopupTitle String popupTitle, Editor e) {
        if (items.isEmpty()) {
            return;
        }
        JSGotoTargetRendererProvider.JSClassListCellRenderer renderer = new JSGotoTargetRendererProvider.JSClassListCellRenderer();
        items = JSBasicGutterIconNavigationHandler.sort(items, renderer);
        PsiElementListNavigator.openTargets((Editor)e, (NavigatablePsiElement[])items.toArray(new JSPsiNamedElementBase[0]), (String)popupTitle, null, (ListCellRenderer)((Object)renderer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/navigation/JavaScriptGotoSuperHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperMembers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

