/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSElementIndexingDataImpl
implements JSElementIndexingData {
    @Nullable
    private Collection<JSImplicitElement> myElements;
    @Nullable
    private Collection<Pair<String, String>> myTypedefs;
    @Nullable
    private Collection<Pair<String, String>> myBaseTypes;
    private boolean myIsClassExplicitly;
    private boolean myIsInterfaceExplicitly;
    private boolean myAddUnderlyingElementToSymbolIndex;
    private Map<String, String> myUserStrings;

    public JSElementIndexingDataImpl() {
    }

    public JSElementIndexingDataImpl(@NotNull JSElementIndexingDataStructure structure, @Nullable PsiElement provider) {
        if (structure == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(0);
        }
        Collection elements = structure.getImplicitElementStructures();
        this.myElements = elements == null ? null : ContainerUtil.map((Collection)elements, s -> s.toImplicitElement(provider));
        this.myTypedefs = structure.getTypedefs();
        this.myBaseTypes = structure.getBaseTypes();
        this.myIsClassExplicitly = structure.isClassExplicitly();
        this.myIsInterfaceExplicitly = structure.isInterfaceExplicitly();
        this.myUserStrings = structure.getUserStrings();
    }

    public void addImplicitElement(@NotNull JSImplicitElement element2) {
        if (element2 == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(1);
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.add(element2);
    }

    public void addImplicitElements(@NotNull Collection<JSImplicitElement> elements) {
        if (elements == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(2);
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.addAll(elements);
    }

    @Nullable
    public Collection<JSImplicitElement> getImplicitElements() {
        return this.myElements;
    }

    public void setImplicitElements(@Nullable Collection<JSImplicitElement> elements) {
        this.myElements = elements;
    }

    public void addAccessorsFromObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(3);
        }
        JSSymbolUtil.forEachIdentifierProperty((JSObjectLiteralExpression)objectLiteral, (JSSymbolUtil.PropertyProcessor)new JSSymbolUtil.PropertyProcessor(){

            public void process(String titleCasedPropName, JSProperty property) {
                JSImplicitElementImpl.Builder getterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName((String)titleCasedPropName), (PsiElement)property).setProperties(new JSImplicitElement.Property[]{JSImplicitElement.Property.GetFunction}).setNamespaceExplicitlyDeclared(false);
                JSElementIndexingDataImpl.this.addImplicitElement((JSImplicitElement)getterBuilder.toImplicitElement());
                JSImplicitElementImpl.Builder setterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName((String)titleCasedPropName), (PsiElement)property).setProperties(new JSImplicitElement.Property[]{JSImplicitElement.Property.SetFunction}).setNamespaceExplicitlyDeclared(false);
                JSElementIndexingDataImpl.this.addImplicitElement((JSImplicitElement)setterBuilder.toImplicitElement());
            }
        });
    }

    @Nullable
    public Collection<Pair<String, String>> getTypedefs() {
        return this.myTypedefs;
    }

    public void addTypedef(@NotNull String name, @NotNull String typeText) {
        if (name == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(4);
        }
        if (typeText == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(5);
        }
        if (this.myTypedefs == null) {
            this.myTypedefs = new SmartList();
        }
        this.myTypedefs.add((Pair<String, String>)Pair.create((Object)name, (Object)typeText));
    }

    @Nullable
    public Collection<Pair<String, String>> getBaseTypes() {
        return this.myBaseTypes;
    }

    public void addBaseType(@NotNull String qualifiedName, @NotNull String baseType) {
        if (qualifiedName == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(6);
        }
        if (baseType == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(7);
        }
        if (this.myBaseTypes == null) {
            this.myBaseTypes = new SmartList();
        }
        this.myBaseTypes.add((Pair<String, String>)Pair.create((Object)qualifiedName, (Object)baseType));
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public void setIsClassExplicitly() {
        this.myIsClassExplicitly = true;
    }

    public boolean isInterfaceExplicitly() {
        return this.myIsInterfaceExplicitly;
    }

    public void setIsInterfaceExplicitly() {
        this.myIsInterfaceExplicitly = true;
    }

    @Nullable
    public Map<String, String> getUserStrings() {
        return this.myUserStrings;
    }

    public void putUserString(@NotNull String key, @NotNull String value) {
        if (key == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(8);
        }
        if (value == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(9);
        }
        if (this.myUserStrings == null) {
            this.myUserStrings = new HashMap<String, String>();
        }
        this.myUserStrings.put(key, value);
    }

    public boolean isEmpty() {
        boolean hasUserStrings;
        boolean hasBaseTypes;
        boolean hasTypedefs;
        boolean hasImplicitElements;
        boolean bl = hasImplicitElements = this.getImplicitElements() != null && !this.getImplicitElements().isEmpty();
        if (hasImplicitElements) {
            return false;
        }
        boolean bl2 = hasTypedefs = this.getTypedefs() != null && !this.getTypedefs().isEmpty();
        if (hasTypedefs) {
            return false;
        }
        boolean bl3 = hasBaseTypes = this.getBaseTypes() != null && !this.getBaseTypes().isEmpty();
        if (hasBaseTypes) {
            return false;
        }
        boolean bl4 = hasUserStrings = this.getUserStrings() != null && !this.getUserStrings().isEmpty();
        if (hasUserStrings) {
            return false;
        }
        return !this.isInterfaceExplicitly() && !this.isClassExplicitly();
    }

    public JSElementIndexingDataStructureImpl toStructure() {
        List elements = this.myElements != null ? this.myElements.stream().filter(el -> el instanceof JSIndexableImplicitElement).map(el -> (JSIndexableImplicitElement)el).map(JSIndexableImplicitElement::getStructure).collect(Collectors.toList()) : null;
        return new JSElementIndexingDataStructureImpl(elements, this.myTypedefs, this.myBaseTypes, this.myIsClassExplicitly, this.myIsInterfaceExplicitly, this.myUserStrings);
    }

    public void setAddUnderlyingElementToSymbolIndex(boolean addUnderlyingElementToSymbolIndex) {
        this.myAddUnderlyingElementToSymbolIndex = addUnderlyingElementToSymbolIndex;
    }

    public boolean addUnderlyingElementToSymbolIndex() {
        return this.myAddUnderlyingElementToSymbolIndex;
    }

    public @Unmodifiable @NotNull List<JSImplicitElement> findElementsByQualifiedName(@NotNull String qualifiedName) {
        Collection<JSImplicitElement> implicitElements;
        if (qualifiedName == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(10);
        }
        if ((implicitElements = this.getImplicitElements()) == null || implicitElements.isEmpty()) {
            List<JSImplicitElement> list = Collections.emptyList();
            if (list == null) {
                JSElementIndexingDataImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = ContainerUtil.filter(implicitElements, e -> qualifiedName.equals(e.getQualifiedName()));
        if (list == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    public @Unmodifiable @NotNull List<JSImplicitElement> findElementsByNameOrQName(@NotNull String qName) {
        Collection<JSImplicitElement> implicitElements;
        if (qName == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(13);
        }
        if ((implicitElements = this.getImplicitElements()) == null || implicitElements.isEmpty()) {
            List<JSImplicitElement> list = Collections.emptyList();
            if (list == null) {
                JSElementIndexingDataImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = ContainerUtil.filter(implicitElements, implicitElement -> qName.equals(implicitElement.getName()) || qName.equals(implicitElement.getQualifiedName()));
        if (list == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQualifiedName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByNameOrQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAccessorsFromObjectLiteral";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTypedef";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBaseType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putUserString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQualifiedName";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByNameOrQName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 14, 15 -> new IllegalStateException(string);
        };
    }
}

