/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementProviderStub;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSElementIndexingDataStructureImpl
implements JSElementIndexingDataStructure {
    private static final BooleanStructureElement HAS_ELEMENTS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPEDEFS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_BASE_TYPES_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_CLASS_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_USER_STRINGS_FLAG = new BooleanStructureElement();
    private static final FlagsStructure OUR_FLAGS_STRUCTURE = new FlagsStructure(new FlagsStructureElement[]{HAS_ELEMENTS_FLAG, HAS_TYPEDEFS_FLAG, HAS_BASE_TYPES_FLAG, IS_CLASS_EXPLICITLY_FLAG, IS_INTERFACE_EXPLICITLY_FLAG, HAS_USER_STRINGS_FLAG});
    @Nullable
    private final Collection<? extends JSImplicitElementStructure> myElements;
    @Nullable
    private final Collection<Pair<String, String>> myTypedefs;
    @Nullable
    private final Collection<Pair<String, String>> myBaseTypes;
    private final boolean myIsClassExplicitly;
    private final boolean myIsInterfaceExplicitly;
    @Nullable
    private final Map<String, String> myUserStrings;

    public JSElementIndexingDataStructureImpl(@Nullable Collection<? extends JSImplicitElementStructure> elements, @Nullable Collection<Pair<String, String>> typedefs, @Nullable Collection<Pair<String, String>> baseTypes, boolean isClassExplicitly, boolean isInterfaceExplicitly, @Nullable Map<String, String> userStrings) {
        this.myElements = elements;
        this.myTypedefs = typedefs;
        this.myBaseTypes = baseTypes;
        this.myIsClassExplicitly = isClassExplicitly;
        this.myIsInterfaceExplicitly = isInterfaceExplicitly;
        this.myUserStrings = userStrings;
    }

    @Nullable
    public static JSElementIndexingDataStructureImpl deserialize(StubInputStream dataStream) throws IOException {
        byte flags = dataStream.readByte();
        Boolean hasElements = (Boolean)ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_ELEMENTS_FLAG, flags);
        Boolean hasTypedefs = (Boolean)ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_TYPEDEFS_FLAG, flags);
        Boolean hasBaseTypes = (Boolean)ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_BASE_TYPES_FLAG, flags);
        Boolean isClassExplicitly = (Boolean)ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)IS_CLASS_EXPLICITLY_FLAG, flags);
        Boolean isInterfaceExplicitly = (Boolean)ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)IS_INTERFACE_EXPLICITLY_FLAG, flags);
        Boolean hasUserStrings = (Boolean)ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_USER_STRINGS_FLAG, flags);
        if (!(hasElements.booleanValue() || hasTypedefs.booleanValue() || hasBaseTypes.booleanValue() || isClassExplicitly.booleanValue() || isInterfaceExplicitly.booleanValue() || hasUserStrings.booleanValue())) {
            return null;
        }
        SmartList elements = null;
        if (hasElements.booleanValue()) {
            int elementsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (elementsCount > 0);
            elements = new SmartList();
            for (int i = 0; i < elementsCount; ++i) {
                elements.add(JSImplicitElementStructureImpl.deserialize((DataInput)dataStream));
            }
        }
        SmartList typedefs = null;
        if (hasTypedefs.booleanValue()) {
            int typedefsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (typedefsCount > 0);
            typedefs = new SmartList();
            for (int i = 0; i < typedefsCount; ++i) {
                String typeName = dataStream.readNameString();
                String type2 = dataStream.readNameString();
                typedefs.add(Pair.create((Object)typeName, (Object)type2));
            }
        }
        SmartList baseTypes = null;
        if (hasBaseTypes.booleanValue()) {
            int baseTypesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (baseTypesCount > 0);
            baseTypes = new SmartList();
            for (int i = 0; i < baseTypesCount; ++i) {
                String classNameRef = dataStream.readNameString();
                String baseType = dataStream.readNameString();
                if (classNameRef == null || baseType == null) continue;
                baseTypes.add(Pair.create((Object)classNameRef, (Object)baseType));
            }
        }
        HashMap<String, String> userStrings = null;
        if (hasUserStrings.booleanValue()) {
            int userStringsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (userStringsCount > 0);
            userStrings = new HashMap<String, String>(userStringsCount);
            for (int i = 0; i < userStringsCount; ++i) {
                String keyRef = dataStream.readNameString();
                String valueRef = dataStream.readNameString();
                if (keyRef == null || valueRef == null) continue;
                userStrings.put(keyRef, valueRef);
            }
        }
        return new JSElementIndexingDataStructureImpl((Collection<? extends JSImplicitElementStructure>)elements, (Collection<Pair<String, String>>)typedefs, (Collection<Pair<String, String>>)baseTypes, isClassExplicitly, isInterfaceExplicitly, userStrings);
    }

    public static void serialize(@Nullable JSElementIndexingDataStructure indexingData, StubOutputStream dataStream) throws IOException {
        byte flags = 0;
        if (indexingData == null) {
            dataStream.writeByte((int)flags);
            return;
        }
        ByteFlagsSerializer s = ByteFlagsSerializer.INSTANCE;
        Collection elements = indexingData.getImplicitElementStructures();
        boolean hasImplicitElements = elements != null && !elements.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_ELEMENTS_FLAG, (Object)hasImplicitElements, flags);
        Collection typedefs = indexingData.getTypedefs();
        boolean hasTypedefs = typedefs != null && !typedefs.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_TYPEDEFS_FLAG, (Object)hasTypedefs, flags);
        Collection baseTypes = indexingData.getBaseTypes();
        boolean hasBaseTypes = baseTypes != null && !baseTypes.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_BASE_TYPES_FLAG, (Object)hasBaseTypes, flags);
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)IS_CLASS_EXPLICITLY_FLAG, (Object)indexingData.isClassExplicitly(), flags);
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)IS_INTERFACE_EXPLICITLY_FLAG, (Object)indexingData.isInterfaceExplicitly(), flags);
        Map userStrings = indexingData.getUserStrings();
        boolean hasUserStrings = userStrings != null && !userStrings.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, (FlagsStructureElement)HAS_USER_STRINGS_FLAG, (Object)hasUserStrings, flags);
        dataStream.writeByte((int)flags);
        if (hasImplicitElements) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)elements.size());
            for (JSImplicitElementStructure jSImplicitElementStructure : elements) {
                jSImplicitElementStructure.serialize((DataOutput)dataStream);
            }
        }
        if (hasTypedefs) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)typedefs.size());
            for (Pair pair : typedefs) {
                dataStream.writeName((String)pair.first);
                dataStream.writeName((String)pair.second);
            }
        }
        if (hasBaseTypes) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)baseTypes.size());
            for (Pair pair : baseTypes) {
                dataStream.writeName((String)pair.first);
                dataStream.writeName((String)pair.second);
            }
        }
        if (hasUserStrings) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)userStrings.size());
            for (Map.Entry entry : userStrings.entrySet()) {
                dataStream.writeName((String)entry.getKey());
                dataStream.writeName((String)entry.getValue());
            }
        }
    }

    public static void index(@NotNull JSImplicitElementProviderStub<?> stub, @NotNull IndexSink sink) {
        Collection baseTypes;
        Collection typedefs;
        JSElementIndexingDataStructure data2;
        if (stub == null) {
            JSElementIndexingDataStructureImpl.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            JSElementIndexingDataStructureImpl.$$$reportNull$$$0(1);
        }
        if ((data2 = stub.getIndexingDataStructure()) == null) {
            return;
        }
        Collection elements = data2.getImplicitElementStructures();
        if (elements != null) {
            HashSet<String> indexedNamespaces = null;
            for (JSImplicitElementStructure element2 : elements) {
                String qNameForIndexing;
                JSElementBase.ClassOrInterface classOrInterface;
                if (JSElementIndexingDataStructureImpl.indexImplicitElement(element2, sink)) continue;
                String elementName = element2.getName();
                sink.occurrence(JSIndexKeys.JS_SYMBOL_INDEX_2_KEY, (Object)elementName);
                if (JSQualifiedObjectStubBase.doIndexGlobalSymbol((JSElementBase)element2)) {
                    sink.occurrence(JSIndexKeys.JS_GLOBAL_SYMBOL_INDEX_KEY, (Object)elementName);
                }
                if (!element2.isNamespaceExplicitlyDeclared() || !BaseJSSymbolProcessor.isGlobalNS((JSNamespace)element2.getJSNamespace(), (boolean)false, (boolean)false)) {
                    sink.occurrence(JSIndexKeys.JS_NON_GLOBAL_SYMBOL_INDEX_KEY, (Object)elementName);
                }
                if ((classOrInterface = element2.isClassOrInterface()) != JSElementBase.ClassOrInterface.NONE) {
                    boolean isInterface = classOrInterface == JSElementBase.ClassOrInterface.INTERFACE;
                    sink.occurrence(JSClassIndex.KEY, (Object)JSClassIndex.getNameToIndex(elementName, isInterface));
                }
                String namespaceForIndexing = JSQualifiedNameImpl.getNamespaceForIndexing((JSNamespace)element2.getJSNamespace(), (boolean)false);
                if (element2.isNamespaceExplicitlyDeclared()) {
                    String ns;
                    JSQualifiedName namespace = element2.getNamespace();
                    String string = ns = namespace != null ? namespace.getQualifiedName() : "";
                    if (indexedNamespaces == null) {
                        indexedNamespaces = new HashSet<String>();
                    }
                    if (indexedNamespaces.add(ns)) {
                        sink.occurrence(JSIndexKeys.JS_NAMESPACE_MEMBERS_INDEX_KEY, (Object)ns);
                    }
                    if (namespace == null && namespaceForIndexing != null) {
                        sink.occurrence(JSIndexKeys.JS_LOCAL_NAMESPACE_MEMBERS_INDEX_KEY, (Object)namespaceForIndexing);
                    }
                }
                if (namespaceForIndexing == null && !element2.isNamespaceExplicitlyDeclared() || (qNameForIndexing = JSIndexBasedResolveUtil.getQualifiedNameToIndex((JSElementBase)element2)) == null) continue;
                sink.occurrence(JSIndexKeys.JS_SYMBOL_QUALIFIED_NAMES_INDEX_KEY, (Object)qNameForIndexing);
            }
        }
        if ((typedefs = data2.getTypedefs()) != null) {
            for (Pair typedef : typedefs) {
                sink.occurrence(JSIndexKeys.JS_TYPEDEF_INDEX_KEY, (Object)((String)typedef.first));
            }
        }
        if ((baseTypes = data2.getBaseTypes()) != null) {
            HashSet<String> addedBaseTypes = new HashSet<String>();
            HashSet<String> addedSubclasses = new HashSet<String>();
            for (Pair baseType : baseTypes) {
                if (addedBaseTypes.add((String)baseType.first)) {
                    sink.occurrence(JSIndexKeys.JS_BASE_TYPES_INDEX_KEY, (Object)JSBaseTypesIndex.getHierarchyIndexKey((String)baseType.first));
                }
                if (!addedSubclasses.add((String)baseType.second)) continue;
                sink.occurrence(JSIndexKeys.JS_SUBCLASS_INDEX_KEY, (Object)JSBaseTypesIndex.getHierarchyIndexKey((String)baseType.second));
            }
        }
    }

    public static boolean indexImplicitElement(@NotNull JSImplicitElementStructure element2, @Nullable IndexSink sink) {
        if (element2 == null) {
            JSElementIndexingDataStructureImpl.$$$reportNull$$$0(2);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (!handler.indexImplicitElement(element2, sink)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Collection<? extends JSImplicitElementStructure> getImplicitElementStructures() {
        return this.myElements;
    }

    @Nullable
    public Collection<Pair<String, String>> getTypedefs() {
        return this.myTypedefs;
    }

    @Nullable
    public Collection<Pair<String, String>> getBaseTypes() {
        return this.myBaseTypes;
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public boolean isInterfaceExplicitly() {
        return this.myIsInterfaceExplicitly;
    }

    @Nullable
    public Map<String, String> getUserStrings() {
        return this.myUserStrings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataStructureImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "index";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "indexImplicitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

