/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JSMethodNode
extends MemberNodeBase<JSFunction> {
    private final Collection<JSPsiElementBase> myIgnored = Collections.synchronizedCollection(new HashSet());

    public JSMethodNode(JSFunction method, Set<JSFunction> called, Project project, Runnable cancelCallback) {
        super((PsiElement)method, called, project, cancelCallback);
        if (method != null) {
            JSInheritanceUtil.iterateMembersDown((JSPsiElementBase)method, (Processor)new CommonProcessors.CollectProcessor(this.myIgnored));
        }
    }

    protected MemberNodeBase<JSFunction> createNode(JSFunction caller, HashSet<JSFunction> called) {
        return new JSMethodNode(caller, called, this.myProject, this.myCancelCallback);
    }

    protected List<JSFunction> computeCallers() {
        PsiReference[] refs = PsiReference.EMPTY_ARRAY;
        if (this.myMethod instanceof JSFunctionExpression) {
            JSExpression lOperand;
            if (((JSFunction)this.myMethod).getParent() instanceof JSVariable) {
                refs = (PsiReference[])ReferencesSearch.search((PsiElement)((JSFunction)this.myMethod).getParent(), (SearchScope)((JSFunction)this.myMethod).getParent().getUseScope(), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
            } else if (((JSFunction)this.myMethod).getParent() instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)((JSFunction)this.myMethod).getParent()).getLOperand()) instanceof JSDefinitionExpression) {
                refs = (PsiReference[])ReferencesSearch.search((PsiElement)lOperand, (SearchScope)lOperand.getUseScope(), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
            }
        } else {
            List result2 = Collections.synchronizedList(new ArrayList());
            Processor allMethods = Processors.cancelableCollectProcessor(result2);
            JSInheritanceUtil.iterateAllMembersInHierarchy((JSQualifiedNamedElement)((JSQualifiedNamedElement)this.myMethod), (Processor)allMethods);
            ArrayList refsList = new ArrayList();
            for (JSPsiElementBase jSPsiElementBase : result2) {
                refsList.addAll(ReferencesSearch.search((PsiElement)jSPsiElementBase, (SearchScope)jSPsiElementBase.getUseScope(), (boolean)true).findAll());
            }
            refs = refsList.toArray(PsiReference.EMPTY_ARRAY);
        }
        if (refs.length == 0) {
            return Collections.emptyList();
        }
        HashSet<JSFunction> result2 = new HashSet<JSFunction>();
        for (PsiReference psiReference : refs) {
            PsiElement element2;
            if (!(psiReference instanceof JSReferenceExpression) || !((element2 = psiReference.getElement()).getParent() instanceof JSCallExpression)) continue;
            this.addCallExpression((JSCallExpression)element2.getParent(), result2);
        }
        if (((JSFunction)this.myMethod).isConstructor()) {
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSFunction)((JSFunction)this.getMember()))) {
                this.addCallExpression(superCall, result2);
            }
        }
        return new ArrayList<JSFunction>(result2);
    }

    protected void addCallExpression(JSCallExpression callExpression, Collection<JSFunction> result2) {
        JSFunction enclosingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSFunction.class);
        if (enclosingFunction == null || ((JSFunction)this.myMethod).equals((Object)enclosingFunction) || enclosingFunction.isGetProperty() || enclosingFunction.isSetProperty() || this.myIgnored.contains(enclosingFunction) || this.myCalled.contains(enclosingFunction)) {
            return;
        }
        if (enclosingFunction instanceof JSFunctionExpression && (!(enclosingFunction.getParent() instanceof JSVariable) && !(enclosingFunction.getParent() instanceof JSAssignmentExpression) || !JSChangeSignatureHandler.canRefactorFunctionExpression((JSFunctionExpression)enclosingFunction, false))) {
            return;
        }
        boolean canModify = JSInheritanceUtil.processMemberHierarchy((JSQualifiedNamedElement)enclosingFunction, member -> !JSProjectUtil.isInLibrary((PsiElement)member) && member.getContainingFile().isWritable());
        if (!canModify) {
            return;
        }
        for (JSFunction function : JSInheritanceUtil.findTopMethods((JSFunction)enclosingFunction)) {
            boolean b = ReferencesSearch.search((PsiElement)function, (SearchScope)function.getUseScope()).forEach(reference -> {
                if (!(reference instanceof JSReferenceExpression)) {
                    return true;
                }
                PsiElement element2 = reference.getElement();
                if (!(element2.getParent() instanceof JSArgumentList)) {
                    return true;
                }
                return !JSResolveUtil.isEventListenerCall((JSCallExpression)((JSCallExpression)element2.getParent().getParent()));
            });
            if (b) continue;
            return;
        }
        result2.add(enclosingFunction);
    }

    protected void customizeRendererText(ColoredTreeCellRenderer renderer) {
        SimpleTextAttributes attributes = this.isEnabled() ? new SimpleTextAttributes(0, UIUtil.getTreeForeground()) : SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
        renderer.append(JSFormatUtil.formatMethod((JSFunction)((JSFunction)this.myMethod), (int)4353, (int)2), attributes);
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)this.myMethod);
        if (containingClass == null) {
            return;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null && DialectDetector.isActionScript((PsiElement)containingClass)) {
            String packageName = StringUtil.getPackageName((String)qualifiedName);
            String s = JSFormatUtil.formatPackage((String)packageName);
            renderer.append("  (" + s + ")", new SimpleTextAttributes(2, (Color)JBColor.GRAY));
        }
    }

    public PsiElement getElementToSearch() {
        PsiElement p;
        JSFunction function = (JSFunction)this.getMember();
        if (function instanceof JSFunctionExpression && (p = function.getParent()) instanceof JSVariable) {
            return p;
        }
        return function;
    }
}

