/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.rename.JSInlineAutomaticRenamerFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSInlineAutomaticRenamerFactoryBase
implements AutomaticRenamerFactory,
JSInlineAutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(0);
        }
        if (element2 instanceof JSNamedElement) {
            return this.getUseStateVariables((PsiNamedElement)((JSNamedElement)element2)).size() == 2;
        }
        return false;
    }

    @Nullable
    public String getOptionName() {
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element2, String newName, Collection<UsageInfo> usages) {
        return new JSInlineAutomaticRenamer(this, element2, newName);
    }

    @Override
    public void addTemplateVariables(@NotNull TemplateBuilderImpl builder2, @NotNull PsiNamedElement elementToRename, @NotNull String initialName, final @NotNull String variableName) {
        List<JSVariable> variables;
        TextRange textRange;
        if (builder2 == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(1);
        }
        if (elementToRename == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(2);
        }
        if (initialName == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(3);
        }
        if (variableName == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(4);
        }
        if ((textRange = JSInlineAutomaticRenamerFactoryBase.getUseStateSetterRangeToRename(variables = this.getUseStateVariables(elementToRename))) == null) {
            return;
        }
        JSVariable setter = variables.get(1);
        String setterName = setter.getName();
        if (setterName == null) {
            return;
        }
        final boolean capitalize = Character.isUpperCase(setterName.charAt(textRange.getStartOffset()));
        Collection references = ReferencesSearch.search((PsiElement)setter, (SearchScope)new LocalSearchScope((PsiElement)setter.getContainingFile())).findAll();
        MyLookupExpression lookupExpression = new MyLookupExpression(this, initialName, null, null, (PsiElement)setter, false, null){

            public Result calculateResult(ExpressionContext context2) {
                String text;
                TextResult insertedValue = context2.getVariableValue(variableName);
                String string = text = insertedValue != null ? insertedValue.getText() : "";
                if (capitalize) {
                    text = StringUtil.capitalize((String)text);
                }
                return new TextResult(text);
            }
        };
        builder2.replaceElement((PsiElement)setter, textRange, this.getMainVariableName(), (Expression)lookupExpression, true);
        for (PsiReference reference : references) {
            builder2.replaceElement(reference.getElement(), textRange, this.getReferenceVariableName(), this.getMainVariableName(), false);
        }
        builder2.setVariableOrdering(Comparator.comparing(v -> variableName.equals(v.getName())).reversed());
    }

    @NotNull
    private List<JSVariable> getUseStateVariables(@NotNull PsiNamedElement elementToRename) {
        JSReferenceExpression methodNamespace;
        List variables;
        if (elementToRename == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(5);
        }
        List<JSVariable> empty = Collections.emptyList();
        PsiElement parent = elementToRename.getParent();
        if (!(parent instanceof JSDestructuringArray)) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(6);
            }
            return list;
        }
        Object[] elements = ((JSDestructuringArray)parent).getElements();
        if (elements.length != (variables = ContainerUtil.mapNotNull((Object[])elements, e -> (JSVariable)ObjectUtils.tryCast((Object)e, JSVariable.class))).size() || variables.size() != 2 || variables.get(1) == elementToRename) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(7);
            }
            return list;
        }
        JSDestructuringElement destructuringElement = (JSDestructuringElement)ObjectUtils.tryCast((Object)parent.getParent(), JSDestructuringElement.class);
        if (destructuringElement == null) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(8);
            }
            return list;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)destructuringElement.getInitializer(), JSCallExpression.class);
        if (callExpression == null) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(9);
            }
            return list;
        }
        JSReferenceExpression methodReference = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        if (methodReference == null) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (!Objects.equals(methodReference.getReferenceName(), this.getMethodName())) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(11);
            }
            return list;
        }
        JSExpression methodReferenceQualifier = methodReference.getQualifier();
        if (!(methodReferenceQualifier == null || (methodNamespace = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodReferenceQualifier, JSReferenceExpression.class)) != null && methodNamespace.getQualifier() == null && StringUtil.equalsIgnoreCase((CharSequence)methodNamespace.getReferenceName(), (CharSequence)this.getPackageName()))) {
            List<JSVariable> list = empty;
            if (list == null) {
                JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = variables;
        if (list == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private static TextRange getUseStateSetterRangeToRename(@NotNull List<JSVariable> variables) {
        if (variables == null) {
            JSInlineAutomaticRenamerFactoryBase.$$$reportNull$$$0(14);
        }
        if (variables.size() != 2) {
            return null;
        }
        JSVariable data2 = variables.get(0);
        JSVariable setter = variables.get(1);
        String dataName = StringUtil.toLowerCase((String)data2.getName());
        String setterName = setter.getName();
        if (StringUtil.isEmpty((String)dataName) || StringUtil.isEmpty((String)setterName) || setterName.length() <= dataName.length()) {
            return null;
        }
        int idx = StringUtil.indexOfIgnoreCase((String)setterName, (String)dataName, (int)0);
        if (idx == -1) {
            return null;
        }
        return TextRange.create((int)idx, (int)(idx + dataName.length()));
    }

    @NotNull
    protected abstract String getMethodName();

    @NotNull
    protected abstract String getMainVariableName();

    @NotNull
    protected abstract String getReferenceVariableName();

    @NotNull
    protected abstract String getPackageName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/rename/JSInlineAutomaticRenamerFactoryBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSInlineAutomaticRenamerFactoryBase";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseStateVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateVariables";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUseStateVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUseStateSetterRangeToRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private class JSInlineAutomaticRenamer
    extends AutomaticRenamer {
        JSInlineAutomaticRenamer(JSInlineAutomaticRenamerFactoryBase jSInlineAutomaticRenamerFactoryBase, PsiElement element2, String newName) {
            boolean capitalize;
            if (!(element2 instanceof JSNamedElement)) {
                return;
            }
            List<JSVariable> variables = jSInlineAutomaticRenamerFactoryBase.getUseStateVariables((PsiNamedElement)element2);
            if (variables.size() != 2) {
                return;
            }
            TextRange textRange = JSInlineAutomaticRenamerFactoryBase.getUseStateSetterRangeToRename(variables);
            JSVariable data2 = variables.get(0);
            JSVariable setter = variables.get(1);
            String dataName = data2.getName();
            String setterName = setter.getName();
            if (setterName == null || dataName == null) {
                return;
            }
            Object replacement = textRange != null ? textRange.replace(setterName, (capitalize = Character.isUpperCase(setterName.charAt(textRange.getStartOffset()))) ? StringUtil.capitalize((String)newName) : newName) : "set" + StringUtil.capitalize((String)newName);
            this.myElements.add(setter);
            this.suggestAllNames(setterName, (String)replacement);
        }

        protected String suggestNameForElement(PsiNamedElement element2, NameSuggester suggester, String newClassName, String oldClassName) {
            return newClassName;
        }

        public String getDialogTitle() {
            return StringUtil.capitalize((String)JavaScriptBundle.message((String)"rename.react.hook.variable.title", (Object[])new Object[0]));
        }

        public String getDialogDescription() {
            return StringUtil.capitalize((String)JavaScriptBundle.message((String)"rename.react.hook.variable.description", (Object[])new Object[0]));
        }

        public String entityName() {
            return StringUtil.capitalize((String)JavaScriptBundle.message((String)"javascript.language.term.variable", (Object[])new Object[0]));
        }

        public boolean isSelectedByDefault() {
            return true;
        }
    }
}

