/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;

public class JSMemberInfoStorage
extends AbstractMemberInfoStorage<JSAttributeListOwner, JSClass, JSMemberInfo> {
    public JSMemberInfoStorage(JSClass aClass, MemberInfoBase.Filter<JSAttributeListOwner> memberInfoFilter) {
        super((PsiElement)aClass, memberInfoFilter);
    }

    protected boolean isInheritor(JSClass baseClass, JSClass aClass) {
        return JSInheritanceUtil.isParentClass((JSClass)aClass, (JSClass)baseClass);
    }

    protected void extractClassMembers(JSClass aClass, ArrayList<JSMemberInfo> temp) {
        JSMemberInfo.extractClassMembers(aClass, temp, (MemberInfoBase.Filter<? super JSAttributeListOwner>)this.myFilter);
    }

    protected boolean memberConflict(JSAttributeListOwner member1, JSAttributeListOwner member) {
        if (member instanceof JSFunction && member1 instanceof JSFunction) {
            return false;
        }
        return StringUtil.equals((CharSequence)member.getName(), (CharSequence)member1.getName());
    }

    protected void buildSubClassesMap(JSClass aClass) {
        JSReferenceList implementsList;
        JSReferenceList extendsList = aClass.getExtendsList();
        if (extendsList != null) {
            this.buildSubClassesMapForList(extendsList.getReferencedClasses(), aClass);
        }
        if ((implementsList = aClass.getImplementsList()) != null) {
            this.buildSubClassesMapForList(implementsList.getReferencedClasses(), aClass);
        }
    }

    private void buildSubClassesMapForList(JSClass[] classesList, JSClass aClass) {
        for (JSClass superClass : classesList) {
            this.getSubclasses((PsiElement)superClass).add(aClass);
            this.buildSubClassesMap(superClass);
        }
    }
}

